/**
 * Copyright fluxus ( http://wonderfl.net/user/fluxus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sab2
 */

// forked from Fumio's Tween Circles
package {
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.display.BlendMode;
    import fl.transitions.Tween;
    import fl.transitions.easing.Bounce;
    import flash.events.MouseEvent;
    public class TweenCircles extends Sprite {
        private var circleCount:uint = 25;
        private var circles:Vector.<DisplayObject> = new Vector.<DisplayObject>(circleCount);
        private var tweensX:Vector.<Tween> = new Vector.<Tween>(circleCount);
        private var tweensY:Vector.<Tween> = new Vector.<Tween>(circleCount);
        private var activeCount:uint;
        private var delay:Number = 1 / circleCount;
        public function TweenCircles() {
            var nWidth:int = stage.stageWidth;
            var nHeight:int = stage.stageHeight;
            var centerX:Number = nWidth / 2;
            var centerY:Number = nHeight / 2;
            // stage.color = 0x000000;
            setBackground(nWidth, nHeight, 0x0);
            for (var i:uint = 0; i < circleCount; i++) {
                var nX:Number = Math.random() * nWidth;
                var nY:Number = Math.random() * nHeight;
                var circle:Shape = createCircle(10, 0x113355, (i + 1) * 3);
                setAppearance(circle, nX, nY, 1 - i * 0.025, BlendMode.ADD);
                setTween(circle, i, centerX, centerY, (0.5 + i * delay) * 1.5);
                addChild(circle);
            }
            stage.addEventListener(MouseEvent.MOUSE_DOWN, startTween);
        }
        private function createCircle(stroke:Number, color:uint, radius:Number):Shape {
            var circle:Shape = new Shape();
            var myGraphics:Graphics = circle.graphics;
            myGraphics.lineStyle(stroke, color);
            myGraphics.drawCircle(0, 0, radius);
            return circle;
        }
        private function setAppearance(instance:DisplayObject, nX:Number, nY:Number, nAlpha:Number, _blendMode:String):void {
            instance.x = nX;
            instance.y = nY;
            instance.alpha = nAlpha;
            instance.blendMode = _blendMode;
        }
        private function setTween(target:DisplayObject, id:uint, nX:Number, nY:Number, duration:Number):void {
            var tweenX:Tween = new Tween(target, "x", Bounce.easeOut, target.x, nX, duration, true);
            var tweenY:Tween = new Tween(target, "y", Bounce.easeOut, target.x, nY, duration, true);
            circles[id] = target;
            tweensX[id] = tweenX;
            tweensY[id] = tweenY;
        }
        private function startTween(eventObject:MouseEvent):void {
            var nX:Number = eventObject.stageX;
            var nY:Number = eventObject.stageY;
            for (var i:uint = 0; i < circleCount; i++) {
                var circle:DisplayObject = circles[i];
                changeTween(tweensX[i], circle, circle.x, nX);
                changeTween(tweensY[i], circle, circle.y, nY);
            }
        }
        private function changeTween(_tween:Tween, target:DisplayObject, begin:Number, finish:Number):void {
            _tween.stop();
            _tween.begin = begin;
            _tween.finish = finish;
            _tween.start();
        }
        private function setBackground(nWidth:Number, nHeight:Number, color:uint):void {
            var background:Shape = new Shape();
            var myGraphics:Graphics = background.graphics;
            myGraphics.beginFill(color);
            myGraphics.drawRect(0, 0, nWidth, nHeight);
            stage.addChildAt(background, 0);
        }
    }
}