/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/saC8
 */

/*
飛び出る花火

赤青メガネで見ると画面から飛び出るよ。
（ステージが狭いからわかりにくいけど）

赤青メガネによる立体視のことを「アナグリフ」と言います。
http://www.stereoeye.jp/howto/anaglyph.html

*/
package
{
	import flash.events.TimerEvent;
	import flash.events.MouseEvent;
	import flash.utils.Timer;
	import flash.display.*;
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
	
	public class Main extends Sprite
	{	
		function Main(){
			var redFire:Fire = new Fire(true);
			addChild(redFire);
			var blueFire:Fire = new Fire(false);
			addChild(blueFire);
			var timer:Timer = new Timer(2000);
			timer.addEventListener(TimerEvent.TIMER, TIMER);
			timer.start();
			function TIMER(e:TimerEvent):void{
				redFire.timerHandler(e);
				blueFire.timerHandler(e);
			}
		}
	}
}

import flash.display.*;
import flash.events.*;
import flash.utils.*;
import flash.geom.*;
import flash.filters.*;

import org.papervision3d.cameras.*;
import org.papervision3d.materials.*;
import org.papervision3d.objects.*;
import org.papervision3d.objects.primitives.*
import org.papervision3d.view.*;
import org.papervision3d.view.layer.*;
import org.papervision3d.core.render.filter.*;
import org.papervision3d.core.effects.*;
import org.papervision3d.core.effects.utils.*;

import caurina.transitions.Tweener;


class Fire extends BasicView
{	
	private var bfx:BitmapEffectLayer;
	private var _color:int;
	private var myMath:Mas = new Mas();
	/**
	 * Constructor
	 */
	public function Fire(isRed:Boolean)
	{
		if(isRed){
			_color = 0xFF0000;
		}else{
			_color = 0xFF;
		}
		
		// init
		super(0, 0, true, false, CameraType.FREE);
		
		// create the effect layer
		bfx = new BitmapEffectLayer(viewport, 465, 465, true, 0, BitmapClearMode.CLEAR_PRE);
		bfx.addEffect(new BitmapLayerEffect( new BlurFilter(2, 2, 1)));
		bfx.addEffect(new BitmapColorEffect(1.2, 1.15, 1.1, .95));
		bfx.drawCommand = new BitmapDrawCommand(null, new ColorTransform(1, 1, 1, 0.5), BlendMode.ADD);
		bfx.drawLayer.blendMode = BlendMode.ADD;
		viewport.containerSprite.addLayer(bfx);
		
		// create the Field
		var field:Plane = new Plane(new WireframeMaterial(_color, .25), 5000, 5000, 5, 5);
		field.rotationX = 90;
		scene.addChild(field);
		
		// init camera
		
		if(isRed){
			camera.x = -30;
			camera.rotationY = 1;
		}else{
			camera.x = 30;
			camera.rotationY = -1;
		}
		
		camera.y = 200;
		camera.z = -800;
		camera.rotationX = -20;
		camera.focus = 400;
		camera.zoom = 1;
					
					// rotate angle
					/*
		stage.addEventListener(MouseEvent.CLICK, function(event:MouseEvent):void
		{
			camera.y = camera.y == 200 ? 1500 : 200;
			camera.rotationX = camera.rotationX == -20 ? 45 : -20;
		});
		*/
		// render
		startRendering();
	}
	/**
	 * Timer Handler - Give Fireworks
	 * @param	event
	 */
	public function timerHandler(event:TimerEvent):void
	{
		var fireworks:DisplayObject3D = createFireworks();
		fireworks.x = myMath.random() * 500 - 250;
		fireworks.z = myMath.random() * 500 - 250;
		fireworks.y = myMath.random() * 250 + 750;
		fireworks.rotationZ = myMath.random()*180;
		
		scene.addChild(fireworks);
		
		Tweener.addTween(fireworks,
		{
			y          : fireworks.y  - 200,
			time       : 4,
			transition : "easeInSine"
		});
	}
	
	/**
	 * Create Fireworks
	 * @return Fireworks(DisplayObject3D)
	 */
	private function createFireworks():DisplayObject3D
	{
		var fireworks :DisplayObject3D = new DisplayObject3D();
		
		var points:Array = getSpherePoints(300, 10);
		
		//var color:uint = Math.random() * 0xFFFFFF;
		
		for (var i:int = 0; i < points.length; i++ )
		{
			var mat:ColorMaterial = new ColorMaterial(_color);
			mat.doubleSided = true;
			
			var particle:Plane = new Plane(mat, 5, 5, 1, 1);
			
			fireworks.addChild(particle);
			
			bfx.addDisplayObject3D(particle);
			
			Tweener.addTween(particle,
			{
				x     : points[i].x,
				y     : points[i].y,
				z     : points[i].z,
				time  : 3 + myMath.random() * .5,
				transition : "easeOutCubic",
				onCompleteParams : [particle],
				onComplete : function(p:Plane):void
				{
					fireworks.removeChild(p);
					bfx.removeDisplayObject3D(p);
				}
			});
		}
		
		return fireworks;
	}
	
	/**
	 * Get Points of sphere
	 * @param	size
	 * @param	segment
	 * @return  point of shphere
	 */
	private function getSpherePoints(size:int, segment:int):Array
	{
		var points:Array = [];
		var sphere:Sphere = new Sphere(new WireframeMaterial(), size, segment, segment);
		for each(var i:* in sphere.geometry.vertices)
			points.push( { x:i.x+myMath.random()*50, y:i.y+myMath.random()*50, z:i.z+myMath.random()*50 } );
		return points;
	}

}

class Mas{
    private var num:Number = 1;
    public function randomSeed(s:Number):void{
        num = s;
        for (var i:int = 0; i < 100; i++) {
            random();
        }
    }
    public function random():Number{
        num = (num*1664525+1013904223)%0x100000000;
        return num/0x100000000;
    }
}
