/**
 * Copyright raa ( http://wonderfl.net/user/raa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sZzs
 */

// forked from smirnov48's Ice Storm - With bonuses
// forked from smirnov48's Ice Storm - Simple gameplay
// forked from smirnov48's Ice Storm - prototype
// It is based on greentec's DiFFusion-Limited Aggregation
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.net.SharedObject;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.getTimer;
    
    public class FlashTest extends Sprite
    {
        private var _bitmap:Bitmap;
        private var _bitmapData:BitmapData;
        private var _baseBitmap:Bitmap;
        private var _baseBitmapData:BitmapData;
        private var hitBitmapData:BitmapData;
        private var particleNum:int = 10000;
        private var particles:Vector.<Particle> = new Vector.<Particle>();
        private var bullets:Vector.<Bullet> = new Vector.<Bullet>();
        
        private var halfStageWidth:int;
        private var halfStageHeight:int;
        private var tx:Number = 0;
        private var ty:Number = 0;
        private var i:int = 0;
        private var j:int = 0;
        private var n:int = 0;
        private var p:Particle;
        private var b:Bullet;
        
        private var debug:TextField = new TextField();
        private var gameOverLabel:TextField = new TextField();
        private var statistics:TextField = new TextField();
        private var scoreLabel:TextField = new TextField();
        private var base:Vector.<Vector.<int>> = new Vector.<Vector.<int>>(468, true);
        
        private var time:uint = 0;
        private var iq:int = 0;
        private var circleTime:int = 0;
        private var angle:Number = 0.0;
        
        private var start:Boolean;
        private var gameOver:Boolean;
        private var mousePressed:Boolean;
        
        private var _gunData:BitmapData;
        private var _gun:Bitmap;
        private var _effectsData:BitmapData;
        private var _effects:Bitmap;
        
        private var frozenCount:int = 0;
        private var fireLimit:int = 30;
        private var fired:int = 0;
        private var fireTime:int = 200;
        private var fireTimeReg:uint = 0;
        private var lastFireTime:uint = 0;
        
        private const INCREASED_FIRE_TIME:int = 50;
        private const NORMAL_FIRE_TIME:int = 100;
        private var timeBtwFires:int = NORMAL_FIRE_TIME;
        private var timeFastFire:uint;
        
        private var score:uint = 0;
        
        private var _ui:Bitmap;
        private var _uiData:BitmapData;
        
        private const NORMAL_BULLET_POWER:int = 8;
        private const INCREASED_BULLET_POWER:int = 12;
        private var bulletsPower:int = NORMAL_BULLET_POWER;
        
        private var timeIncPower:uint;
        
        public function FlashTest()
        {            
            Wonderfl.capture_delay(5);
            
            halfStageWidth = stage.stageWidth / 2;
            halfStageHeight = stage.stageHeight / 2
            
            for (i = 0; i < 468; i++)
            {
                base[i] = new Vector.<int>(468, true);
            }
            
            for (i = 0; i < 3; i++)
            {
                base[232 + i][232 + 0] = 1;
                base[232 + i][232 + 1] = 1;
                base[232 + i][232 + 2] = 1;
            }
            
            base[232 + 1][232 - 1] = 1;
            base[232 + 1][232 + 3] = 1;
            base[232 - 1][232 + 1] = 1;
            base[232 + 3][232 + 1] = 1;
            base[232 + 1][232 + 1] = 2;
            
            _bitmapData = new BitmapData(465, 465, true, 0xFF292929);
            _bitmap = new Bitmap(_bitmapData);
            addChild(_bitmap);
            
            _baseBitmapData = new BitmapData(465, 465, true, 0x00FFFFFF);
            _baseBitmap = new Bitmap(_baseBitmapData);
            addChild(_baseBitmap);
            
            _gunData = new BitmapData(465, 465, true, 0x00FFFFFF);
            _gun = new Bitmap(_gunData);
            addChild(_gun);
            drawGun();
            
            _effectsData = new BitmapData(465, 465, true, 0x00FFFFFF);
            _effects = new Bitmap(_effectsData);
            addChild(_effects);
            
            _uiData = new BitmapData(stage.stageWidth / 4, stage.stageHeight / 4, true, 0x00FFFFFF);
            _ui = new Bitmap(_uiData);
            _ui.scaleX = 4;
            _ui.scaleY = 4;
            addChild(_ui);
            
            scoreLabel.autoSize = TextFieldAutoSize.CENTER;
            scoreLabel.defaultTextFormat = new TextFormat("Arial", 22, 0xFF0000, true);
            scoreLabel.text = "0";
            scoreLabel.x = stage.stageWidth - 10 - scoreLabel.width;
            scoreLabel.y = stage.stageHeight - 5 - scoreLabel.height;
            addChild(scoreLabel);
            
            initParticles();
            
            debug.textColor = 0xFF0000;
            debug.autoSize = TextFieldAutoSize.CENTER;
            debug.defaultTextFormat = new TextFormat("Arial", 52, 0xFF0000, true);
            debug.x = stage.stageWidth / 2 - debug.width;
            debug.y = stage.stageHeight / 2 - debug.height;
            debug.text = "click to start";
            addChild(debug);
            
            addEventListener(Event.ENTER_FRAME, onLoop);
            stage.addEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function onMouseUp(e:MouseEvent):void
        {
            mousePressed = false;
        }
        
        private function onMouseDown(e:MouseEvent):void
        {
            mousePressed = true;
        }
        
        private function drawGun():void
        {
            var pixels:Vector.<uint> = new Vector.<uint>(5 * 6, true);
            pixels[3 * 5 + 1] = 0xFF808080;
            pixels[3 * 5 + 3] = 0xFF808080;
            pixels[3 * 5 + 0] = 0xFF808080;
            pixels[3 * 5 + 4] = 0xFF808080;
            pixels[2 * 5 + 1] = 0xFF808080;
            pixels[2 * 5 + 2] = 0xFF808080;
            pixels[2 * 5 + 3] = 0xFF808080;
            pixels[4 * 5 + 1] = 0xFF808080;
            pixels[4 * 5 + 2] = 0xFF808080;
            pixels[4 * 5 + 3] = 0xFF808080;
            pixels[1 * 5 + 1] = 0xFF808080;
            pixels[1 * 5 + 2] = 0xFFFF0000;
            pixels[1 * 5 + 3] = 0xFF808080;
            pixels[0 * 5 + 1] = 0xFFFF6A00;
            pixels[0 * 5 + 3] = 0xFFFF6A00;
            _gunData.setVector(new Rectangle(230, 229, 5, 6), pixels);
        }
        
        private function onClick(e:MouseEvent):void
        {
            start = true;
            debug.text = "";
        }
        
        private function onLoop(e:Event):void
        {
            time = getTimer();
            
            _effectsData.fillRect(_effectsData.rect, 0x00FFFFFF);
            _bitmapData.fillRect(_bitmapData.rect, 0xFF292929);
            
            var myMatrix:Matrix = new Matrix();
            myMatrix.scale(4, 4);
            myMatrix.translate(-930, -930);
            myMatrix.rotate(angle);
            angle += 0.01;
            myMatrix.translate(halfStageWidth, halfStageHeight);
            _baseBitmap.transform.matrix = myMatrix;
            _bitmap.transform.matrix = myMatrix;
            _effects.transform.matrix = myMatrix;
            
            myMatrix = new Matrix();
            myMatrix.scale(4, 4);
            myMatrix.translate(-930, -930);
            if (!start || gameOver)
            {
                myMatrix.rotate(angle);
            }
            else
            {
                myMatrix.rotate(Math.atan2(stage.mouseY - halfStageHeight, stage.mouseX - halfStageWidth) + Math.PI / 2);
            }
            myMatrix.translate(halfStageWidth, halfStageHeight);
            _gun.transform.matrix = myMatrix;
            
            if (!gameOver && mousePressed && fired < fireLimit && time - lastFireTime > timeBtwFires)
            {
                lastFireTime = time;
                b = new Bullet(232, 232, (_gun.rotation - _bitmap.rotation - 90) * Math.PI / 180);
                bullets.push(b);
                fired++;
            }
            
            i = 0;
            while (i < bullets.length)
            {
                b = bullets[i];
                if (!b.dead)
                {
                    b.x += b.vx;
                    b.y += b.vy;
                    _effectsData.setVector(new Rectangle(b.x - 2, b.y - 2, 5, 5), b.pixels);
                    b.dead = b.count++ > 20;
                }
                i++;
            }
            
            i = 0;
            while (i < particleNum)
            {
                p = particles[i];
                if (p.frozen)
                {
                    i++;
                    continue;
                }
                
                if (!start)
                {
                    if (Math.sqrt(Math.abs(p.x - 232) * Math.abs(p.x - 232) + Math.abs(p.y - 232) * Math.abs(p.y - 232)) < stage.stageWidth / 12)
                    {
                        if (Math.random() < .5)
                        {
                            p.x = Math.random() * 465;
                            p.y = Math.random() < .5 ? 0 : 465;
                        }
                        else
                        {
                            p.x = Math.random() < .5 ? 0 : 465;
                            p.y = Math.random() * 465;
                        }
                    }
                }
                else
                {
                    if (p.x > 172 && p.x < 292 && p.y > 172 && p.y < 292)
                    {
                        j = 0;
                        while (j < bullets.length)
                        {
                            b = bullets[j];
                            if (!b.dead && Math.abs(b.x - 232) > 3 && Math.abs(b.y - 232) > 3)
                            {
                                if (Math.sqrt(Math.abs(p.x - b.x) * Math.abs(p.x - b.x) + Math.abs(p.y - b.y) * Math.abs(p.y - b.y)) < bulletsPower)
                                {
                                    if (p.type == 1)
                                    {
                                        timeIncPower = time;
                                        bulletsPower = INCREASED_BULLET_POWER;
                                    }
                                    
                                    if (p.type == 2)
                                    {
                                        timeFastFire = time;
                                        timeBtwFires = INCREASED_FIRE_TIME;
                                    }
                                    
                                    if (p.type == 3)
                                    {
                                        fired = 0;
                                    }
                                    
                                    p.type = 0;
                                    
                                    if (!gameOver)
                                    {
                                        score++;
                                        scoreLabel.text = score.toString();
                                        scoreLabel.x = stage.stageWidth - 10 - scoreLabel.width;
                                        scoreLabel.y = stage.stageHeight - 5 - scoreLabel.height;
                                    }
                                    
                                    if (Math.random() < .5)
                                    {
                                        p.x = Math.random() * 465;
                                        p.y = Math.random() < .5 ? 0 : 465;
                                    }
                                    else
                                    {
                                        p.x = Math.random() < .5 ? 0 : 465;
                                        p.y = Math.random() * 465;
                                    }
                                }
                            }
                            j++;
                        }
                    }
                }
                
                tx = Math.round(p.x);
                ty = Math.round(p.y);
                
                if (base[tx + 0][ty + 0] || base[tx + 0][ty + 1] || base[tx + 0][ty + 2] || base[tx + 1][ty + 0] || base[tx + 1][ty + 1] || base[tx + 1][ty + 2] || base[tx + 2][ty + 0] || base[tx + 2][ty + 1] || base[tx + 2][ty + 2])
                {
                    base[tx + 1][ty + 1] = 4;
                    p.frozen = true;
                    frozenCount++;
                }
                else
                {
                    p.vx += Math.random() * .05 - .025;
                    p.vy += Math.random() * .05 - .025;
                    p.x += p.vx;
                    p.y += p.vy;
                    
                    if (p.x > 465)
                    {
                        p.x -= 465;
                    }
                    else if (p.x < 0)
                    {
                        p.x += 465;
                    }
                    
                    if (p.y > 465)
                    {
                        p.y -= 465;
                    }
                    else if (p.y < 0)
                    {
                        p.y += 465;
                    }
                    if (p.type == 0)
                    {
                        _bitmapData.setPixel32(p.x, p.y, 0x20FFFFFF);
                    }
                    if (p.type == 1)
                    {
                        _bitmapData.setPixel32(p.x - 1, p.y, 0x38FF0000);
                        _bitmapData.setPixel32(p.x, p.y - 1, 0x38FF0000);
                        _bitmapData.setPixel32(p.x, p.y, 0xFFFF0000);
                        _bitmapData.setPixel32(p.x, p.y + 1, 0x38FF0000);
                        _bitmapData.setPixel32(p.x + 1, p.y, 0x38FF0000);
                    }
                    if (p.type == 2)
                    {
                        _bitmapData.setPixel32(p.x - 1, p.y, 0x3800FF00);
                        _bitmapData.setPixel32(p.x, p.y - 1, 0x3800FF00);
                        _bitmapData.setPixel32(p.x, p.y, 0xFF00FF00);
                        _bitmapData.setPixel32(p.x, p.y + 1, 0x3800FF00);
                        _bitmapData.setPixel32(p.x + 1, p.y, 0x3800FF00);
                    }
                    if (p.type == 3)
                    {
                        _bitmapData.setPixel32(p.x - 1, p.y, 0x380000FF);
                        _bitmapData.setPixel32(p.x, p.y - 1, 0x380000FF);
                        _bitmapData.setPixel32(p.x, p.y, 0xFF0000FF);
                        _bitmapData.setPixel32(p.x, p.y + 1, 0x380000FF);
                        _bitmapData.setPixel32(p.x + 1, p.y, 0x380000FF);
                    }
                }
                i++;
            }
            
            draw();
            
            if (frozenCount > 100)
            {
                gameOver = true;
                debug.text = "Game Over";
                if (debug.visible)
                {
                    debug.visible = false;
                    
                    gameOverLabel.autoSize = TextFieldAutoSize.CENTER;
                    gameOverLabel.defaultTextFormat = new TextFormat("Arial", 52, 0xFF0000, true);
                    gameOverLabel.text = "GAME OVER";
                    gameOverLabel.x = halfStageWidth - gameOverLabel.width / 2;
                    gameOverLabel.y = halfStageHeight / 2 - gameOverLabel.height / 2;
                    addChild(gameOverLabel);
                    
                    var so:SharedObject = SharedObject.getLocal("FrozenStorm");
                    var bestScore:int = so.data.bestScore;
                    statistics.autoSize = TextFieldAutoSize.CENTER;
                    var tf:TextFormat = new TextFormat("Arial", 32, 0xFF0000, true)
                    tf.align = "center";
                    statistics.defaultTextFormat = tf;
                    
                    if (!bestScore || score > bestScore)
                    {
                        statistics.text = "NEW RECORD!\nScore:" + score.toString();
                        statistics.y += halfStageHeight / 4;
                        so.data.bestScore = score;
                        so.flush();
                    }
                    else
                    {
                        statistics.text = "Score:" + score.toString();
                    }
                    statistics.x = halfStageWidth - statistics.width / 2;
                    statistics.y = halfStageHeight + halfStageHeight / 2 - statistics.height / 2;
                    addChild(statistics);
                }
            }
            
            if (!gameOver && fired > 0 && time - fireTimeReg > fireTime)
            {
                fireTimeReg = time;
                fired--;
            }
            
            i = 0;
            while (i < fireLimit)
            {
                if (i < fired)
                {
                    _uiData.setPixel32(5 + fireLimit - i, stage.stageHeight / 4 - 6, 0xFFFF0000);
                }
                else
                {
                    _uiData.setPixel32(5 + fireLimit - i, stage.stageHeight / 4 - 6, 0xFF00FF00);
                }
                i++;
            }
            
            if (time - timeIncPower > 3000)
            {
                bulletsPower = NORMAL_BULLET_POWER;
            }
            
            if (time - timeFastFire > 3000)
            {
                timeBtwFires = NORMAL_FIRE_TIME;
            }
        }
        
        private function draw():void
        {
            for (var i:int = 1; i < 466; i++)
            {
                for (var j:int = 1; j < 466; j++)
                {
                    if (base[i][j] == 1)
                    {
                        _baseBitmapData.setPixel32(i - 1, j - 1, 0xFFA0A0A0);
                    }
                    if (base[i][j] == 2)
                    {
                        _baseBitmapData.setPixel32(i - 1, j - 1, 0xFF00FF00);
                    }
                    if (base[i][j] == 4)
                    {
                        _baseBitmapData.setPixel32(i - 1, j - 1, 0xFF00FFFF);
                    }
                }
            }
        }
        
        private function initParticles():void
        {
            var p:Particle;
            for (i = 0; i < particleNum; i += 1)
            {
                p = new Particle(Math.random() * 465, Math.random() * 465);
                particles.push(p);
            }
        }
    }
}

class Particle
{
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var type:int;
    public var frozen:Boolean;
    
    public function Particle(x:Number, y:Number)
    {
        this.x = x;
        this.y = y;
        vx = Math.random() * .1 - .05;
        vy = Math.random() * .1 - .05;
        type = 0;
        var r:Number = Math.random();
        if (r < 0.005)
        {
            type = 1;
        }
        else if (r < 0.010)
        {
            type = 2;
        }
        else if (r < 0.020)
        {
            type = 3;
        }
    }
}

class Bullet
{
    public var x:Number;
    public var y:Number;
    public var vx:Number;
    public var vy:Number;
    public var dead:Boolean;
    public var pixels:Vector.<uint> = new Vector.<uint>(5 * 5, true);
    public var count:int = 0;
    
    public function Bullet(x:Number, y:Number, angle:Number)
    {
        this.x = x;
        this.y = y;
        this.vx = Math.cos(angle + Math.random() / 2 - 0.25) * 3;
        this.vy = Math.sin(angle + Math.random() / 2 - 0.25) * 3;
        
        pixels[0 * 5 + 0] = 0x00000000;
        pixels[0 * 5 + 1] = 0x00000000;
        pixels[0 * 5 + 2] = 0x9FFF0000;
        pixels[0 * 5 + 3] = 0x00000000;
        pixels[0 * 5 + 4] = 0x00000000;
        
        pixels[1 * 5 + 0] = 0x00000000;
        pixels[1 * 5 + 1] = 0xFFFF0000;
        pixels[1 * 5 + 2] = 0xFFFF6A00;
        pixels[1 * 5 + 3] = 0xFFFF0000;
        pixels[1 * 5 + 4] = 0x00000000;
        
        pixels[2 * 5 + 0] = 0xFFFF0000;
        pixels[2 * 5 + 1] = 0xFFFF6A00;
        pixels[2 * 5 + 2] = 0xFFFF0000;
        pixels[2 * 5 + 3] = 0xFFFF6A00;
        pixels[2 * 5 + 4] = 0xFFFF0000;
        
        pixels[0 * 5 + 0] = 0x00000000;
        pixels[3 * 5 + 1] = 0xFFFF0000;
        pixels[3 * 5 + 2] = 0xFFFF6A00;
        pixels[3 * 5 + 3] = 0xFFFF0000;
        pixels[0 * 5 + 4] = 0x00000000;
        
        pixels[4 * 5 + 0] = 0x00000000;
        pixels[4 * 5 + 1] = 0x00000000;
        pixels[4 * 5 + 2] = 0xFFFF0000;
        pixels[4 * 5 + 3] = 0x00000000;
        pixels[4 * 5 + 4] = 0x00000000;
    }
}