/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sYpF
 */

// forked from makc3d's Simple cannon
package  
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import flash.utils.Timer;
	import flash.events.TimerEvent;

    [SWF(width=465, height=465, frameRate=60, backgroundColor=0xFFFFFF)] 

	/**
	* Simple canon.
	* @author makc
	* @license WTFPLv2, http://sam.zoy.org/wtfpl/ 
	*/
	public class Cannon extends Sprite 
	{
		public function Cannon () 
		{
			stage.addEventListener (Event.ENTER_FRAME, loop);
//			stage.addEventListener (MouseEvent.CLICK, fire);

			var timer:Timer = new Timer(50);
			timer.addEventListener(TimerEvent.TIMER, fire);
			timer.start();
		}

		// origin
		private var o:Point = new Point (465 / 2, 350);
		// acceleration (gravity)
		private var a:Point = new Point (0, 0.1);

		// bullets
		public var bullets:Array = [];

		public function loop (e:Event):void
		{
			// draw ground
			graphics.clear ();
			graphics.lineStyle ();
			graphics.beginFill (0xA0FFA0);
			graphics.drawRect (0, o.y, 465, 465 - o.y);

			// direction from origin to mouse
			var d:Point = new Point (mouseX, Math.min (o.y, mouseY)).subtract (o);
			// normalize it to gun length
			d.normalize (25);

			// draw the gun and aim line
			graphics.lineStyle (5, 0);
			graphics.moveTo (o.x, o.y); graphics.lineTo (o.x + d.x, o.y + d.y);
			graphics.lineStyle (0, 0xA0FFA0);
			graphics.lineTo (mouseX, Math.min (o.y, mouseY));

			graphics.endFill();
			graphics.moveTo (o.x, o.y);

			
			var lastPt:Object = null;
//			for each (var b:Bullet in bullets)
			for (var i:int = bullets.length-1;  i >= 0; i--)
			{
				var  b:Bullet = bullets[i];
				// draw the bullet
//				graphics.lineStyle ();
//				graphics.beginFill (0xFF0000);
//				graphics.drawCircle (b.p.x, b.p.y, 2);
//				graphics.endFill();
				
				if (lastPt)
				{
					graphics.lineStyle (Math.min(Math.random()*0+40, i), (i / bullets.length) * 0xff);
					graphics.curveTo(lastPt.x, lastPt.y, b.p.x, b.p.y);
					lastPt = null;
				}
				else
				{
					lastPt = b.p;
				}
				

				// if it's on the ground
				if (b.p.y > o.y) {
					b.p.y = o.y;
					b.v.y *= -0.3;
					
					if (b.v.y > -a.y*10)
					{
						bullets.splice(i, 1);
						i--;
						continue;
					}
				}

					// apply velocity
					b.p = b.p.add (b.v);

					// apply gravity
					b.v = b.v.add (a);

					// stop once we hit the ground
//					b.p.y = Math.min (o.y, b.p.y);
//				}
			}
		}

//		public function fire (e:MouseEvent):void {
		public function fire (e:TimerEvent):void {
			// make new Bullet
			var b:Bullet = new Bullet;

			// init velocity with direction to mouse
			b.v = new Point (mouseX, Math.min (o.y, mouseY)).subtract (o);

			// scale velocity vector for reasonably small speed
			b.v.x *= 0.02 * 1.5;
			b.v.y *= 0.02 * 2;

			// position: we start where the gun ends
			b.p = b.v.clone (); b.p.normalize (25); b.p = b.p.add (o);

			// put the bullet on our list
			bullets.push (b);
		}
	}
}

import flash.geom.Point;
class Bullet {
	// position
	public var p:Point;
	// velocity
	public var v:Point;
}