/**
 * Copyright flashisobar ( http://wonderfl.net/user/flashisobar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sYhz
 */

package 
{
    import away3d.cameras.Camera3D;
    import away3d.containers.ObjectContainer3D;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.controllers.HoverController;
    import away3d.debug.AwayStats;
    import away3d.events.LoaderEvent;
    import away3d.lights.DirectionalLight;
    import away3d.lights.LightBase;
    import away3d.lights.PointLight;
    import away3d.loaders.Loader3D;
    import away3d.loaders.parsers.Parsers;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.primitives.SkyBox;
    import away3d.textures.BitmapCubeTexture;
    import away3d.tools.helpers.LightsHelper;
    import away3d.utils.Cast;
    import flash.display.Bitmap;
    import flash.filters.DropShadowFilter;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import jp.progression.commands.lists.LoaderList;
    import jp.progression.commands.net.LoadBitmapData;
    import jp.progression.data.getResourceById;
    
    import flash.system.LoaderContext;
    import flash.system.Security;
    //import flash.desktop.NativeApplication;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.MouseEvent;
    import flash.events.TransformGestureEvent;
    import flash.geom.Vector3D;
    import flash.net.URLRequest;
    import flash.ui.Multitouch;
    import flash.ui.MultitouchInputMode;
    import flash.utils.getTimer;
    
    /**
     * Away3D android Demo
     * 
     * performance killer
     * 1. don't use dynamic shadows
     * 2. don't use particles system
     * 3. don't use too many lights
     * 4. don't use smooth bitmap texture
     * 5. don't use larger texture(>512x512) especially on iPad1 and HTC Desire
     * 6. don't use skybox
     * 
     * @author flashisobar http://flashisobar.blogspot.com
     */
    [SWF(width="465",height="465",frameRate="30",backgroundColor="0x0")]
    public class Main extends Sprite 
    {
        private const BASE_URL:String = "http://labs-baybow.rhcloud.com/";
        
        // Be careful with skybox
        private var arrSkyboxMap:Array = [
                        "snow_positive_x.jpg",
                        "snow_positive_y.jpg",
                        "snow_positive_z.jpg",
                        "snow_negative_x.jpg",
                        "snow_negative_y.jpg",
                        "snow_negative_z.jpg"
                    ]
        private var skybox:SkyBox;
        
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var view:View3D;
        private var move:Boolean;
        private var lastPanAngle:Number;
        private var lastTiltAngle:Number;
        private var lastMouseX:Number;
        private var lastMouseY:Number;
        private var stats:AwayStats;
        private var plight:PointLight;
        private var sunLight:DirectionalLight;
        private var lightPicker:StaticLightPicker;
        private var _objContainer:ObjectContainer3D;
        private var _loader:Loader3D;
        private var cameraController:HoverController;
        private var _cameraDistance:Number = 500;
        private var _text:TextField;
        
        ///private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);
        
        public function Main():void 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            //stage.addEventListener(Event.DEACTIVATE, deactivate);
            
            // touch or gesture?
            //Multitouch.inputMode = MultitouchInputMode.TOUCH_POINT;
            Multitouch.inputMode = MultitouchInputMode.GESTURE;
            
            // entry point
            Wonderfl.disable_capture();
            Security.loadPolicyFile('http://labs-baybow.rhcloud.com/crossdomain.xml');
            
            ///addChild(new Bitmap(source));
            initText();
            initLoading();
        }

        private function initLoading():void 
        {
            var loaderlist:LoaderList = new LoaderList();
            loaderlist.onStart = function():void {
                trace("onStart");
            }
            loaderlist.onProgress = function():void {
                trace("onProgress:", this.percent, "%", this.loaded, "/", this.total);
                _text.text = "loading texture: "+ int(this.percent)+" %";
            }
            loaderlist.onComplete = function():void {
                trace("onComplete");
                _text.text = "loading 3D model";
                Parsers.enableAllBundled();
                _loader = new Loader3D();
                _loader.scale(2);
                _loader.addEventListener(LoaderEvent.RESOURCE_COMPLETE, onResourceComplete);
                _loader.addEventListener(LoaderEvent.LOAD_ERROR, onLoadError);
                _loader.load(new URLRequest(BASE_URL + 'assets/3d/ship.awd'));

            }
            for (var i:int = 0; i < arrSkyboxMap.length; i++) 
            {
                loaderlist.addCommand(new LoadBitmapData(new URLRequest(BASE_URL + "assets/" +arrSkyboxMap[i]), { context: new LoaderContext(true), resId:"map" + i } ));
            }
            loaderlist.execute();
        }

        private function initListener():void 
        {
            addEventListener(Event.ENTER_FRAME, _onEnterFrame);

            addEventListener(Event.ADDED_TO_STAGE, _onAddedToStage);
            _onAddedToStage();
            
            // gesture
            stage.addEventListener(TransformGestureEvent.GESTURE_ZOOM, _onZoomHandler);
            
            // resize
            stage.addEventListener(Event.RESIZE, onResize);
            onResize();
            
        }
        
        private function initText():void
        {
            _text = new TextField();
            _text.defaultTextFormat = new TextFormat("Arial", 11, 0xFFFFFF);
            _text.width = 240;
            _text.height = 100;
            _text.selectable = false;
            _text.mouseEnabled = false;
            _text.text = "loading texture: 0 %";
            _text.filters = [new DropShadowFilter(1, 45, 0x0, 1, 0, 0)];

            addChild(_text);
        }
        
        private function init3D():void 
        {
            scene = new Scene3D();
            camera = new Camera3D();
            camera.x = 0;
            camera.y = 100
            camera.z = -1000
            camera.lookAt(new Vector3D());
            
            cameraController = new HoverController(camera, null, 45, 20);
            cameraController.distance = _cameraDistance;
            
            view = new View3D();
            view.backgroundColor = 0x222233;
            view.antiAlias = 2;
            view.scene = scene;
            view.camera = camera;
            addChild(view);
            
            // light
            // create a light for shadows that mimics the sun's position in the skybox
            sunLight = new DirectionalLight();
            sunLight.direction = new Vector3D(-1, -1, -1);
            sunLight.ambient = .1;
            sunLight.diffuse = .7;
            scene.addChild(sunLight);
            
            plight = new PointLight();
            plight.position = new Vector3D(0, 100, -1000);
            plight.color = 0xFFFFFF;
            plight.specular = .1;
            plight.diffuse = .7;
            plight.radius = 2000;
            plight.fallOff = 2500;
            scene.addChild(plight);
            
            lightPicker = new StaticLightPicker([sunLight, plight]);
            
            var cubeTexture:BitmapCubeTexture = new BitmapCubeTexture(Cast.bitmapData(getResourceById("map0").data), Cast.bitmapData(getResourceById("map3").data), Cast.bitmapData(getResourceById("map1").data), Cast.bitmapData(getResourceById("map4").data), Cast.bitmapData(getResourceById("map2").data), Cast.bitmapData(getResourceById("map5").data))
            skybox = new SkyBox(cubeTexture);
            scene.addChild(skybox);
            
            // add 3D Object
            _objContainer = new ObjectContainer3D();
            scene.addChild(_objContainer);
            _objContainer.addChild(_loader);
            // apply lights
            var lights:Vector.<LightBase> = new Vector.<LightBase>(2);
            lights[0] = sunLight;
            lights[1] = plight;
            LightsHelper.addStaticLightsToMaterials(_loader, lights);
            
            //add stats panel
            stats = new AwayStats(view);
            stats.x = stage.stageWidth - stats.width;
            addChild(stats);
        }
        
        private function onResourceComplete(ev:LoaderEvent):void
        {
            _loader.removeEventListener(LoaderEvent.RESOURCE_COMPLETE, onResourceComplete);
            _loader.removeEventListener(LoaderEvent.LOAD_ERROR, onLoadError);
            _loader.x = 400;

            init3D();
            initListener();

            _text.text = "Mouse click and drag\n";
            _text.appendText("3D model by SolCommand\n");
        }
        
        private function onLoadError(ev:LoaderEvent):void
        {
            trace('Could not find', ev.url);
            _loader.removeEventListener(LoaderEvent.RESOURCE_COMPLETE, onResourceComplete);
            _loader.removeEventListener(LoaderEvent.LOAD_ERROR, onLoadError);
            _loader = null;
        }
        
        private function onResize(event:Event = null):void
        {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        }
        
        private function _onAddedToStage(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, _onAddedToStage);

            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function onMouseUp(e:MouseEvent):void 
        {
            move = false;
            stage.removeEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
        }
        
        private function onMouseDown(event:MouseEvent):void
        {
            lastPanAngle = cameraController.panAngle;
            lastTiltAngle = cameraController.tiltAngle;
            lastMouseX = stage.mouseX;
            lastMouseY = stage.mouseY;
            move = true;
            stage.addEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
        }
        
        private function onStageMouseLeave(event:Event):void
        {
            move = false;
            stage.removeEventListener(Event.MOUSE_LEAVE, onStageMouseLeave);
        }
        
        private function _onZoomHandler(e:TransformGestureEvent):void 
        {
            _cameraDistance = _cameraDistance / ((e.scaleX + e.scaleY) * .5);
            cameraController.distance = _cameraDistance;
            if (_cameraDistance < 50)
                _cameraDistance = 50;
            if (_cameraDistance > 1000)
                _cameraDistance = 1000;
        }
        
        private function _onEnterFrame(e:Event):void
        {
            var msec:Number = getTimer();
            
            // update camera position
            //camera.x = 1500 * Math.sin(msec / 1200);
            //camera.z = 1500 * Math.cos(msec / 1200);
            //camera.y = 500 * Math.sin(msec / 3000) + 100;
            //camera.lookAt(new Vector3D());
            if (move)
            {
                cameraController.panAngle = 0.3 * (stage.mouseX - lastMouseX) + lastPanAngle;
                cameraController.tiltAngle = 0.3 * (stage.mouseY - lastMouseY) + lastTiltAngle;
            }
            plight.position = camera.position;
            
            // update 3D object
            _objContainer.rotationY += 1;
            view.render();
            ///view.renderer.queueSnapshot(source);
        }

        private function deactivate(e:Event):void 
        {
            // auto-close
            //NativeApplication.nativeApplication.exit();
        }
        
    }
    
}
