/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sXxC
 */

package  
{
    import com.adobe.utils.DateUtil;
    import com.bit101.components.Calendar;
    import com.bit101.components.ComboBox;
    import com.bit101.components.HBox;
    import com.bit101.components.InputText;
    import com.bit101.components.Label;
    import com.bit101.components.Panel;
    import com.bit101.components.PushButton;
    import com.bit101.components.VBox;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.utils.getTimer;
    
    /**
     * 何年何月何週目の何曜日が何日かを求める。
     * ordinal は 0 が1週目、 -1 がその月の最後の週
     * 勝手に載せたので問題あったら消ます。
     * @see http://f-site.org/articles/2010/12/14131039.html
     * @see http://twitter.com/bkzen/statuses/14653685795655680
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class Test2 extends Sprite 
    {
        private const WEEK: Array = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        private const MONTH: Array = [
            "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"
        ];
        private var year: InputText;
        private var month: ComboBox;
        private var ordinal: InputText;
        private var day: ComboBox;
        private var calA: Calendar;
        private var calB: Calendar;
        private var modalSp:Sprite;
        
        public function Test2() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            calA = new Calendar(), calB = new Calendar();
            var panel: Panel = new Panel(this);
            panel.setSize(200, 120);
            var hbox: HBox, vbox: VBox;
            vbox = new VBox(panel.content);
            
            hbox = new HBox(vbox);
            new Label(hbox, 0, 0, "year\t\t:");
            year = new InputText(hbox, 0, 0, "2011");
            year.restrict = "0-9", year.maxChars = 4;
            hbox.draw();
            
            hbox = new HBox(vbox);
            new Label(hbox, 0, 0, "month\t:");
            month = new ComboBox(hbox, 0, 0, MONTH[0], MONTH);
            month.selectedIndex = 0;
            hbox.draw();
            
            hbox = new HBox(vbox);
            new Label(hbox, 0, 0, "ordinal\t:");
            ordinal = new InputText(hbox, 0, 0, "-1");
            ordinal.restrict = "0-9\\-", ordinal.maxChars = 2;
            hbox.draw();
            
            hbox = new HBox(vbox);
            new Label(hbox, 0, 0, "week\t\t:");
            day = new ComboBox(hbox, 0, 0, WEEK[0], WEEK);
            day.selectedIndex = 0;
            hbox.draw();
            
            vbox.draw();
            new PushButton(panel.content, 50, vbox.height + vbox.spacing, "What's the date?", onClickBtn);
            panel.move(stage.stageWidth - panel.width >> 1, stage.stageHeight - panel.height >> 1);
            
            modalSp = new Sprite();
            modalSp.graphics.beginFill(0, 0.3);
            modalSp.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            modalSp.addEventListener(MouseEvent.CLICK, onClickModal);
        }
        
        private function onClickModal(e:MouseEvent):void 
        {
            removeChild(modalSp);
            removeChild(calA);
            removeChild(calB);
        }
        
        private function onClickBtn(e: Event):void 
        {
            var y: int, m: int, o: int, d: int;
            if ((y = int(year.text)) < 1) year.text = String(y = 2011);
            m = month.selectedIndex;
            if ((o = int(ordinal.text)) == 0) ordinal.text = "0";
            d = day.selectedIndex;
            calA.setDate(xGetNthDay(y, m + 1, o, d)), calA.draw();
            calB.setDate($(y, m + 1, o, d)), calB.draw();
            calA.x = (stage.stageWidth  >> 1) - calA.width  >> 1;
            calA.y = (stage.stageHeight >> 1) - calA.height >> 1;
            calB.x = (stage.stageWidth  >> 1) + ((stage.stageWidth  >> 1) - calB.width  >> 1);
            calB.y = (stage.stageHeight >> 1) - calB.height >> 1;
            addChild(modalSp);
            addChild(calA);
            addChild(calB);
        }
        
        /**
         * @see http://f-site.org/articles/2010/12/14131039.html
         * @param    nYear
         * @param    nMonth
         * @param    nOrdinal
         * @param    nDay
         * @return
         */
        private function xGetNthDay(nYear:uint, nMonth:uint, nOrdinal:int = 0, nDay:int = 0):Date {
            var _date:Date;
            var nThisMonth:uint;
            if (nOrdinal > -1) {  // 月初から数えるとき
                _date = new Date(nYear, nMonth - 1, 1);
                nThisMonth = _date.month;
                nDay = (nDay - _date.day + 7) % 7 + nOrdinal * 7;
            } else {  // 月末から遡るとき
                _date = new Date(nYear, nMonth, 0);
                nThisMonth = _date.month;
                nDay = (nDay - _date.day - 7) % 7 + (nOrdinal + 1) * 7;
            }
            _date.date +=  nDay;
            if (_date.month != nThisMonth) {
                _date = null;
            }
            return _date;
        }
    }
}
/**
 * @see http://twitter.com/bkzen/statuses/14653685795655680
 * @param    y
 * @param    m
 * @param    o
 * @param    d
 * @return
 */
function $(y:uint,m:int,o:int=0,d:int=0):Date{var k:*=o>>-1,r:*=new Date(y,m+~k,1+k);d-=r.day;!d&&(o-=k);r.date+=d+7*(o-(d>>-1));return r;}
