/**
 * Copyright devon_o ( http://wonderfl.net/user/devon_o )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sXh7
 */

package
{
    import com.adobe.utils.AGALMiniAssembler;
    import com.bit101.components.HUISlider;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display3D.Context3D;
    import flash.display3D.Context3DProgramType;
    import flash.display3D.Context3DVertexBufferFormat;
    import flash.display3D.IndexBuffer3D;
    import flash.display3D.Program3D;
    import flash.display3D.VertexBuffer3D;
    import flash.events.Event;
    import flash.geom.Matrix3D;

    [SWF(width="465", height="465", frameRate="60", backgroundColor="#000000")]
    public class Foo extends Sprite
    {
   
        private var mContext3d:Context3D;
        private var mVertBuffer:VertexBuffer3D;
        private var mIndexBuffer:IndexBuffer3D; 
        private var mProgram:Program3D;
        
        private var mSpeedSlider:HUISlider;
        
        private var mMatrix:Matrix3D = new Matrix3D();
        
        
        public function Foo()
        {    
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);    
        }
        
        private function init(event:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            initStage();
            initUI();
            setS3d();
    
            addEventListener(Event.ENTER_FRAME, onTick);
        }
        
        private function initUI():void
        {
            mSpeedSlider = new HUISlider(this, 5, 5, "Speed", onSpeedChange);
            mSpeedSlider.tick = .00011;
            mSpeedSlider.minimum = .01;
            mSpeedSlider.maximum = .1;
            mSpeedSlider.value = .025;
        }
        
        private function onSpeedChange(event:Event):void{}
        
        private function setS3d():void
        {
            stage.stage3Ds[0].addEventListener( Event.CONTEXT3D_CREATE, initStage3d );
            stage.stage3Ds[0].requestContext3D();
        }
        
        private function initStage():void
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
        }
        
        private function initStage3d(event:Event):void
        {
            mContext3d = stage.stage3Ds[0].context3D;        
            mContext3d.enableErrorChecking = false;
            
            mContext3d.configureBackBuffer(stage.stageWidth, stage.stageHeight, 4, true);
            
            var vertices:Vector.<Number> = Vector.<Number> ([
            //    X,        Y,        Z,        r,    g,    b,        u,    v,        cx, cy, flag
                -1.0,    -1.0,    0.0,    1,    0,    1,        0,    0,        0.2, 0.4, 1.0,
                1.0,    -1.0,    0.0,    1,    0,    0,        1,    0,        0.2, 0.4, 1.0,
                1.0,    1.0,    0.0,    0,    1,    0,        1,    1,        0.2, 0.4, 1.0,
                -1.0,    1.0,    0.0,    1,    0,    1,        0,  1,        0.2, 0.4, 1.0
            ]);
            
            mVertBuffer = mContext3d.createVertexBuffer(vertices.length / 11, 11);
            mVertBuffer.uploadFromVector(vertices, 0, vertices.length / 11);
            mContext3d.setVertexBufferAt( 0, mVertBuffer,  0, Context3DVertexBufferFormat.FLOAT_3 );
            mContext3d.setVertexBufferAt( 1, mVertBuffer,  6, Context3DVertexBufferFormat.FLOAT_2 );
            mContext3d.setVertexBufferAt( 2, mVertBuffer,  3, Context3DVertexBufferFormat.FLOAT_3 );
            mContext3d.setVertexBufferAt( 3, mVertBuffer,  8, Context3DVertexBufferFormat.FLOAT_3 );
            
            mIndexBuffer = mContext3d.createIndexBuffer(6);            
            mIndexBuffer.uploadFromVector (Vector.<uint>([0, 1, 2, 2, 3, 0]), 0, 6);
            
            generateProgram();
            
            mContext3d.setProgram(mProgram);
        }
        
        
        private function generateProgram():void
        {
            var vertexShaderAssembler : AGALMiniAssembler = new AGALMiniAssembler();
            vertexShaderAssembler.assemble( Context3DProgramType.VERTEX,
                "m44 op, va0, vc0   \n" +
                "mov v0, va1        \n" +
                "mov v1, va2        \n" +
                "mov v2, va3            " 
            );
            
            var fragmentShaderAssembler : AGALMiniAssembler= new AGALMiniAssembler();
            fragmentShaderAssembler.assemble( Context3DProgramType.FRAGMENT,
                "mov ft0, fc0                \n" +
                "mov ft0.x, fc1.x            \n" +
                "mov ft0.y, fc1.y            \n" +
                "mov ft1, fc0                \n" +
                "mov ft1.x, fc1.z            \n" +
                "mov ft1.y, fc1.w            \n" +
                "div ft2, v0.xy, fc0.xy        \n" +
                "mul ft2, ft2, fc2.y        \n" +
                "sub ft2, ft2, fc2.x        \n" +
                "mov ft3, fc0                \n" +
                "sub ft3, ft2.xy, ft0.xy    \n" +
                "dp3 ft3, ft3, ft3            \n" +
                "mul ft3, ft3, fc2.z        \n" +
                "mov ft4, fc0                \n" +
                "add ft4, ft2.xy, ft1.xy    \n" +
                "dp3 ft4, ft4, ft4            \n" +
                "mul ft4, ft4, fc2.w        \n" +
                "mov ft5, fc0                \n" +
                "div ft5.x, fc2.x, ft3        \n" +
                "mov ft6, fc0                \n" +
                "div ft6.x, fc2.x, ft4.x    \n" +
                "add ft5.x, ft5.x, ft6.x    \n" +
                "mov ft6, fc0                \n" +
                "pow ft6, ft5.x, fc2.z        \n" +
                "div ft6.x, ft6.x, v0.x        \n" +
                "mul ft6.y, ft6.y, v2.x        \n" +
                "mov ft6.w, fc2.x            \n" +
                "mov oc, ft6                    " 
            );
            
            mProgram = mContext3d.createProgram();
            mProgram.upload( vertexShaderAssembler.agalcode, fragmentShaderAssembler.agalcode);
        }
        
        
        private var mTime:Number = 0.0;
        private function onTick(event:Event):void
        {
            if ( !mContext3d ) 
                return;
            
            mContext3d.clear ( 0, 0, 0, 1 );
            mContext3d.setProgramConstantsFromMatrix(Context3DProgramType.VERTEX, 0, mMatrix, true);
            
            // 0  resolution;
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 0, Vector.<Number>( [ 1, 1, 1, 1 ]) );
            
            // 1 time
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 1, Vector.<Number>( [ Math.cos(mTime)*0.4,Math.sin(mTime*1.5)*0.4,Math.cos(mTime*2.0)*0.4, Math.sin(mTime*3.0)*0.4]) );
                
            // 2    constants
            mContext3d.setProgramConstantsFromVector(Context3DProgramType.FRAGMENT, 2, Vector.<Number>( [ 1, 2, 8, 16 ]) );
            
            mContext3d.drawTriangles(mIndexBuffer);
            mContext3d.present();
            
            mTime += mSpeedSlider.value;
        }
    }
}