/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sXKl
 */

// forked from Scmiz's ripple2
package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
    public class FlashTest extends Sprite {
		private var _frame:uint;
		
		private const MAX_FRAME:uint = 30;
		private const SIZE:Number = 10.0;
		
        public function FlashTest() {
			_frame = 0;
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			update();
			draw();
		}
		
		private function update():void {
			_frame = (_frame + 1) % MAX_FRAME;
		}
		
		private function draw():void {
			var g:Graphics = this.graphics;
			g.clear();
			g.beginFill(0x404040);
			g.drawRect(0, 0, 465, 465);
			g.endFill();

			for (var index:uint = 0; index <60; ++index) {
				g.lineStyle(1, 0xefefef, Number(index) / 60);
				var ratio:Number = Number(_frame) / MAX_FRAME * 2;
				ratio = 2.0 - ratio;
				var size:Number = (SIZE * index) + (SIZE * ratio);
				var rad:Number = (index % 2 == 0) ? 0 : Math.PI * 0.25;
				rad += ratio * Math.PI * 0.25 * ((index % 2 == 0) ? 1 : -1);
				for (var i:uint = 0; i < 4; ++i) {
					var r:Number = rad + (Math.PI * 0.5 * i);
					g.moveTo(
						232.5 + (Math.cos(r) * size),
						232.5 + (Math.sin(r) * size));
					g.lineTo(
						232.5 + (Math.cos(r + (Math.PI * 0.5)) * size), 
						232.5 + (Math.sin(r + (Math.PI * 0.5)) * size));
				}
			}
		}
    }
}