/**
 * Copyright shapevent ( http://wonderfl.net/user/shapevent )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sWyE
 */

// forked from shapevent's flash on 2009-8-8
package {

	import flash.display.*;
	import flash.geom.*;
	import flash.events.*;


	
       [SWF(backgroundColor = 0x000000)]
       public class GumdropTorus extends MovieClip {
		private var matrix:Matrix3D;
		private var verts:Vector.<Number>;
		private var pVerts:Vector.<Number>;
		private var uvts:Vector.<Number>;
		private var tVerts:Vector.<Number>;
		private var p:Point;
		private var brush:BitmapData;
		private var canvas:BitmapData;
		private var dx:Number;
		private var dy:Number;


               public function GumdropTorus(){
                  // init
			matrix = new Matrix3D();
			 
			verts = new Vector.<Number>();
			pVerts = new Vector.<Number>();
			uvts = new Vector.<Number>();
			
			for (var i:Number = -2; i<2; i+=.04){
				for (var j:Number = -2; j<2; j+=.04){
					for (var k:Number = -2; k<2; k+=.04){
						var yz:Number = j * j + k * k;
					     var s:Number = 4 * (Math.pow(i,4) + Math.pow(yz,2)) 
						 + 17 * i * i *(yz) - 20 * (yz + i * i) + 17;
						if (s <0 && s > -0.5){
							verts.push(i * 60);
							verts.push(j * 60);
							verts.push(k * 60);
							pVerts.push(0), pVerts.push(0);
							uvts.push(0), uvts.push(0), uvts.push(0);
						 }
					}
				}
			}
			
			tVerts = new Vector.<Number>();
			matrix.appendRotation(90, Vector3D.X_AXIS);
			matrix.appendRotation(45, Vector3D.Y_AXIS);
			matrix.appendScale(1.7, 1.7, 1.7);
			matrix.transformVectors(verts, tVerts);
			
			p = new Point();
			brush=new BitmapData(3,3,true,0x41FFFFFF);
			canvas = new BitmapData(500,500,false, 0x000000);
			addChild(new Bitmap(canvas));
			dx=0;
			dy=0;
			addEventListener(Event.ENTER_FRAME, onLoop);
			

               }
               // private methods

		private function onLoop(evt:Event):void {
			dx += (mouseX - dx)/4;
			dy += (mouseY - dy)/4;
			matrix.identity();
			matrix.appendRotation(dy,Vector3D.X_AXIS);
			matrix.appendRotation(dx,Vector3D.Y_AXIS);
			matrix.appendTranslation(220, 220, 0);
			Utils3D.projectVectors(matrix, tVerts, pVerts, uvts);
			canvas.lock();
			canvas.fillRect(canvas.rect, 0x000000);
			var inc:int = 0;
			for (var i:int = 0; i<pVerts.length; i+=2){
			 
		        p.x = pVerts[i];
		        p.y = pVerts[i+1];
				canvas.copyPixels(brush, brush.rect, p, null, null, true); 
			}
			canvas.unlock();
		}
		

       }

}