/**
 * Copyright TmskSt ( http://wonderfl.net/user/TmskSt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sWa0
 */

package {
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        
        private var logger:TextField;
        private var DA:DebugAdapter;
        
        public function FlashTest() {
            
            logger = this.addChild(new TextField()) as TextField;
            logger.width = 465;
            logger.height = 465;
            
            DA = new DebugAdapter(logger);
            
            DA.analyseObject(new Point(100, -190));
            DA.analyseObject(new Target());
            
        }
    }
}

import flash.events.Event;
import flash.geom.Point;

class Target {
    
    public var numberVar:Number = 120;
    public var numberVar_NaN:Number = NaN;
    private var numbervar_private:Number = -999;
    
    public var stringVar:String = "HelloWorld";
    public var arrayVar:Array = new Array(100, -20, 300, 4000);
    
    public var objectVar:Object = {"pt" : new Point(-999, 555), "str" : "Hoge"};
    
    public var eventVar:Event = new Event("evt");
    
}

/* ****************************************** */

import flash.text.TextField;

/**
 * Wonderfl用 DebugクラスはLocalConnectionを用いて通信を行う設計
 */
class DebugAdapter {
    
    private var logger:TextField;
    
    public function DebugAdapter(logger:TextField) {
        this.logger = logger;
    }
    
    public function analyseObject(object:*):void {
        var describe:String = Debug.analyseObject(object);
        logger.text = describe + "\n" + logger.text;
    }

}



import flash.utils.describeType;

class Debug {
    public static function analyseObject(object:*, id:int = NaN, levelLimit:int = Infinity):/*void*/String {
        
        // analyse
        var data:XML = describeType(object);
        
        var name:String = data.@name.toString();
        var meta:String = "";
        var date:String = new Date().toString();
        
        // FIXME : isNaN
        if (/*isNaN(id)*/true) {
            meta = date;
        } else {
            meta = id.toString();
        }
        
        var describe:String = "[" + name + "@" + meta + "]" + "\n";
        describe += analyse(object, 0);
        describe += "[ * * * * * * * * * *]";
        //sendMessage("log", describe);
        
        return describe;
    }

    private static function analyse(object:*, level:int):String {
        var describe:String = "";
        
        describe += analyseDynamic(object, level);
        describe += analyseStatic(object, level);
        
        return describe;
    }
    
    private static function analyseDynamic(object:*, level:int):String {
        var describe:String = "";
        
        for (var o:String in object) {
            describe += printTypeOf(o, typeof object[o], object[o], level);
        }
        
        return describe;
    }
    
    private static function analyseStatic(object:*, level:int):String {
        var describe:String = "";
        var data:XML = describeType(object);
        
        var e:XML = null;
        for each (e in data.elements("variable")) {
            var variableName:String = e.@name;
            var variableType:String = e.@type;
            describe += printTypeOf(variableName, variableType, object[variableName], level);
        }
        
        for each (e in data.elements("accessor")) {
            var accessorAccess:String = e.@access.toString();
            if (accessorAccess == "readwrite" || accessorAccess == "readonly") {
                var accessorName:String = e.@name.toString();
                var accessorType:String = e.@type.toString();
                describe += printTypeOf(accessorName, accessorType, object[accessorName], level);
            }
        }
        
        return describe;
    }
    
    private static function isPrimitive(object:*):Boolean {
        return (object is Number || object is int || object is uint || object is Boolean || object is String);
    }
    
    private static function printTypeOf(name:String, type:String, value:*, level:int):String {
        var describe:String = "";
        
        for (var i:int = 0; i < level; i++) {
            describe += "    +";
        }
        if (value == null) { value = "null"; }
        
        if (isPrimitive(value)) {
            describe += "   " + name + " : " + type + "\t =   " + value + "\n";
        } else {
            describe += "   " + name + " : " + type + "\n";
            describe += analyse(value, level + 1);
        }
        
        return describe;
    }
    
    /*
    private static function sendMessage(operation:String, message:String):Boolean {
        return send(operation, [message]);
    }
    */
}
