/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sWXX
 */

// forked from demouth's Biyon Biyon
// forked from demouth's forked from: ひも的な何か
// forked from demouth's ひも的な何か
package  
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    [SWF(frameRate='60')] 
    public class Main extends Sprite
    {
        protected var joints:Vector.<Joint> = new Vector.<Joint>();
        protected var biyon:Vector.<Joint> = new Vector.<Joint>();
        protected var fric:Number = 0.01;
        protected var spring:Number = 0.995;//ばね的なもの？
        protected var range:int = 10;//前後に影響を与える範囲
        protected static const LENGTH:int = 200;
        
        public function Main() 
        {
            if (this.stage) this.init()
            else this.addEventListener(Event.ADDED_TO_STAGE , this.init);
        }
        
        protected function init(event:Event = null):void
        {
            this.stage.align = StageAlign.TOP_LEFT;
            this.stage.scaleMode = StageScaleMode.NO_SCALE;
            this.create();
            this.addEventListener(Event.ENTER_FRAME , this.enterFrameHandler);
        }
        
        protected function create():void
        {
            for (var i:int = 0; i < LENGTH; i++) 
            {
                var j:Joint = new Joint();
                var b:Joint = new Joint();
                
                b.y = j.y = i*2;
                b.x = j.x = this.stage.stageWidth / LENGTH * i;
                
                this.joints.push(j);
                this.biyon.push(b);
            }
        }
        
        private function enterFrameHandler(event:Event):void
        {
            this.graphics.clear();
            
            this.calc();
            this.move();
            this.moveBiyon();
            this.draw();
        }
        
        private function calc():void
        {
            var l:int = this.joints.length;
            for (var i:int = 0; i < l; i++) 
            {
                if (i == 0)
                {
                    this.joints[0].x = this.stage.mouseX;
                    this.joints[0].y = this.stage.mouseY;
                    continue;
                }
                
                var b:int = this.range;
                var a:int = this.range;
                var now:Joint = this.joints[i];
                
                for (var j:int = i-b; j < i+a+1; j++) 
                {
                    if (j >= 0 && l > j && j != i)
                    {
                        var t:Joint = this.joints[j];
                        
                        var angle:Number = Math.atan2(now.y-t.y, now.x-t.x);
                        now.sy -= now.y - t.y;
                    }
                }
            }
        }
        
        private function move():void
        {
            var l:int = this.joints.length;
            for (var i:int = 0; i < l; i++) 
            {
                var now:Joint = this.joints[i];
                now.y += now.sy * this.fric;
                now.x = this.stage.stageWidth / l * i;
                now.sx *= this.spring;
                now.sy *= this.spring;
            }
        }
        
        private function moveBiyon():void
        {
            var l:int = this.joints.length;
            for (var i:int = 0; i < l; i++) 
            {
                var j:Joint = this.joints[i];
                var b:Joint = this.biyon[i];
                b.sx *= 0.92;
                b.sy *= 0.92;
                b.sx += (j.x - b.x)*0.08;
                b.sy += (j.y - b.y)*0.08;
                b.x += b.sx;
                b.y += b.sy;
            }
        }
        
        private function draw():void
        {
            var g:Graphics = this.graphics;
            var l:int = this.biyon.length;
            
            g.beginFill(0);
            g.moveTo(0,this.stage.stageHeight);
            for (var i:int = 0; i < l; i++) 
            {
                g.lineTo(this.biyon[i].x, this.biyon[i].y);
            }
            g.lineTo(this.stage.stageWidth , this.biyon[l-1].y);
            g.lineTo(this.stage.stageWidth , this.stage.stageHeight);
            g.endFill();
            
        }
    }

}

class Joint
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var sx:Number = 0;
    public var sy:Number = 0;
}