/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sVus
 */

package 
{
	import flash.display.Sprite;
	import flash.text.engine.Kerning;
 
	import flashx.textLayout.container.DisplayObjectContainerController;
	import flashx.textLayout.container.IContainerController;
	import flashx.textLayout.conversion.ImportExportConfiguration;
	import flashx.textLayout.conversion.TextFilter;
	import flashx.textLayout.elements.Configuration;
	import flashx.textLayout.elements.TextFlow;
	import flashx.textLayout.formats.CharacterFormat;
	import flashx.textLayout.formats.ParagraphFormat;
 
	[SWF(width='400', height='100', backgroundColor='#000000', frameRate='30')]
 
	public class TypographyTest extends Sprite
	{
		[Embed(source="ASVCodarLTLight.ttf", fontFamily="ASVCodar LT", cff="true")]
		private var _asv_codar_light:String;
 
		public function TypographyTest()
		{
			var text:String = <TextFlow xmlns="http://ns.adobe.com/textLayout/2008">
			<div>
			<p>
			This is a test showing <span baselineShift="superscript">2</span> typographical<span baselineShift="subscript">3</span> controls.
			</p>
			</div>
			</TextFlow>;
 
			var charFormat:CharacterFormat = new CharacterFormat();
			charFormat.color = 0xFFFFFF;
			charFormat.fontFamily = "ASVCodar LT";
			charFormat.fontSize = 20;
			charFormat.kerning = Kerning.ON;
			charFormat.fontLookup = flash.text.engine.FontLookup.EMBEDDED_CFF;
			charFormat.renderingMode = flash.text.engine.RenderingMode.CFF;         
 
			var textFlow:TextFlow = TextFilter.importToFlow(text, TextFilter.TEXT_LAYOUT_FORMAT);
			textFlow.characterFormat = charFormat;
			textFlow.paddingTop = 20;
			textFlow.whiteSpaceCollapse = flashx.textLayout.formats.WhiteSpaceCollapse.PRESERVE;
 
			var container:Sprite = addChild(new Sprite()) as Sprite;
 
			textFlow.flowComposer.addController(new DisplayObjectContainerController(container, 400, 100));
 
			textFlow.flowComposer.updateAllContainers();
		}
	}
}