/**
 * Copyright demouth ( http://wonderfl.net/user/demouth )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sVrM
 */

/* 
 * ろうそくの明かりで壁を照らすと何かがうごめいている・・・的な何か。
 */
package 
{
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageQuality;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.filters.BevelFilter;
	import flash.filters.GlowFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.utils.getTimer;
	
	[SWF(width=465,height=465,frameRate=30)]
	public class FlashTest extends Sprite
	{
		public static const NUM_OF_WARM:int = 20;
		public static const WARM_LENGTH:int = 15;
		public static const WARM_THIC:Number = 7;
		public static const FREQ:Number = 100;
		public static const FREQ_POWER:Number = 5;
		public static const INTERPOLATE:Number = 0.3;
		public static const MASK_RAD:Number = 400;

		public var maskSprite:Sprite;
		public var wormsSprite:Sprite;
		public var worms:Vector.<Worm>;
		
		public function FlashTest() 
		{
			var loader:Loader = new Loader();
			loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/3/3b/3b96/3b96935856bb9a90117838c3ba89b5159815d750"),new LoaderContext(true));
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE , init);
			this.addChild(loader);
		}
		
		private function init(e:Event=null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			this.stage.quality = StageQuality.LOW;
			
			this.worms = new Vector.<Worm>();
			for (var i:int = 0; i < NUM_OF_WARM; i++) 
			{
				var w:Worm = new Worm();
				w.speed = Math.random() * 2.0 + 1.5;
				w.angle = Math.random() * 2 * Math.PI;
				w.point = new Point(Math.random() * this.stage.stageWidth, Math.random() * this.stage.stageHeight);
				w.points = new Vector.<Point>();
				for (var j:int = 0; j < WARM_LENGTH; j++) 
					w.points.push(new Point(w.point.x,w.point.y));
				this.worms.push(w);
			}
			this.addChild(this.wormsSprite = new Sprite());
			this.wormsSprite.filters = [new BevelFilter(4,45,0xBBBBBB,1,0x666666,1,4,4)];
			
			this.addChild(this.maskSprite = new Sprite());
			var mat:Matrix = new Matrix();
			mat.createGradientBox(MASK_RAD, MASK_RAD, 0, -MASK_RAD/2, -MASK_RAD/2);
			this.maskSprite.graphics.clear();
			this.maskSprite.graphics.lineStyle();
			this.maskSprite.graphics.beginGradientFill(GradientType.RADIAL, [0x746018, 0], [0.2, 1], [0, 255], mat);
			this.maskSprite.graphics.drawCircle(0, 0, 700);
			this.maskSprite.graphics.endFill();
			
			this.addEventListener(Event.ENTER_FRAME , enterFrameHandler);
		}
		
		private function enterFrameHandler(e:Event):void 
		{
			this.maskSprite.x = this.stage.mouseX;
			this.maskSprite.y = this.stage.mouseY;
			if(getTimer()%5==1)this.maskSprite.scaleX = this.maskSprite.scaleY = 0.95 + Math.random() * 0.1;
			
			this.wormsSprite.graphics.clear();
			this.move();
			this.draw(this.wormsSprite.graphics);
		}

		private function move():void
		{
			var l:int = this.worms.length;
			for (var i:int = 0; i < l; i++) 
			{
				var w:Worm = this.worms[i];
				w.point.x += Math.cos(w.angle) * w.speed;
				w.point.y += Math.sin(w.angle) * w.speed;
				var a:Number = w.angle+Math.PI/2;
				var pow:Number = Math.sin(getTimer() / (FREQ+w.random*10))*FREQ_POWER;
				w.point.x += Math.cos(a)*pow;
				w.point.y += Math.sin(a) * pow;
				
				var wl:int = w.points.length;
				for (var j:int = 0; j < wl; j++) 
				{
					var p:Point = (j == 0)?w.point:w.points[j - 1];
					var c:Point = w.points[j];
					w.points[j] = Point.interpolate(p, c, INTERPOLATE);
				}
				
				if (w.point.x < -50 || w.point.y < -50 || w.point.x > this.stage.stageWidth+50 || w.point.y > this.stage.stageHeight+50)
				{
					var cw:Number = this.stage.stageWidth / 2;
					var ch:Number = this.stage.stageHeight / 2;
					w.angle = Math.atan2(ch - w.point.y, cw - w.point.x)+Math.sin(Math.random()*10)/4;
				}
			}
		}

		private function draw(g:Graphics):void
		{
			var l:int = this.worms.length;
			for (var i:int = 0; i < l; i++) 
			{
				var w:Worm = this.worms[i];
				
				var wl:int = w.points.length;
				for (var j:int = 0; j < wl; j++) 
				{
					var p:Point = (j == 0)?w.point:w.points[j - 1];
					var c:Point = w.points[j];
					g.lineStyle(WARM_THIC*(1-(j/WARM_LENGTH)),0);
					g.moveTo(p.x, p.y);
					g.lineTo(c.x, c.y);
					
				}
			}
		}
	}
}
import flash.geom.Point;
class Worm
{

	public var point:Point;
	public var points:Vector.<Point>;
	public var angle:Number;
	public var speed:Number;
	public var random:Number = Math.random();
	
}