/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sVqM
 */

// forked from zahir's Scale9 BitmapFill
/*
    FP10の新描画APIを使ってBitmapのScale9
    
    部分リピートなんて出来ないので修正。
    
    最適化してくださるなら是非
    
    ちょっと最適化。
    newをするのをやめて使いまわしたりすることで
    再計算時の処理を高速化
 */
package{
    import flash.display.Bitmap;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    
    [SWF(width="465", height ="465", backgroundColor="0xcccccc")]
    
    public class ScalingBitmapTest extends Sprite{
        private var l:Loader;
        private var fill:ScalingBitmapFill;
        private var s:Sprite;
        
        public function ScalingBitmapTest(){
            l = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void{
                var bmp:Bitmap = l.content as Bitmap;
                
                fill = new ScalingBitmapFill( bmp.bitmapData , 0,0, 40, 40, 40, 40 );
                s = new Sprite();
                addChild( s );
                
                fill.width = 350;
                fill.height = 250;
                fill.smooth = true;
                
                fill.draw( s.graphics );
                
                stage.addEventListener( MouseEvent.MOUSE_MOVE, onMove );
            });
            l.load( new URLRequest("http://zahir.coresv.com/wonderfl/img/scalingBitmapTest.png"), new LoaderContext(true) );
        }
        private function onMove(e:MouseEvent):void{
            e.updateAfterEvent();
            fill.width = lim(mouseX + 25);
            fill.height = lim(mouseY + 25);
            s.graphics.clear();
            fill.draw( s.graphics );
        }
        private function lim( num:Number ):Number{
            return (num > 465) ? 465 : num;
        }
    }
}
import flash.display.BitmapData;
import flash.display.Graphics;
import flash.display.GraphicsBitmapFill;
import flash.display.GraphicsPath;
import flash.display.IGraphicsData;
import flash.geom.Matrix;
import flash.display.GraphicsEndFill;
import flash.display.GraphicsSolidFill;

class ScalingBitmapFill
{
    private var _bitmapData:BitmapData;
    private var _smooth:Boolean;
    
    private var _left:Number;
    private var _top:Number;
    private var _right:Number;
    private var _bottom:Number;
    
    private var _width:Number;
    private var _height:Number;
    private var _innerWidth:Number;
    private var _innerHeight:Number;
    
    private var command:Vector.<int> = Vector.<int>([1, 2, 2, 2, 2]);
    private var paths:Vector.<GraphicsPath>;
    private var fills:Vector.<GraphicsBitmapFill>;
    private var v:Vector.<IGraphicsData>;
        
    private var flg:Boolean = false;
    
    public function ScalingBitmapFill(
                                        bitmapData:BitmapData, 
                                        width:int, height:int,
                                        left:int = 0, top:int = 0, right:int = 0, bottom:int = 0,
                                        smooth:Boolean = false) {
        v = new Vector.<IGraphicsData>;
        paths = new Vector.<GraphicsPath>(9);
        fills = new Vector.<GraphicsBitmapFill>(9);
        
        for(var i:int = 0; i<9; i++){
            paths[i] = new GraphicsPath(command, new Vector.<Number>(10));
            fills[i] = new GraphicsBitmapFill(bitmapData, null, true, smooth);
        }
        
        setData( bitmapData, width, height, left, top, right, bottom, smooth);
    }
    
    public function setData(
                                        bitmapData:BitmapData, 
                                        width:int, height:int,
                                        left:int = 0, top:int = 0, right:int = 0, bottom:int = 0,
                                        smooth:Boolean = false):void{
        this.bitmapData = bitmapData;
        this.width = width;
        this.height = height;
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.smooth = smooth;
    }
    
    public function draw(graphics:Graphics):Graphics
    {
        if (flg == false)
            calc();
        graphics.drawGraphicsData( v );
        return graphics;
    }
    
    private function calc():void 
    {
        var minWidth:Number = left + right;
        var minHeight:Number = top + bottom;
        
        var innerWidth:Number = this.innerWidth, innerHeight:Number = this.innerHeight;
        if (minWidth >= width) width = minWidth, innerWidth = 0;
        if (minHeight >= height) height = minHeight, innerHeight = 0;
        
        var r:int = width - right;
        var b:int = height - bottom;
        var sx:Number = innerWidth / (_bitmapData.width - minWidth);
        var sy:Number = innerHeight / (_bitmapData.height - minHeight);
        
        var offsetX1:Number = left - left * sx;
        var offsetX2:Number = width % _bitmapData.width;
        var offsetY1:Number = top - top * sy;
        var offsetY2:Number = height % _bitmapData.height;
        
        v.length = 0;
        
        // LT
        v.push( setFill( fills[0] ), drawRect(paths[0], 0, 0, left, top));
        // T
        v.push( setFill( fills[1], box( offsetX1,0,sx)), drawRect(paths[1], left,0, innerWidth,top));
        // RT
        v.push( setFill( fills[2], box(offsetX2)), drawRect(paths[2], r,0, right,top));
        
        // L
        v.push( setFill( fills[3], box( 0,offsetY1, 1,sy )), drawRect(paths[3], 0,top, left, innerHeight));
        // Center
        v.push( setFill( fills[4], box( offsetX1, offsetY1, sx,sy )), drawRect(paths[4], left,top, innerWidth, innerHeight));
        // right
        v.push( setFill( fills[5], box( offsetX2,offsetY1, 1,sy )), drawRect(paths[5], r,top, right, innerHeight));
        
        // LB
        v.push( setFill( fills[6], box( 0, offsetY2 )), drawRect(paths[6], 0, b, left,top) );
        // B
        v.push( setFill( fills[7], box( offsetX1, offsetY2, sx )), drawRect(paths[7], left,b, innerWidth,top) );
        // RB
        v.push( setFill( fills[8], box( offsetX2, offsetY2 )), drawRect(paths[8], r,b, right,top) );
        
        flg = true;
    }
    
    public function set bitmapData(value:BitmapData):void {
        _bitmapData = value.clone();
        flg = false;
    }
    
    public function get left():Number { return _left; }
    public function set left(value:Number):void 
    {
        if (value == _left) return;
        value = (value < 0) ? 0 : value;
        _left = value;
        flg = false;
    }
    
    public function get top():Number { return _top; }
    public function set top(value:Number):void 
    {
        if (value == _top) return;
        value = (value < 0) ? 0 : value;
        _top = value;
        flg = false;
    }
    
    public function get right():Number { return _right; }
    public function set right(value:Number):void 
    {
        if (value == _right) return;
        value = (value < 0) ? 0 : value;
        _right = value;
        flg = false;
    }
    
    public function get bottom():Number { return _bottom; }
    public function set bottom(value:Number):void 
    {
        if (value == _bottom) return;
        value = (value < 0) ? 0 : value;
        _bottom = value;
        flg = false;
    }
    
    public function get width():Number { return _width; }
    public function set width(value:Number):void 
    {
        if (value == _width) return;
        value = (value < 0) ? 0 : value;
        _width = value;
        flg = false;
    }
    
    public function get height():Number { return _height; }
    public function set height(value:Number):void 
    {
        if (value == _height) return;
        value = (value < 0) ? 0 : value;
        _height = value;
        flg = false;
    }
    
    public function get smooth():Boolean { return _smooth; }
    public function set smooth(value:Boolean):void 
    {
        if (value == _smooth) return;
        _smooth = value;
        flg = false;
    }
    
    public function get innerWidth():Number { return width - (left + top); }
    public function get innerHeight():Number { return height - (top + bottom); }
    
    private function drawRect( path:GraphicsPath, x:Number, y:Number, width:Number, height:Number):GraphicsPath {
        path.data[0] = path.data[6] = path.data[8] = x;
        path.data[1] = path.data[3] = path.data[9] = y;
        path.data[2] = path.data[4] = x + width;
        path.data[5] = path.data[7] = y + height;
        
        return path;
    }
    private function setFill( fill:GraphicsBitmapFill, matrix:Matrix = null):GraphicsBitmapFill{
        fill.bitmapData = _bitmapData;
        fill.matrix = matrix;
        fill.smooth = smooth;
        return fill;
    }
    private function box( dx:int = 0, dy:int = 0, scaleX:Number = 1, scaleY:Number = 1):Matrix{
        var m:Matrix = new Matrix();
        m.scale( scaleX, scaleY );
        m.translate( dx, dy );
        return m;
    }
    
}