/**
 * Copyright hacker_5t9evsdm ( http://wonderfl.net/user/hacker_5t9evsdm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sVhL
 */

// forked from alumican_net's [CHECKMATE] Stereogram Pattern
// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 * 
 * update 09.07.10 use animation map.
 * update 09.07.10 change height field pattern.
 * 
 * by Takayuki Fukatsu aka fladdict
 **/
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.utils.Timer;
    
    public class StereogramPattern extends Sprite
    {
        Wonderfl.disable_capture();
        
        private const L1:uint = 465;
        private const L2:uint = 465 + 120;
        
        private const ZEROS:Point = new Point(0, 0);
        
        private const BASE_SCALE:uint = 2;
        private const MAP_SCALE:uint  = 20;
        
        private var _canvas:Shape;
        private var _output:BitmapData;
        
        private var _map:BitmapData;
        private var _dmf:DisplacementMapFilter;
        
        private var _pre:BitmapData;
        private var _mat:Matrix = new Matrix();
        private var _scroll:int = 0;
        private var _index:int  = -1;
        private var _count:int  = -1;
        
        public function StereogramPattern()
        {
            _canvas = new Shape();
            _output = new BitmapData(L1, L1, false, 0x0);
            addChild(new Bitmap(_output));
            
            _pre = new BitmapData(L2, L2, false, 0x0);
            _map = new BitmapData(L2, L2, false, 0x0);
            
            _dmf = new DisplacementMapFilter();
            _dmf.mapBitmap  = _map;
            _dmf.componentX = BitmapDataChannel.BLUE;
            _dmf.componentY = BitmapDataChannel.GREEN;
            _dmf.scaleX = 4;
            _dmf.scaleY = 4;
            _dmf.mode = DisplacementMapFilterMode.WRAP;
            
            var dots:Shape = new Shape();
            dots.graphics.beginFill(0x0, 1);
            dots.graphics.drawCircle(L1 / 2 - 30, 15, 5);
            dots.graphics.drawCircle(L1 / 2 + 30, 15, 5);
            dots.graphics.endFill();
            addChild(dots);
            
            var timer:Timer = new Timer(500);
            timer.addEventListener(TimerEvent.TIMER, _updateHandler);
            timer.start();
            
            _updateHandler();
        }
        
        private function _generateHeightMap(index:uint):void
        {
            var pattern:BitmapData = BitmapPatternBuilder.build(_patterns[index][0], _patterns[index][1]);
            
            var field:Shape = new Shape();
            var g:Graphics = field.graphics;
            g.beginBitmapFill(pattern);
            g.drawRect(0, 0, L2 / MAP_SCALE, L2 / MAP_SCALE);
            g.endFill();
            
            _pre.draw(field, new Matrix(MAP_SCALE, 0, 0, MAP_SCALE, 17));
        }
        
        private function _updateHandler(e:TimerEvent = null):void
        {
            var pattern:BitmapData = generateBasePattern();
            
            var g:Graphics = _canvas.graphics;
            g.beginBitmapFill(pattern);
            g.drawRect(0, 0, L1 / BASE_SCALE, L1 / BASE_SCALE);
            g.endFill();
            
            _output.draw(_canvas, new Matrix(BASE_SCALE, 0, 0, BASE_SCALE));
            
            if (++_count % 8 == 0)
            {
                _count = 0;
                if (++_index>= _patterns.length) _index = 0;
                _generateHeightMap(_index);
            }
            _scroll = (_scroll + 15 >= 60) ? -60 : (_scroll + 15);
            _mat.identity();
            _mat.translate(_scroll, 0);
            _map.draw(_pre, _mat);
            
            _output.applyFilter(_output, _output.rect, ZEROS, _dmf);
        }
        
        public function generateBasePattern():BitmapData
        {
            var size:uint = 30;
            var ptn:Array = new Array(size);
            for (var i:int = 0; i < size; ++i) 
            {
                ptn[i] = new Array(size);
                for (var j:int = 0; j < size; ++j) 
                {
                    ptn[i][j] = Math.round( Math.random() );
                }
            }
            var colors:Array = [0xffff3300, 0xffffffff33];
            return BitmapPatternBuilder.build(ptn, colors);
        }
        
        private var _patterns:Array = [
            [
             [[0, 1, 0, 0, 0, 0],
              [1, 1, 1, 0, 0, 0],
              [0, 1, 0, 0, 0, 0],
              [0, 0, 0, 0, 1, 0],
              [0, 0, 0, 1, 1, 1],
              [0, 0, 0, 0, 1, 0]],
              [0xff000000, 0xff0000ff]
            ],[
             [[1, 1, 1, 0, 0, 0],
              [1, 0, 1, 0, 0, 0],
              [1, 1, 1, 0, 0, 0],
              [0, 0, 0, 1, 1, 1],
              [0, 0, 0, 1, 0, 1],
              [0, 0, 0, 1, 1, 1]],
              [0xff000000, 0xff0000ff]
            ],[
             [[1, 2, 3, 0, 0, 0],
              [1, 2, 3, 0, 0, 0],
              [1, 2, 3, 0, 0, 0],
              [0, 0, 0, 1, 2, 3],
              [0, 0, 0, 1, 2, 3],
              [0, 0, 0, 1, 2, 3]],
              [0xff000080, 0xff000055, 0xff0000aa, 0xff0000ff]
            ],[
             [[2, 0, 2, 0, 0, 0],
              [2, 0, 2, 0, 1, 0],
              [2, 0, 2, 0, 0, 0],
              [0, 0, 0, 2, 2, 2],
              [0, 0, 0, 0, 0, 0],
              [0, 0, 0, 2, 2, 2]],
              [0xff000000, 0xff000080, 0xff0000ff]
            ],[
             [[1, 0, 1, 0, 0, 0],
              [0, 2, 0, 0, 0, 0],
              [1, 0, 1, 0, 0, 0],
              [0, 0, 0, 1, 0, 1],
              [0, 0, 0, 0, 2, 0],
              [0, 0, 0, 1, 0, 1]],
              [0xff000000, 0xff000080, 0xff0000ff]
            ],[
             [[1, 1, 0, 0, 0, 0],
              [1, 1, 0, 0, 0, 0],
              [0, 0, 0, 0, 0, 0],
              [0, 0, 0, 1, 1, 0],
              [0, 0, 0, 1, 1, 0],
              [0, 0, 0, 0, 0, 0]],
              [0xff000000, 0xff0000ff]
            ]
        ];
    }
}


/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}