/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sUzl
 */

package  {
    import flash.display.Sprite;
    import flash.display.DisplayObject;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Vector3D;
    import com.bit101.components.Slider;
    import jp.progression.commands.tweens.DoTweener;
    
    [SWF(width = 465, height = 465, backgroundColor = 0,frameRate = "60")]
    public class Main extends Sprite{
        
        private var _numPanels:int = 50;
        private var _panelWidth:int = 400;
        private var _panelHeight:int = 300;
        private var _pitch:Number = 80;
        private var _currentY:Number;
        
        private var _container:Sprite;
        private var _items:Vector.<Sprite>;
        
        private var slider:Slider;

        public function Main() {
            root.transform.perspectiveProjection.fieldOfView = 60;
            graphics.beginFill(0x313131);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            addPanels();
        }
        
        private function addPanels():void{
            _container = new Sprite();
            _items = Vector.<Sprite>([]);
            var i:int = 0;
            while(i<_numPanels){
                var panel:Panel = new Panel(_panelWidth, _panelHeight, Math.random() * 0xFFFFFF, i + 1);
                panel.x = _pitch * i + _pitch * .5 + stage.stageWidth * .5 - 40;
                panel.y = stage.stageHeight * .5;
                panel.z = Math.abs(_container.x + panel.x - stage.stageWidth * .5) + 300;
                panel.addEventListener(MouseEvent.MOUSE_OVER, onOver);
                _currentY = panel.y;
                _container.y = -80;
                _container.addChild(panel);
                _items.push(panel);
                i++;
            }
            addChild(_container);
            sortItems();
            //
            slider = new Slider("horizontal", this, 50, 360, null);
            slider.width = 365;
            slider.height = 15;
            slider.addEventListener(MouseEvent.MOUSE_DOWN, sliderMouseDown);
        }
        
        private function sliderUpdate(e:Event = null):void{
            slider.value = (slider.mouseX) / slider.width * 100;
            _container.x = -(slider.value * ((_numPanels - 1) * _pitch) * .01);
            panelSlide();
        }
        
        private function sliderMouseDown(e:MouseEvent):void{
            addEventListener(Event.ENTER_FRAME, sliderUpdate);
            slider.addEventListener(MouseEvent.MOUSE_UP, sliderMouseUp);
            stage.addEventListener(MouseEvent.MOUSE_UP, sliderMouseUp);
        }
        
        private function sliderMouseUp(e:MouseEvent):void{
            removeEventListener(Event.ENTER_FRAME, sliderUpdate);
            slider.removeEventListener(MouseEvent.MOUSE_UP, sliderMouseUp);
            stage.removeEventListener(MouseEvent.MOUSE_UP, sliderMouseUp);
            var val:Number = slider.value;
            var pos:Number = 100 / (_numPanels - 1);
            if(val % pos != 0){
                if(slider.value == 100) return;
                slider.value = (val - val % pos);
                _container.x = -(slider.value * ((_numPanels - 1) * _pitch) * .01);
                panelSlide();
            };
        }
        
        private function panelSlide():void{
            var i:int = 0;
            while(i<_numPanels){
                _items[i].z = Math.abs(_container.x + _items[i].x - stage.stageWidth * .5) + 300;
                i++;
            }
            sortItems();
        }
        
        //
        private function sortItems():void {
            _items.sort(depthSort);
            for (var i:int = 0; i < _items.length; i++) {
                _container.addChildAt(_items[i] as Sprite, i);
            }
        }

        private function depthSort(objA:DisplayObject, objB:DisplayObject):int {
            return objB.z - objA.z;
        }
        
        private function onOver(e:MouseEvent):void{
            var sp:Sprite = e.currentTarget as Sprite;
            if(sp.z > 301) return;
            var com:DoTweener = new DoTweener(sp, {scaleX:1.8, scaleY:1.8, y:_currentY - 50, time:1, transition:"easeOutBounce"});
            com.execute();
            sp.addEventListener(MouseEvent.MOUSE_OUT, onOut);
        }
        private function onOut(e:MouseEvent):void{
            var sp:Sprite = e.currentTarget as Sprite;
            sp.removeEventListener(MouseEvent.MOUSE_OUT, onOut);
            var com:DoTweener = new DoTweener(sp, {scaleX:1, scaleY:1, y:_currentY, time:.5, transition:"easeOutBounce"});
            com.execute();
        }

    }
    
}


//
import flash.display.Sprite;
import flash.display.*;
import flash.filters.DropShadowFilter;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import com.bit101.components.Label;


class Panel extends Sprite{
    
    private var _bmd:BitmapData;
    private var _refraction:Bitmap;
    private var _mask:Mask;
    
    public function Panel(w:int, h:int, col:int, n:int){
        var g:Graphics = this.graphics;
        g.beginFill(col);
        g.drawRoundRect(-w * .5, -h * .5, w, h, 8, 8);
        g.endFill();
        g.beginFill(0xFFFFFF, .6);
        g.drawRect(-w * .5, h * .4, w, h * .1 - 4);
        g.endFill();
        var label:Label = new Label(this, -35, h * .377|0, "Color:#" + col.toString(16) + " / Page:" + n.toString());
        label.scaleX = label.scaleY = 2;
        //
        var dropShadow:DropShadowFilter = new DropShadowFilter(10, -80, 0, .5, 10, 10, 1, 2);
        this.filters = [dropShadow];
        //
        doReflection();
    }
    
    private function doReflection():void{
            _bmd = new BitmapData(this.width, this.height, false, 0);
            _bmd.draw(this, new Matrix(1,0,0,1,200,150));
            _mask = new Mask(this.width, this.height * .5);
            _mask.rotation = 90;
            _mask.x = this.width * .5;
            _mask.y = this.height * .5 + 10;
            _refraction = new Bitmap(_bmd);
            _refraction.scaleY = -1;
            _refraction.x = - this.width * .5;
            _refraction.y = this.height * 1.5 + 10;
            addChild(_refraction);
            addChild(_mask);
            _refraction.cacheAsBitmap = _mask.cacheAsBitmap = true;
            _refraction.mask = _mask;
        }
}


//
import flash.display.Sprite;
import flash.display.Graphics;

class Mask extends Sprite{
    public function Mask(w:int, h:int){
        var g:Graphics = this.graphics;
        g.beginGradientFill("linear", [0xFFFFFF, 0xFFFFFF], [1, 0], [100, 255]);
        g.drawRect(0, 0, h, w);
        g.endFill();
    }
}