/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sUk1
 */

// forked from okoi's Computation っぽい奴
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Graphics;
    
    [SWF(width = "465", height = "465", frameRate = "60")]
    
    
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        public static const WIDTH:int = 465;
        public static const HEIGHT:int = 465;
        public static const PADDING:Number = 0;
        
        private var pathlist:/*Path*/Array;
        
        private var count:int = 0;
        private var countLimit:int = 15;        
        
        private var canvas:BitmapData;
        private var tempSp:Sprite;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            canvas = new BitmapData(WIDTH, HEIGHT, true, 0);
            addChild( new Bitmap(canvas) );
            
            tempSp = new Sprite();
            
            InitPath();
            
            addEventListener(Event.ENTER_FRAME, EnterFrameHandler);
            stage.addEventListener( MouseEvent.CLICK, Reset );
        }
        
        private function InitPath() : void
        {
            var width:Number = WIDTH - PADDING * 2;
            var height:Number = HEIGHT - PADDING * 2;
            
            pathlist = new Array();
            
            for ( var y:int = 0; y <= 10; y++ )
            {
                for ( var x:int = 0; x <= 10; x++ )
                {
                    var path:Path = new Path();
                    path.targetX = x * (width / 10) + PADDING;
                    path.targetY = y * (height / 10) + PADDING;
                //    path.targetX = Math.random() * width + PADDING;
                //    path.targetY = Math.random() * height + PADDING;
                    path.x = Math.random() * WIDTH;
                    path.y = Math.random() * HEIGHT;
                    
                    pathlist.push( path );
                }
            }    
            
            var pathnum:int = pathlist.length;
            for ( var i:int = 0; i < pathnum; i++ )
            {
                pathlist[i].linkpath = pathlist[int(Math.random() * pathnum)];
                pathlist[i].ctrlpath = pathlist[int(Math.random() * pathnum)];
            }
        }
        
        private function EnterFrameHandler( e:Event ) : void
        {
            if( count == countLimit )
            {
                count = 0;
                InitPath();
            }

            var pathnum:int = pathlist.length;
            var i:int;
            for ( i = 0; i < pathnum; i++ )    pathlist[i].Move();
                    
            var g:Graphics = tempSp.graphics;
            g.clear();
            for ( i = 0; i < pathnum; i++ )
            {
                if ( !pathlist[i].move )    continue;
                g.lineStyle(1, 0xFFFFFF, 0.05);
                g.moveTo( pathlist[i].x, pathlist[i].y );
                g.curveTo( pathlist[i].ctrlpath.x, pathlist[i].ctrlpath.y, pathlist[i].linkpath.x, pathlist[i].linkpath.y );
            }
            canvas.draw( tempSp );
            ++count;
        }
        
        private function Reset(e:MouseEvent) : void
        {
            //InitPath();
            canvas.fillRect(canvas.rect, 0);
        }
        
    }
}
class Path {
    public var x:Number;
    public var y:Number;
    
    public var targetX:Number;
    public var targetY:Number;
    
    public var linkpath:Path;
    public var ctrlpath:Path;
    public var move:Boolean = true;
    
    public function Move() : void
    {
        if ( Math.sqrt((targetX - x) * (targetX - x) + (targetY - y) * (targetY - y)) < 1 )
        {
            move = false;
            return;
        }
        x += (targetX - x) * 0.1;
        y += (targetY - y) * 0.1;
    }
    
}