/**
 * Copyright iong ( http://wonderfl.net/user/iong )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sUit
 */

/* 
 * txtの雨
 * イメージはcaligariのPV背景、2:58ぐらい（http://www.youtube.com/watch?v=Y1bWW4GeiHE）
 * 文章は青空文庫「雨夜詞」の一節（http://www.aozora.gr.jp/cards/000154/card47992.html）
 *
 * win以外の動作環境がないので、fontが出てなかったらすいません。。
 *
 * 07-15-2010 ・Sprite -> Vector に。Vector軽ーい
 *            ・Ball追加
 *
 * 07-21-2010 ・線を入れてみた
 */
package{

    import flash.display.Sprite;

    [SWF(width="465", height="465", backgroundColor="#000000", frameRate="30")]
    public class FlashTest extends Sprite
    {
        import frocessing.core.F5Graphics2D;
        import flash.text.TextField;
        import flash.display.Bitmap;
        import flash.display.BitmapData;
        import flash.display.BlendMode;
        import flash.geom.Matrix;
        import flash.geom.Point;
        import flash.filters.BlurFilter;

        import flash.events.Event;

        import flash.system.Capabilities;

        private var _SPR:Vector.<MakeTxt> = new Vector.<MakeTxt>();
        private var _SPB:Vector.<MakeTxt> = new Vector.<MakeTxt>();
        private var _SPA:Vector.<MakeBall>= new Vector.<MakeBall>();
        private var _SPF:Sprite = new Sprite();
        private const _TXTR:String = "お菊さんは耳門を入ると、右の手に持つてゐた岡持を左の手に持ちかへて、玄関の方を注意した。青醒めたやうな光が坂の下に見る火のやうに下に見えてゐた。入つて来た露次の工合から平坦な土地のやうに感じてゐたその感じを裏切られてしまつた。其所にはたらたらとおりて行く坂路のやうな路があつた。お菊さんは不思議な家だと思ひながら足許に注意しい／＼歩いた。"
            + "萠黄色に見える火の光とも、また見やうによつては蓴菜の茎のやうにも見える物が眼の前に一めんに立つてゐるやうに思はれて来た。そしてその萠黄色の茎は身だけよりも一層長く上に延びてゐて、それに手がかゝつたり頬が触つたりするやうに思はれた、お菊さんは立ち止つた、萠黄色の茎はゆうらりゆうらりと動いてゐるやうに見えた。お菊さんは驚いて眼を上の方にやつた。上の方は薄月がさしたやうにぼうと明るくなつてゐて、其所には蓴菜の葉のやうに円い物が一めんに浮んだやうになつてゐた。"
            + "お菊さんは不思議な家へ来たものだと思つた。そして早く玄関へ行つて、北村さんに逢ひたいと思つた。お菊さんは玄関の火に注意した。青醒めたやうな光は遠くの方に見えてゐた。お菊さんは萠黄色の茎に眼をふさいで歩き出した。";
        private var aryTxt:Array = new Array();

        private var tfFont:String;

        // txt size：main（avg）
        private const _tfSize:uint   = 112;
        // txt size：bg（avg）
        private const _tfSizeBG:uint = 32;
        // txt size: add random
        private const _tfSizeOV:uint = 16;

        // making txt span 
        private const _iMC:uint   = 10;
        private var iMakeCnt:uint = 0;

        // txt splitter
        private const _SPTxt:Array= new Array(
             "に"
            ,"を"
            ,"とも"
            ,"と"
            ,"はれ"
            ,"は"
            ,"が"
            ,"、"
            ,"。"
            ,"そして"
            ,"また"
        );

        // line
        private const _iMLC:uint      = 20;
        private var   iMLMakeCnt:uint = 0;
        private var iMLCnt:uint       = 2;

        private var flBlurBg:BlurFilter = new BlurFilter(4,4);

        public function FlashTest():void
        {
            Wonderfl.capture_delay(3);
            init();

            addChild(_SPF);

            addEventListener(Event.ENTER_FRAME, act);
        }

        private function init():void
        {
            // set OS font
            switch(Capabilities.os.substr(0,3).toLowerCase()){
                case "win":
                    tfFont = "MS Mincho";
                    break;
                case "mac":
                    tfFont = "Hiragino Mincho Pro";
                    break;
                default:
                    tfFont = "Kochi Mincho";
            }

            // make txt array
            var sp:RegExp = new RegExp(_SPTxt.join("|"));
            aryTxt = _TXTR.split(sp);
        }

        private function act(e:Event):void
        {
            var iB:int;
            for(iB=0; iB<=8; iB++){
                var spB:Sprite = new MakeBall();
                initPiece(spB);
                addChild(spB);
                _SPA.push(spB);
            }
            if(iMakeCnt<=0){
                var txt:Sprite   = new MakeTxt(retTxt(), tfFont, _tfSize, _tfSizeOV);
                var txtBg:Sprite = new MakeTxt(retTxt(), tfFont, _tfSizeBG, _tfSizeOV);
                initPiece(txt);
                initPiece(txtBg);
                
                txtBg.filters = [new BlurFilter(8,8)]
                
                addChild(txtBg);
                addChild(txt);
                _SPR.push(txt);
                _SPB.push(txtBg);
                iMakeCnt = _iMC;

            }else iMakeCnt--;

            if(iMLMakeCnt<=0){
                var ml:Sprite = new MakeLine(initLine(), stage.stageWidth, stage.stageHeight);
                _SPF.addChild(ml);
                iMLMakeCnt= _iMLC;
                
            }else iMLMakeCnt--;

            drawAll();
        }

        private function drawAll():void
        {
            var i:int;
            for(i=0; i<_SPR.length; i++){
                _SPR[i].y += 6 + (_SPR[i].alpha*10);
                _SPR[i].rotation += _SPR[i].intRAdd;
                _SPR[i].alpha -=0.01;
                if(_SPR[i].alpha<=0 || _SPR[i].y>=stage.stageHeight+_SPR[i].height){
                    removeChild(_SPR[i]);
                    _SPR.splice(i,1);
                }
            }
            for(i=0; i<_SPB.length; i++){
                _SPB[i].y += 6 + (_SPB[i].alpha*10);
                _SPB[i].rotation += _SPB[i].intRAdd;
                _SPB[i].alpha -=0.01;
                if(_SPB[i].alpha<=0 || _SPB[i].y>=stage.stageHeight+_SPB[i].height){
                    removeChild(_SPB[i]);
                    _SPB.splice(i,1);
                }
            }
            for(i=0; i<_SPA.length; i++){
                _SPA[i].x += _SPA[i].iSX;
                _SPA[i].y += _SPA[i].iSY;
               if(_SPA[i].y >= stage.stageHeight+_SPA[i].height){
                   removeChild(_SPA[i]);
                   _SPA.splice(i,1);
               }
            }
        }

        private function initPiece(txt:Sprite):void
        {
            txt.x  = -100 + retRand(stage.stageWidth+100);
            txt.y -= txt.height - retRand(20);
        }

        // return txt (random)
        private function retTxt():String
        {
            var retVal:String = "";
            var str:String = "";
            while(str==""){
                var ret:* = aryTxt[(retRand(aryTxt.length))];
                if(ret!=null)str = ret;
            }
            for(var i:int=0; i<str.length; i++){
                retVal += (retVal!="") ? "\n": "";
                retVal += str.substr(i,1);
            }
            return retVal;
        }

        // line
        public function initLine():Array
        {
            var retVal:Array = new Array();
            var p0x:Number; var p0y:Number;
            var p1x:Number; var p1y:Number;
            var p2x:Number; var p2y:Number;

            var psa:uint; var psb:uint;
            psa = retRand(1);
            if(psa==0){
                psb = retRand(1);
                p0x = retRand(stage.stageWidth);
                p0y = (psb==0) ? 0: stage.stageHeight;
            }else{
                psb = retRand(1);
                p0x = (psb==0) ? 0: stage.stageWidth;
                p0y = retRand(stage.stageHeight);
            }

            p1x = retRand(stage.stageWidth);
            p1y = retRand(stage.stageHeight);

            psa = retRand(1);
            if(psa==0){
                psb = retRand(1);
                p2x = retRand(stage.stageWidth);
                p2y = (psb==0) ? 0: stage.stageHeight;
            }else{
                psb = retRand(1);
                p2x = (psb==0) ? 0: stage.stageWidth;
                p2y = retRand(stage.stageHeight);
            }

            retVal.push(new Point(p0x,p0y));
            retVal.push(new Point(p0x,p0y));
            var dx:Number; var dy:Number;
            var cmax:uint = 0;
            var i:int=1;
            while(i<=iMLCnt){
                cmax += i;
                i++;
            }
            for(i=1; i<=cmax; i++){
                dx = (p1x>p0x) ? (p1x-p0x)/cmax*i: (p0x-p1x)/cmax*i;
                dy = (p1y>p0y) ? (p1y-p0y)/cmax*i: (p0y-p1y)/cmax*i;
                retVal.push(new Point(dx,dy));
            }
//            retVal.push(new Point(p1x, p1y));
            for(i=1; i<=cmax; i++){
                dx = (p2x>p1x) ? (p2x-p1x)/cmax*i: (p1x-p2x)/cmax*i;
                dy = (p2y>p1y) ? (p2y-p1y)/cmax*i: (p1y-p2y)/cmax*i;
                retVal.push(new Point(dx,dy));
            }
            retVal.push(new Point(p2x,p2y));
            retVal.push(new Point(p2x,p2y));
            return retVal;
        }

        public function retRand(n:uint):uint
        {
            var retVal:uint = Math.round(Math.random()*n);
            return retVal;
        }
    }
}

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.events.Event;
class MakeTxt extends Sprite
{
    // rotation（+-intR）
    public var intR:uint = 8;
    // add rot / frm （+-intRAdd）(/100)
    public var intRAdd:Number = 3;

    public function MakeTxt(txt:String, tfFont:String, ts:uint, tsp:uint):void
    {
        var tfmt:TextFormat = new TextFormat();
        tfmt.font = tfFont;
        tfmt.size = ts-tsp+Math.round(Math.random()*(tsp*2));
        tfmt.color= 0xffffff;
        var tf:TextField = new TextField();
        tf.autoSize= TextFieldAutoSize.LEFT;
        tf.text = txt;
        tf.selectable = false;
        tf.setTextFormat(tfmt);

        var bmd:BitmapData = new BitmapData(tf.width, tf.height, true, 0x0);
        bmd.draw(tf);

        var retVal:Bitmap = new Bitmap(bmd);

        init();

        addChild(retVal);
    }

    private function init():void
    {
        rotation = -(intR)+Math.round(Math.random()*(intR*2));
        intRAdd  = ( -(intRAdd)+Math.round(Math.random()*(intRAdd*2)) )/100;
    }

}

class MakeBall extends Sprite
{
    // max size
    public var iW:uint = 8;
    // speed
    public var iSX:int  = 1;
    public var iSY:uint = 32;
    
    public function MakeBall():void
    {
        var iBgW:uint  = Math.round(Math.random()*iW);
        var iAL:Number = (1 + Math.round(Math.random()*6))/10;
        iSX = -(iSX) + Math.round(Math.random()*(iSX*2));

        graphics.beginFill(0xffffff, iAL);
        graphics.drawCircle(0, 0, iBgW/2);
        graphics.endFill();
        y -= Math.round(Math.random()*iSY);
    }
}

import flash.geom.Point;
import frocessing.core.F5Graphics2D;
class MakeLine extends Sprite
{
    private var sp:F5Graphics2D;
    private var ary:Array        = new Array();
    private var iMLS:uint        = 0;
    private var iMLE:uint        = 0;
    private var iMLSpan:uint     = 6;
    private var iMLStroke:Number = 2;

    public function MakeLine(_ary:Array,w:uint,h:uint):void
    {
        sp = new F5Graphics2D(graphics);
        sp.size(w,h)
        ary = _ary;
        addEventListener(Event.ENTER_FRAME, act);
    }
    private function act(e:Event):void
    {
        sp.noFill();
        sp.stroke(255,255,255, 0.5);
        sp.strokeWeight(iMLStroke);

        var pt:Point;

        var iS:uint = Math.max(0, iMLE-iMLSpan);
        var iE:uint = Math.min(ary.length, iMLE);

        sp.background(0,0);

        sp.beginShape();
        for (var i:int=iS; i<iE; i++) {
            sp.curveVertex(ary[i].x, ary[i].y);
        }
        sp.endShape();
        iMLE++;
        if(iMLE>=ary.length+iMLSpan){
            removeEventListener(Event.ENTER_FRAME, act);
            e.target.parent.removeChild(this);
        }
    }
}