/**
 * Copyright tsu_droid ( http://wonderfl.net/user/tsu_droid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sU8F
 */

// forked from s8t1h12akj's forked from: Old Skool [Optimised]

package  {
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    //import flash.display.PixelSnapping;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import net.hires.debug.Stats;
    
    /**
     * old school demo effects: http://iquilezles.org/www/articles/deform/deform.htm
     * @author Devon O.
     * @optimisation Hasufel
     */

    [SWF(width='465', height='465', backgroundColor='#000000', frameRate='60')]
    
    public class OldSkool extends Sprite {
        private static const _rect:Rectangle = new Rectangle(0,0,512,512);
        private const _xres:uint = 512;//256//128
        private const _yres:uint = 512;//256//128
        private var _input:BitmapData;
        private var _output:BitmapData;        
        private var _lookUpTable:Vector.<uint> = new Vector.<uint>();
        private var _inputVector:Vector.<uint> = new Vector.<uint>();
        private var _time:uint = 0;
        private var _effect:int = 0;
        private var _maxEffects:int = 51; //you should add more, your imagination is the limit!
        private var _outputVector:Vector.<uint> = new Vector.<uint>();
        
        public function OldSkool() {
            if (stage) loadImage();
            else addEventListener(Event.ADDED_TO_STAGE, loadImage);
        }
        
        private function loadImage(event:Event = null):void {
            var l:Loader = new Loader();
            l.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageLoad);
            l.load(new URLRequest("http://assets.wonderfl.net/images/related_images/d/da/da78/da78a4737f4c266442240a6a37b866116a75cb1b"), new LoaderContext(true));
        }
        
        private function onImageLoad(event:Event):void {
            var l:Loader = event.currentTarget.loader;
            _input = (l.content as Bitmap).bitmapData;
            _inputVector = _input.getVector(_rect);
           init();
        }
        
        private function init():void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            _output = new BitmapData(_xres, _yres, false, 0x000000);
            
            var bmp:Bitmap = new Bitmap(_output);//, PixelSnapping.AUTO, true);
            bmp.width = bmp.height = stage.stageHeight;
            addChild(bmp);
            addChild(new Stats());
            createLUT();
            addEventListener(Event.ENTER_FRAME, frameHandler);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onClick(e:MouseEvent):void {
            if (++_effect > _maxEffects) _effect = 0;
            createLUT();
        }
        
        private function frameHandler(e:Event):void {
            renderDeformation();
            _time += 5;
        }
         
        private function renderDeformation():void {
            for(var j:uint=0; j < _yres; ++j) {
                for (var i:uint = 0; i < _xres; ++i) {            
                    var o:uint = ((j<<9) + i)>>0;//uint((j<<9) + i);//_xres * j +i; //lets stick to 512 (<<9) for now
                    var u:uint = _lookUpTable[(o<<1)>>0] + _time;//uint(o<<1)] + _time; //cast
                    var v:uint = _lookUpTable[((o<<1)+1)>>0] + _time;//uint((o<<1) + 1)] + _time;//cast
                _outputVector[((j<<9) + i)>>0] = _inputVector[(((v & 511) <<9) + (u & 511))>>0];// _outputVector[uint((j<<9) + i)] = _inputVector[uint(((v & 511)<<9) + (u & 511))]; //never forget casting!
                
                }
            }
            
            _output.lock();
            _output.setVector(_rect, _outputVector);
            _output.unlock();
            
        }                 
        
        private function createLUT():void {
            var k:uint = 0;
            
            for (var j:int = 0; j < _yres; ++j) {
                for (var i:int = 0; i < _xres; ++i) {
                    var xx:Number = -1.0 + 2.0 * i / _xres;
                    var yy:Number = -1.0 + 2.0 * j / _yres;
                    var d:Number = Math.sqrt(xx * xx + yy * yy);
                    var a:Number = Math.atan2(yy, xx);
                    var r:Number = 1;
                    // MAGIC FORMULAS!
                    var u:Number;
                    var v:Number;
                    
                    
                    u = .2 / Math.abs(yy);
                    v = .2 * xx / Math.abs(yy);
                            
                    _lookUpTable[(k++)>>0] = (512.0 * u)>>0 & 511;//_lookUpTable[uint(k++)] = uint(512.0 * u) & 511;
                    _lookUpTable[(k++)>>0] = (512.0 * v)>>0 & 511;//_lookUpTable[uint(k++)] = uint(512.0 * v) & 511;
                
                }
            }
            
        }
        
    }
    
}