/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sTzY
 */

/*
 * 情報整理用カード
 * 
 * Load GoogleDocs rssをクリックすると、
 * 
 * ↓の内容を取得して、カードにする。
 * https://spreadsheets.google.com/ccc?key=0Akpu7nsnVtwIdHlkTVRQWUxaUGRLZVVMNzZGT0FxYWc&hl=ja#gid=0
 * 
 * 改造すれば、宛名シートとかにもなると思う。
*/
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import com.bit101.components.*;
	
	/**
	 * ...
	 * @author umhr
	 */
	[SWF(backgroundColor = 0xFFFFFF, width = 465, height = 465)]
	public class Main extends Sprite 
	{
		private var _inputText:Text;
		private var _loadRSSButton:PushButton;
		private var _loadXHTMLButton:PushButton;
		public function Main():void 
		{
			stage.scaleMode = "noScale";
			stage.align = "TL";
			_inputText = new Text(this, 0, 0, "http://spreadsheets.google.com/feeds/cells/0Akpu7nsnVtwIdHlkTVRQWUxaUGRLZVVMNzZGT0FxYWc/od6/public/basic?alt=rss");
			_inputText.width = 465;
			_inputText.height = 36;
			_loadRSSButton = new PushButton(this, 0, 36, "Load GoogleDocs rss", doLoadRSS);
			_loadXHTMLButton = new PushButton(this, 0, 100, "Load local XHTML", doLoadXHTML);
		}
		private function doLoadXHTML(event:Event):void {
			this.removeChild(_loadRSSButton);
			this.removeChild(_loadXHTMLButton);
			var loadFile:LoadFile = new LoadFile();
			loadFile.atComplete = onCompXHTML;
			loadFile.start();
		}
		public function doLoadRSS(event:Event):void {
			this.removeChild(_loadRSSButton);
			this.removeChild(_loadXHTMLButton);
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener (Event.COMPLETE, onCompRSS);
			//YahooPipesの汎用feedProxy
			var xmlURL:String = "http://pipes.yahooapis.com/pipes/pipe.run?_id=f4f6c98189a88373b9bfd4fe6128c018&_render=rss&url=";
			//encodeURIComponentでエスケープして、feedProxyにくっつける。
			xmlURL += encodeURIComponent(_inputText.text + "&rand="+Math.random()+5);
			myURLLoader.load(new URLRequest(xmlURL));
		}
		private function onCompRSS(event:Event):void {
			var xml:XML = new XML(event.target.data);
			var data:Data = new Data();
			var obj:Object = { };
			var maxLine:int = 0;
			var maxColumn:int = 0;
			var n:int = xml.channel.item.length();
			for (var i:int = 0; i < n; i++) {
				var lineNum:Number = Number(String(xml.channel.item[i].title).substr(1))-1;
				var columnNum:Number = String(xml.channel.item[i].title).substr(0, 1).charCodeAt() - 65;
				maxLine = (maxLine < lineNum)?lineNum:maxLine;
				maxColumn = (maxColumn < columnNum)?columnNum:maxColumn;
				obj[lineNum + "_" + columnNum] = xml.channel.item[i].description;
			}
			for (i = 0; i < (maxLine+2); i++) {
				for (var j:int = 0; j < (maxColumn+2); j++) {
					data.setData(obj[i + "_" + j]?obj[i + "_" + j]:"", i, j);
				}
			}
			setPrint(data);
		}
		private function onCompXHTML(event:Event):void {
			var xml:XML = new XML(event.target.data);
			default xml namespace = new Namespace("http://www.w3.org/1999/xhtml");
			
			var data:Data = new Data();
			var n:int = xml.body.table[0].tr.length();
			for (var i:int = 0; i < n; i++) {
				var m:int = xml.body.table[0].tr[i].td.length();
				for (var j:int = 0; j < m; j++) {
					if (xml.body.table[0].tr[i].td[j].p) {
						data.setData(xml.body.table[0].tr[i].td[j].p, i, j);
					}
				}
			}
			setPrint(data);
		}
		private function setPrint(data:Data):void{
			this.removeChild(_inputText);
			var cards:Cards = new Cards(data);
			var print:Print = new Print(cards);
			this.addChild(print);
			new PushButton(this, 0, 0, "Print", function doPrint(event:Event):void {
					//trace(event.target.label);
					event.target.parent.removeChild(event.target);
					print.start();
				}
			);
		}
	}
}

import flash.display.Sprite;
import flash.printing.PrintJob;
import flash.geom.Rectangle;
import flash.text.TextFormat;
import flash.printing.PrintJobOptions;

class Print extends Sprite{
	private var pages:Array;
	public function Print(cards:Cards = null) {
		pages = [];
		if (cards) {
			setPages(cards);
		}
	}
	public function setPages(cards:Cards):void {
		var length:int = cards.array.length;
		var n:int = Math.ceil(length / 16);
		for (var i:int = 0; i < n; i++) {
			pages[i] = new Sprite();
			var m:int = (i == (n - 1))?(length - 16*i):16;
			for (var j:int = 0; j < m; j++) {
				cards.array[i * 16 + j].x = cards.array[i * 16 + j].width * (j % 4);
				cards.array[i * 16 + j].y = cards.array[i * 16 + j].height * (Math.floor(j/4));
				pages[i].addChild(cards.array[i*16+j]);
			}
		}
		this.addChild(pages[0]);
	}
	public function start():void{
		var pj:PrintJob = new PrintJob();
		if (pj.start()) {
			var n:int = pages.length;
			for (var i:int = 0; i < n; i++) {
				pj.addPage(pages[i], new Rectangle(0, 0, 842, 595));
			}
			pj.send();
		}
	}
}

import flash.text.TextField;
import flash.display.Sprite;
import flash.text.TextFormat;
class Cards {
	public var array:Array;
	public function Cards(data:Data = null) {
		array = [];
		if(data){
			setData(data);
		}
	}
	public function setData(data:Data):void {
		for (var i:int = 0; i < data.validLength; i++) {
			var ar:Array = data.getValidData(i);
			var tfArray:Array = [];
			array[i] = new Sprite();
			array[i].graphics.lineStyle(0, 0x999999);
			array[i].graphics.drawRect(0, 0, 842 / 4, 595 / 4);
			array[i].graphics.endFill();
			for (var j:int = 1; j < ar.length; j++) {
				tfArray[j] = new TextField();
				tfArray[j].defaultTextFormat = new TextFormat("_sans",9);
				tfArray[j].text = ar[j];
				if (j == 1) {
					//tfArray[j].text = ar[j].substr(0,ar[j].length-2);
					tfArray[j].text = ar[j];
					tfArray[j].autoSize = "left";
					tfArray[j].x = 842 / 4 - tfArray[j].width-4;
					tfArray[j].y = 4;
				}else if (j == 2) {
					tfArray[j].defaultTextFormat = new TextFormat("_sans",8);
					tfArray[j].text = ar[j];
					tfArray[j].x = 4;
					tfArray[j].y = 4;
					tfArray[j].autoSize = "left";
				}else if (j == 3) {
					tfArray[j].width = 842 / 4-8;
					tfArray[j].multiline = true;
					tfArray[j].wordWrap  = true;
					tfArray[j].x = 4;
					tfArray[j].y = 32;
					tfArray[j].height = 42;
				}else if (j == 4) {
					tfArray[j].border = true;
					tfArray[j].multiline = true;
					tfArray[j].wordWrap  = true;
					tfArray[j].x = 4;
					tfArray[j].y = 68;
					tfArray[j].width = 842 / 4 - 8;
					tfArray[j].height = 595 / 4-tfArray[j].y-4;
				}else if (j == 5) {
					tfArray[j].defaultTextFormat = new TextFormat("_sans",8);
					tfArray[j].text = ar[j];
					tfArray[j].x = 4;
					tfArray[j].y = 14;
					tfArray[j].autoSize = "left";
				}else if (j == 6) {
					tfArray[j].defaultTextFormat = new TextFormat("_sans",7);
					tfArray[j].text = ar[j];
					tfArray[j].autoSize = "left";
					tfArray[j].x = 842 / 4 - tfArray[j].width-4;
					tfArray[j].y = 14;
				}
				array[i].addChild(tfArray[j]);
			}
		}
	}
}

//データを管理するためのクラス
class Data {
	private var _obj:Object;
	private var _array:Array;
	//ともかく入れた数
	private var _trLength:int;
	private var _tdLength:int;
	
	private var _charge:String;
	private var _team:String;
	public function Data() {
		_obj = { };
		_trLength = 0;
	}
	public function setData(str:String, trNum:int, tdNum:int):void {
		_trLength = (_trLength < trNum)?trNum:_trLength;
		_tdLength = (_tdLength < tdNum)?tdNum:_tdLength;
		
		if (tdNum == 0) {
			if (str == "") {
				str = _team;
			}else{
				_team = str;
			}
		}else if (tdNum == 1) {
			if (str == "") {
				str = _charge;
			}else{
				_charge = str;
			}
		}
		
		_obj[String(trNum + "_" + tdNum)] = str;
	}
	public function get trLength():int {
		return _trLength;
	}
	public function get tdLength():int {
		return _tdLength;
	}
	public function getTr(trNum:int):Array {
		var array:Array = [];
		for (var i:int = 0; i < _tdLength; i++) {
			array[i] = _obj[String(trNum + "_" + i)]
		}
		return array;
	}
	//有効設定数
	public function get validLength():int {
		if(!_array){
			_array = [];
			for (var i:int = 0; i < _trLength; i++) {
				var array:Array = getTr(i);
				if (array[3] || array[4]) {
					_array.push(array);
				}
			}
		}
		return _array.length;
	}
	public function getValidData(num:int):Array {
		if(!_array){
			validLength;
		}
		return _array[num];
	}
	
	
}

//fileの読み込み
import flash.display.Loader;
import flash.events.Event;
import flash.net.FileReference;
import flash.system.LoaderContext;
class LoadFile{
	private var _fileReference:FileReference;
	public var atComplete:Function = function(event:Event):void{};
	/**
	 * 開始
	 *
	 */
	public function start():void
	{
		if(_fileReference){
			return;
		}
		_fileReference = new FileReference();
		_fileReference.browse();
		_fileReference.addEventListener(Event.SELECT,atSelect);
	}
	/**
	 * ファイルの選択が完了すると動く
	 * @param event
	 *
	 */
	private function atSelect(event:Event):void {
		_fileReference.removeEventListener(Event.SELECT,atSelect);
		_fileReference.addEventListener(Event.COMPLETE, atFileComplete);
		_fileReference.load();
	}
	/**
	 * 選択したファイルを読み込み完了すると動く
	 * @param event
	 *
	 */
	private function atFileComplete(event:Event):void{
		_fileReference.removeEventListener(Event.COMPLETE, atFileComplete);
		//trace(_fileReference.type)
		if (_fileReference.type == ".xhtml") {
			atComplete(event);
			return;
		}
		var loader:Loader = new Loader();
		loader.loadBytes(event.target.data, new LoaderContext());
		loader.contentLoaderInfo.addEventListener(Event.COMPLETE, atBytesComplete);
	}
	/**
	 * 読み込んだファイルのバイトアレイを変換完了で動く
	 * @param event
	 *
	 */
	private function atBytesComplete(event:Event):void{
		event.target.removeEventListener(Event.COMPLETE,atBytesComplete);
		atComplete(event);
	}
}
