/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sTp9
 */

// ----------------------------------------------------------------------------------------------
/// @INIT>FLASH	-----------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------------
package  
{	import flash.display.Sprite;
	import flash.geom.Point;
	/** @author http://wonderfl.net/user/Vladik */		
	[SWF(width="465", backgroundColor="0x38673D", height="465", frameRate="60")]
	public class LocalGlobalPoint extends Sprite 
	{
		public function LocalGlobalPoint() { sw = stage.stageWidth; sh = stage.stageHeight; stage.addChild( new Log() );  
		graphics.beginFill(0x38673D); graphics.drawRect(0, 0, 2000, 2000); graphics.endFill();
		
			// ----------------------------------------------------------------------------------------------
			/// @INIT>BOXES	-----------------------------------------------------------------------------
			// ----------------------------------------------------------------------------------------------
			
			var RED:Rect = new Rect(250, 250, 0xFF0000, 0.5,  0.5, 140, 140, onClick);
			RED.name = "RED";
			addChild( RED );
			
			var BLUE:Rect = new Rect(100, 30, 0x46DBF0, 0,0, 40, 0, onClick);
			BLUE.name = "BLUE";
			RED.addChild( BLUE );
			
			var GREEN:Rect = new Rect(200, 100, 0x23BB09, 0.2, 0.2, 350, 300, onClick);
			addChild( GREEN );
			GREEN.name = "GREEN";
			
			var YELLOW:Rect = new Rect(50, 50, 0xFFFF00, .5, .5, 80, 0, onClick);
			GREEN.addChild( YELLOW );
			YELLOW.name = "YELLOW";
			YELLOW.angularSpeed = -GREEN.angularSpeed;
			
			// ----------------------------------------------------------------------------------------------
			/// @HELP>MESSAGE	-----------------------------------------------------------------------------
			// ----------------------------------------------------------------------------------------------
			
			var stageClick:Function = function(e:*):void{ if ( e.target != stage) return;
			log('RED.addChild( BLUE )', '\nGREEN.addChild(YELLOW)', '\nClick on the colored boxes'); };
			stage.addEventListener('click', stageClick);stageClick();
		}
		
		
		
		// ----------------------------------------------------------------------------------------------
		/// @ON>BOX>CLICK	-----------------------------------------------------------------------------
		// ----------------------------------------------------------------------------------------------
		
		private function onClick( r:Rect ):void
		{
			// Transform points
			var p:Point = new Point( r.mouseX, r.mouseY );
			var p1:Point = r.localToGlobal( p );
			
			p = new Point( stage.mouseX, stage.mouseY );
			
			var p3:Point = r.parent.globalToLocal( p );
			var p4:Point = r.globalToLocal(p); 
			
			
			// Change log output colot
			Log.t.textColor = r.color;
			
			// Log Rect click event message
			log( 'this=', r.name, ": ", 
				'box local mouse(mx):', r.mouseX.toFixed(0), 
				'\(my):', r.mouseY.toFixed(0), 
				'\nstage mouse(smx):', stage.mouseX.toFixed(0), 
				'\t(smy):', stage.mouseY.toFixed(0),
				'\t\n<font color="#F08D15">ORANGE CLICK</font>=this.localToGlobal(mx, my) = ' , p1,
				'\t\n<font color="#FFFFFF">WHITIE</font>=this.globalToLocal(smx, smy) = ' , p4,
				'\t\n<font color="#888888">BLACK</font>=this.parent.globalToLocal(smx, smy) = ' , p3
			);
			
			// Display Click on stage!
			stage.addChild( new Click(p1.x , p1.y, 0xF08D15 ) );
			//stage.addChild( new Click(p2.x , p2.y, 0xD818ED ) );
			
			r.graphics.beginFill(0xFFFFFF);
			r.graphics.drawCircle(p4.x, p4.y, 4 + Math.random() * 5);
			r.graphics.endFill();
			
			r.graphics.beginFill(0);
			r.graphics.drawEllipse(p3.x - 4, p3.y - 2, 13, 8);
			r.graphics.endFill();
		}
	}
}

// ----------------------------------------------------------------------------------------------
/// @HELPERS	-----------------------------------------------------------------------------
// ----------------------------------------------------------------------------------------------

import flash.display.Sprite;
import flash.events.Event;
import flash.text.TextField;
import flash.text.TextFormat;

class Rect extends Sprite
{
	public var angularSpeed:Number = Math.random() * 4 - 2;
	public var color:uint;
	public function Rect( w:Number, h:Number, c:uint, pivotX:Number = 0, pivotY:Number = 0, x:Number = 0, y:Number = 0 , onClick:Function = null )
	{
		color = c;
		this.x = x;
		this.y = y;
		useHandCursor = buttonMode = true;
		graphics.beginFill( c );
		graphics.drawRect(0 - w * pivotX, - h * pivotY, w, h );
		graphics.endFill();
		graphics.beginFill( 0x0 );
		graphics.drawCircle(0, 0, 7);
		graphics.endFill();
		graphics.beginFill( 0xFFFFFF );
		graphics.drawCircle(0, 0, 5);
		graphics.endFill();
		var _self:Rect = this;if ( onClick!=null ) addEventListener('mouseDown', function(e:*):void { if( e.target == _self ) onClick( _self ); } );
		addEventListener('enterFrame', function(e:*):void{rotation += angularSpeed;});
	}
}
class Log extends Sprite 
{
	public static var t:TextField;
	public function Log() 
	{
		t = new TextField();
		addEventListener(Event.ADDED_TO_STAGE, init);
	}
	
	private function init(e:Event):void 
	{
		removeEventListener(Event.ADDED_TO_STAGE, init);
		addChild( t );
		t.height = 160;
		t.alpha = 0.6;
		t.background = true; t.backgroundColor = 0x0;
		t.defaultTextFormat = new TextFormat('Verdana', 16, 0xFFFFFF,
		null,null,null,null,null,'left');
		t.multiline = t.wordWrap = true;
		mouseEnabled = mouseChildren = t.mouseEnabled = false;
		t.width = sw; t.y = sh -t.height;
		
	}
}
class Click extends Sprite
{
	private var c:uint;
	private var r:Number = 5;
	public function Click(x:Number, y:Number, c:uint)
	{
		this.c = c;
		this.x = x;
		this.y = y;
		addEventListener('enterFrame', loop);
	}
	
	private function loop(e:*):void
	{
		graphics.clear();
		graphics.beginFill(c);
		graphics.drawCircle(0, 0, r);
		graphics.endFill();
		graphics.lineStyle(2, 0);
		graphics.drawCircle(0, 0, r);
		graphics.lineStyle(2, 0xFFFFFF);
		graphics.drawCircle(0, 0, r + 1);
		r+=1;
		
		alpha = ( 100 - r ) / 100;
		
		if ( r > 100) {
			removeEventListener('enterFrame', loop);
			if(parent ) parent.removeChild( this );
		}
	}
}
var sw:int, sh:int;
function log( ...arguments ):void {
	/*var tabs:String = "[";
	var l:Number = int(sw/arguments.length)
	var c:int = 0; while ( c < arguments.length ) 
	{
		tabs += String(l * (c + 1)) + ( c == arguments.length - 1  ? '' : ','); c++;
	} tabs += "]";
	Log.t.htmlText = "<textformat tabstops = '"+tabs+"' >" + 
	arguments.join('\t') + "</textformat>";
	*/
	Log.t.htmlText = arguments.join(' ');
}