/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sTm0
 */

package {
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.text.TextField;

  import funnel.*;

  public class MeasuringTheDistanceBySonar extends Sprite {
    // Arduino
    private var arduino:Arduino;

    // センサに接続したピン
    private var sensorPin:Pin;

    // 距離を表示するテキストフィールド
    private var textField:TextField;

    public function MeasuringTheDistanceBySonar() {
      // Arduinoのインスタンスを生成してsensorPinを初期化
      arduino = new Arduino(Arduino.FIRMATA);
      sensorPin = arduino.analogPin(0);

      // 距離を表示するテキストフィールドを追加
      textField = new TextField();
      addChild(textField);

      // 毎フレームごとに発生するイベントのイベントリスナをセット
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    // 毎フレームごとに以下を実行
    private function onEnterFrame(e:Event):void {
      // センサの値を読み取る
      var value:Number = sensorPin.value;

      // 読み取った値をインチ単位とセンチ単位に変換
      var rangeInInches:Number = value * 512;
      var rangeInCentimeters:Number = rangeInInches * 2.54;

      // 小数点以下を四捨五入して距離をそれぞれの単位で表示
      textField.text = Math.round(rangeInInches) + " inch (";
      textField.appendText(Math.round(rangeInCentimeters) 
                           + " cm)");
    }
  }
}
