/**
 * Copyright hacker_zxh9vkwz ( http://wonderfl.net/user/hacker_zxh9vkwz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sSt4
 */

// forked from aobyrne's Oil painting explorer forked from: OilPainting
package {
    import com.bit101.components.CheckBox;
    import com.bit101.components.HUISlider;
    import com.bit101.components.VBox;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.display.CapsStyle;
    import flash.display.LineScaleMode;
    public class OilPaintingSize extends Sprite {
        private var jackson:Sprite;
        private var prevX:int;
        private var prevY:int;
        private var startPosX:int;
        private var startPosY:int;
        private var disX:Number;
        private var disY:Number;
        private var color:uint;
        private var sCLineChart:SCLineChart;
        private var sCLineChart2:SCLineChart;
        private var dispersion2:HUISlider;
        public function OilPaintingSize() {
            jackson = addChild(new Sprite()) as Sprite;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, _move);
            //stage.addEventListener(MouseEvent.MOUSE_DOWN,_down)
            jackson .doubleClickEnabled = true;
            stage.addEventListener(MouseEvent.DOUBLE_CLICK, onMouseDoubleClick)
            var vBox:VBox = new VBox(this, 0, 0);
            var followerModel:FollowerModel = new FollowerModel;
            followerModel.amount = 2;
            //followerModel.sprite = sprite.parent as Sprite;
            followerModel.xx = 260;
            followerModel.autoScale = false;
            followerModel.minimum = -100;
            followerModel.maximum = 100;
            followerModel.referencesx = [0];
            sCLineChart = new SCLineChart(vBox, 0, 0, [], followerModel);
            var followerModel2:FollowerModel = new FollowerModel;
            followerModel2.amount = 5;
            //followerModel.sprite = sprite.parent as Sprite;
            followerModel2.xx = 260;
            followerModel2.autoScale = false;
            followerModel2.minimum = 0;
            followerModel2.maximum = 10;
            sCLineChart2 = new SCLineChart(vBox, 0, 0, [], followerModel2);
            var pi:Number = 0.1 * 180 / Math.PI;
            trace( "pi : " + pi );
            dispersion2 = new HUISlider(vBox, 0, 0, 'dispersion2');
            dispersion2.maximum = 20;
        }
        private function onMouseDoubleClick(e:MouseEvent):void{
             jackson.graphics.clear();
        }
        private function _down(e:MouseEvent):void {
            color = Math.random() * 0xFFFFFF;    
        }
        private function _move(e:MouseEvent):void {
            var distance:Number = Math.sqrt(Math.pow(prevX - startPosX, 2) + Math.pow(prevY - startPosY, 2))
            var a:Number = distance * 10 * (Math.pow(Math.random(), 2) - 0.5)
            var r:Number = Math.random() - 0.5
            var size:Number = Math.random() * 15 / (distance+dispersion2.value)
            disX = (prevX - startPosX) * Math.sin(0.5) + startPosX;
            disY = (prevY - startPosY) * Math.cos(0.5) + startPosY;
            startPosX = prevX;
            startPosY = prevY;
            prevX = mouseX
            prevY = mouseY
            
            jackson.graphics.moveTo(startPosX, startPosY);
            jackson.graphics.curveTo(disX,disY,prevX,prevY)
            jackson.graphics.lineStyle(((Math.random()+20/10-0.5)*size+(1-Math.random()+30/20-0.5)*size), color,1, false, LineScaleMode.NONE, CapsStyle.ROUND);    
            jackson.graphics.moveTo(startPosX + a, startPosY + a);
            jackson.graphics.lineTo(startPosX+r+a, startPosY+r+a);
            jackson.graphics.endFill();
            sCLineChart.addToArray(Math.abs(a));
            sCLineChart2.addToArray(size);
        }
    }
}
import com.bit101.components.Label;
import com.bit101.components.VBox;
import flash.display.Sprite;
class FollowerModel
{
    private var _fixedAmount:int;
    private var _xx:Number;
    private var _yy:Number;
    private var _name:String;
    private var _referencesx:Array;
    private var _referencesy:Array;
    private var _maximum:Number;
    private var _minimum:Number;
    private var _sprite:Sprite;
    private var _amount:int;
    private var _autoScale:Boolean;
    
    public function FollowerModel() 
    {
        super();
        xx = 0;
        yy = 0;
        name = 'defalut name';
        referencesx = [];
        referencesy = [];
        maximum = 1;
        minimum = 0;
        amount = 1;
        autoScale = true;
        fixedAmount = 100;
    }
    
    public function get xx():Number 
    {
        return _xx;
    }
    
    public function set xx(value:Number):void 
    {
        _xx = value;
    }
    
    public function get yy():Number 
    {
        return _yy;
    }
    
    public function set yy(value:Number):void 
    {
        _yy = value;
    }
    
    public function get name():String 
    {
        return _name;
    }
    
    public function set name(value:String):void 
    {
        _name = value;
    }
    
    public function get referencesx():Array 
    {
        return _referencesx;
    }
    
    public function set referencesx(value:Array):void 
    {
        _referencesx = value;
    }
    
    public function get referencesy():Array 
    {
        return _referencesy;
    }
    
    public function set referencesy(value:Array):void 
    {
        _referencesy = value;
    }
    
    public function get maximum():Number 
    {
        return _maximum;
    }
    
    public function set maximum(value:Number):void 
    {
        _maximum = value;
    }
    
    public function get minimum():Number 
    {
        return _minimum;
    }
    
    public function set minimum(value:Number):void 
    {
        _minimum = value;
    }
    
    public function get sprite():Sprite 
    {
        return _sprite;
    }
    
    public function set sprite(value:Sprite):void 
    {
        _sprite = value;
    }
    
    public function get amount():int 
    {
        return _amount;
    }
    
    public function set amount(value:int):void 
    {
        _amount = value;
    }
    
    public function get autoScale():Boolean 
    {
        return _autoScale;
    }
    
    public function set autoScale(value:Boolean):void 
    {
        _autoScale = value;
    }
    
    public function get fixedAmount():int 
    {
        return _fixedAmount;
    }
    
    public function set fixedAmount(value:int):void 
    {
        _fixedAmount = value;
    }
}

import com.bit101.charts.LineChart;
import flash.display.DisplayObjectContainer;
import flash.display.Sprite;
class SCLineChart extends LineChart
{
    private var array1:Array;
    private var referenceYs:Array;
    private var model:FollowerModel;
    private var fixedAmount:int;
    private var max:Number;
        public function SCLineChart(parent:DisplayObjectContainer=null, xpos:Number=0, ypos:Number=0, data:Array=null,model:FollowerModel=null)
        {
            super(parent, xpos, ypos, data);
            this.model = model;
            this.referenceYs = referenceYs;
            array1 = [];
            setSize(width, 50);
            autoScale = model.autoScale;
            maximum = model.maximum;
            minimum = model.minimum;
            max = 0;
        }
        public function addToArray(value:Number,index:int=-1):void 
        {
            if (index==-1) 
            {
                array1[array1.length]=value
            }
            else
            {
                array1[index] = value;
                
            }
            if (array1.length>model.fixedAmount) 
            {
                array1.shift();
            }
            data = array1;
            max = Math.max(max, value);
            trace( "max : " + max );
        }
        override protected function drawChart():void 
        {
            super.drawChart();
            if (model) 
            {
                var rr:Array = model.referencesy;    
                var rl:uint = rr.length;
                for (var i:int = 0; i < rl; i++) 
                {
                    var referenceY:Number = model.referencesy[i];    
                    var border:Number = 2;
                    var chartHeight:Number = _height - border;
                    var max:Number = getMaxValue();
                    var min:Number = getMinValue();
                    var scale:Number = chartHeight / (max - min);
                    _chartHolder.graphics.moveTo(border, -scale * referenceY);
                    _chartHolder.graphics.lineTo(_width, -scale * referenceY);
                }
            }
            
        }
        //private function follower(vBox:Sprite, QTY:int, xx:Number, yy:Number, maximum:Number, namef:String, references:Array = null):Vector.<SCLineChart>
        public static function follower(modelm:FollowerModel):Vector.<SCLineChart>
        {
            var sCLineChart:SCLineChart;
            var charts:Vector.<SCLineChart> = Vector.<SCLineChart>([]);
            var vBox:VBox = new VBox(modelm.sprite,modelm.xx,modelm.yy);
            new Label(vBox, 0, 0, modelm.name);
            for (var i:int = 0; i < modelm.amount; i++) 
            {
                sCLineChart = new SCLineChart(vBox, 0, 0, [],modelm);
                charts[i] = sCLineChart ;
                //sCLineChart.setSize(sCLineChart.width, 50);
                //sCLineChart.autoScale = modelm.autoScale;
                //sCLineChart.maximum = modelm.maximum;
                //sCLineChart.minimum = modelm.minimum;
                
            }
            return charts;
        }
}
