/**
 * Copyright chimanaco ( http://wonderfl.net/user/chimanaco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sSoy
 */

/**
 * 
 * How to make flash rotating spiral 
 * http://www.flashconf.com/actionscript/how-to-make-flash-rotating-spiral/
 * 
 * 高速化したい
 * 
 * 気持ちいいところを探すために作ったのですが、見ていると気持ち悪くなりますね。
 * 
 */
package 
{
    import com.bit101.components.HUISlider;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    import frocessing.color.ColorHSV;
    import net.hires.debug.Stats;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "000000")]
    public class Spiral extends Sprite
    {
        private static const R:int = 330;
        private static const RADIUS_ADD:int = 5;
        private var _color:int = 90;
        private var _rotAdd:Number = 0.1;
        private var _thin:int = 4;
        private var _speed:Number = 0.1;
        private var _radius:Number = 0;
        private var _angle:Number = 0;
        private var _rot:Number = 0;
        private var _xpos:Number;
        private var _ypos:Number;
        private var _centerX:Number = stage.stageWidth / 2;
        private var _centerY:Number = stage.stageHeight / 2;
        private var _container:Sprite;
        private var _spirals:Array = [];
        private var _bitmapData:BitmapData;
        private var _bitmap:Bitmap;
        private var _rotAddSlider:HUISlider;
        private var _speedSlider:HUISlider;
        private var _colorSlider:HUISlider;
        private var _thinSlider:HUISlider;
        
        // constructor
        public function Spiral() {
            // Container
            _container = new Sprite()
            _container.x = _centerX;
            _container.y = _centerY;
            
            // Spiral
            setSpiral();
            
            // BitmapData
            _bitmapData = new BitmapData(465, 465, false, 0x000000);
            // Bitmap
            _bitmap = addChild(new Bitmap(_bitmapData, PixelSnapping.ALWAYS, false)) as Bitmap;
            
            // Stats
            addChild(new Stats());
        
            // Slider
            setSlider();
            
            addEventListener (Event.ENTER_FRAME, onEnterFrame);
        }
        
        /**
        * setSpiral
        *
        * @access private
        * @param 
        * @return void
        */
        private function setSpiral():void
        {
            for (var i:int = 0; i < _color; i++) 
            {
                var sp:Shape = new Shape();
                
                // Color                
                var c:ColorHSV = new ColorHSV();
                c.h = 360 * i / _color;
                
                // Set the _container's graphics line style to be _thin and decided color
                sp.graphics.lineStyle (_thin, c.value);
                sp.rotation = i * 360 / _color;
                _container.addChild(sp);
                _spirals.push(sp);
            }
        }
        
        /**
        * resetSpiral
        *
        * @access private
        * @param 
        * @return void
        */
        private function resetSpiral():void
        {
            // delete Spiral
            var len:int = _spirals.length;
            for (var i:int = 0; i < len; i++) 
            {
                _container.removeChild(_spirals[i]);
                _spirals[i] = null;
            }
            _spirals = [];
            
            // set default value
            _radius = 0;
            _angle = 0;
            
            // set slider value
            _rotAdd = _rotAddSlider.value;
            _color = Math.ceil(_colorSlider.value);
            _speed = _speedSlider.value;
            _thin = _thinSlider.value;
            
        }
        
        /**
        * setSlider
        *
        * @access private
        * @param 
        * @return void
        */
        private function setSlider():void
        {
            var dx:int = 80;
            var dy:int = 5;
            var offsetX:int = 200;
            var offsetY:int = 20;
            
            // Slider
            _rotAddSlider = new HUISlider(this, 0, dy, "rotation", sliderHandler);
            _colorSlider = new HUISlider(this, 0, dy + offsetY, "color", sliderHandler);
            _speedSlider = new HUISlider(this, 0, dy, "speed", sliderHandler);
            _thinSlider = new HUISlider(this, 0, dy + offsetY, "thin", sliderHandler);
            
            _rotAddSlider.x = _colorSlider.x = dx;
            _speedSlider.x = _thinSlider.x = dx + offsetX;
            
            _rotAddSlider.value = _rotAdd;
            _rotAddSlider.minimum = -5;
            _rotAddSlider.maximum = 5;
            
            _colorSlider.value = _color;
            _colorSlider.minimum = 1;
            _colorSlider.maximum = 90;
            
            _speedSlider.value = _speed;
            _speedSlider.minimum = 0.01;
            _speedSlider.maximum = 10;
            
            
            _thinSlider.value = _thin;
            _thinSlider.minimum = 1;
            _thinSlider.maximum = 10;
        }
        
        /**
        * sliderHandler
        *
        * @access private
        * @param e:Event
        * @return void
        */
        private function sliderHandler(event:Event):void
        {
            resetSpiral();
            setSpiral();
        }
        
        /**
         * onEnterFrame
         *
         * @access public
         * @param e    Event
         * @return void
         */
        private function onEnterFrame (e:Event):void { 
            // Stop the drawing after the radius is over R.
            if (_radius > R) {
                _speed = 0;
            }
            else {
                // Increase the _radius in each frame
                _radius += RADIUS_ADD;

                // New x and y coordinates
                _xpos = Math.cos(_angle) * _radius;
                _ypos = Math.sin(_angle) * _radius;

                for (var i:int = 0; i < _color; i++) 
                {
                    // Draw to the new coorninates
                    _spirals[i].graphics.lineTo (_xpos,_ypos);
                }
            }
            
            // The greater the speed, the faster we draw circles
            _angle += _speed;
            
            // Rotate the _container
            _rot += _rotAdd;
            
            var bitmapData:BitmapData = _bitmapData;
            // Bitmap lock
            bitmapData.lock();
            
            bitmapData.fillRect(bitmapData.rect, 0x000000);    // no fillrect does also good effect
            
            // Matrix
            var mat:Matrix = new Matrix();
            mat.rotate(_rot);
            mat.translate(_centerX, _centerY);
            bitmapData.draw(_container, mat);
             // Bitmap unlock
            bitmapData.unlock();
        }
    }
}