/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sSQ5
 */

package {
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    
    public class WhoIAm extends Sprite {
        public var elements:Array;
        
        public var ai:int = 0;
        
        public const FADE_IN:String = "fade in";
        public const FADE_OUT:String = "fade out";
        
        public function WhoIAm() {
            stage.frameRate = 60;
            
            elements = [];
            
            var tf:TextField = text("greekfellows");
            
            addElement(tf, FADE_IN, next, this, []);
            
            this.addEventListener(Event.ENTER_FRAME, whoiam);
        }
        
        public function addElement(target:DisplayObject, type:String, func:Function = null, ftarget:* = null, fargs:Array = null):void {
            elements.push(new Element(target, type, {}, func, ftarget, fargs));
        }
        
        public function next():void {
            switch (ai) {
                case 0:    // greekfellows fades out
                addElement(this.getChildAt(0), FADE_OUT, next, this, []);
                break;
                
                case 1:    // removes greekfellows, who's this guy fades in
                this.removeChildAt(0);
                addElement(text("who's this guy?"), FADE_IN, next, this, []);
                break;
                
                case 2:    // who's this guy fades out
                addElement(this.getChildAt(0), FADE_OUT, next, this, []);
                break;
            }
            
            ai++;
        }
        
        public function text(str:String):TextField {
            var tf:TextField = new TextField();
            tf.text = str;
            tf.selectable = false;
            
            var fmt:TextFormat = new TextFormat();
            fmt.font = "Segoe UI Light";
            fmt.size = 48;
            fmt.align = "center";
            
            tf.setTextFormat(fmt);
            tf.width = tf.textWidth + 4;
            tf.height = tf.textHeight + 4;
            tf.x = -this.x + 465 / 2 - tf.width / 2;
            tf.y = -this.y + 465 / 2 - tf.height / 2;
            
            this.addChild(tf);
            
            return tf;
        }
        
        public function whoiam(e:Event):void {
            for (var i:int = 0; i < elements.length; i++) {
                if (!elements[i].finished) {
                    if (!elements[i].started) {
                        switch (elements[i].type) {
                            case FADE_IN:
                            elements[i].target.alpha = 0;
                            break;
                            
                            case FADE_OUT:
                            elements[i].target.alpha = 1;
                            break;
                        }
                        
                        elements[i].started = true;
                    } else {
                        switch (elements[i].type) {
                            case FADE_IN:
                            elements[i].target.alpha += .05;
                            
                            if (elements[i].target.alpha >= 1) {
                                elements[i].target.alpha = 1;
                                elements[i].finished = true;
                            }
                            break;
                            
                            case FADE_OUT:
                            elements[i].target.alpha -= .05;
                            
                            if (elements[i].target.alpha <= 0) {
                                elements[i].target.alpha = 0;
                                elements[i].finished = true;
                            }
                            break;
                        }
                    }
                } else {
                    if (elements[i].func != null) {
                        elements[i].func.apply(elements[i].ftarget, elements[i].fargs);
                    }
                    
                    elements.splice(i, 1);
                }
            }
        }
    }
}

import flash.display.DisplayObject;

class Element {
    public var target:DisplayObject;
    public var params:Object;
    public var type:String;
    public var func:Function;
    public var ftarget:*;
    public var fargs:Array;
    public var started:Boolean = false;
    public var finished:Boolean = false;
    
    public function Element(target:DisplayObject, type:String, params:Object, func:Function = null, ftarget:* = null, fargs:Array = null):void {
        this.target = target;
        this.type = type;
        this.params = params;
        
        if (func != null) this.func = func;
        if (ftarget != null) this.ftarget = ftarget;
        if (fargs != null) this.fargs = fargs;
    }
}