/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sS6E
 */

package
{
    import flash.filters.*;
    import flash.utils.*;
    import flash.filters.BlurFilter;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.events.Event;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.typography.*;
    import org.papervision3d.typography.fonts.*;
    import org.papervision3d.view.*;
    import org.papervision3d.core.effects.view.*;
    import org.papervision3d.lights.*;

    [SWF(width=465,height=465,backgroundColor = "0xffffff", frameRate = "30")]
    
    public class Text3DSample extends ReflectionView
    {
            
      public var msg:String="NOT FLASH or HTML5 But FLASH and HTML5 !";//※英文法が正しいかどうかは知りません。いやきっと間違ってるんだろうなあ。
       public var material:Letter3DMaterial;
       public var font:HelveticaBold;
       public var word:Text3D;
       public var rot:Number=0;
       
       public var compositeMaterial:CompositeMaterial;
       public var colorMaterial:ColorMaterial;
       public var materialPlane:WireframeMaterial;
       public var plane:Plane;
       
       public var wordTimer:Timer;
       
       public var wordNum:Number=0;//表示する文字のインデックス
       public var replaceWord:String;//追加する文字を入れる
       public var newText:String="";//最終的なテキストを入れる
       
       public var randomTime:Number=0;//表示するタイミングをずらすのに使用
               
        public function Text3DSample ()
        {
            init();
        }
       
       
       public function init():void{
           
           //フィールドを作る
           compositeMaterial=new CompositeMaterial();
           materialPlane=new WireframeMaterial(0x333333,0.4);
           materialPlane.doubleSided=true;
           colorMaterial=new ColorMaterial(0xdddddd,0.4);
           compositeMaterial.addMaterial(materialPlane);
           compositeMaterial.addMaterial(colorMaterial);
           plane=new Plane(compositeMaterial,2500,2500,10,10);
           plane.pitch(90)
           scene.addChild(plane);
          
           //ベクターテキストを作る
           //マテリアルを用意 
           material=new Letter3DMaterial(0x1111ff);
           material.doubleSided=true;
           
           //フォントを用意
           font=new HelveticaBold();
           
           //Text3Dに、表示する文字列、フォント、マテリアルを指定する
          word=new Text3D("",font,material);                  
           
          //シーンに追加
          scene.addChild(word);
          word.y=150;
          
          addEventListener(Event.EXIT_FRAME,loop); 
          
          //タイマースタート
          wordTimer=new Timer(100);
          wordTimer.addEventListener(TimerEvent.TIMER,addWordTimer);
          wordTimer.start();
          
          stage.addEventListener(MouseEvent.CLICK,onClick);
           
       }
       
       //ループ処理
       public function loop(e:Event):void{
            //レンダリングスタート
          singleRender();
           rot+=2;
           camera.x=300*Math.sin(rot*Math.PI/180);
           camera.y=800*Math.cos(rot*Math.PI/180)+800;
           camera.z=1800*Math.cos(rot*Math.PI/180);         
       }
       
       //タイマー関数
       public function addWordTimer(e:TimerEvent):void{
           
           //表示するタイミングをランダムにする
           randomTime=Math.ceil(Math.random()*100);
           
           //randomTimeの値が400より大きかったら文字を追加する
           if(randomTime>20){
               
           //テキストを一旦初期化する
           scene.removeChild(word);
           word.material.destroy();
           word=null;
           
           //マテリアルをもう一回作り直す
           material=new Letter3DMaterial(0x2222ff);
           material.doubleSided=true;
           
           //文字を抜き出す
           replaceWord=msg.charAt(wordNum);
          
           //文字を連結
           newText=newText.concat(replaceWord);
           
           //Text3Dクラスをもう一回作り直す
           word=new Text3D(newText+"_",font,material);           
           scene.addChild(word);
           word.y=150;
           
           //鏡面反射を設定
             surfaceHeight=0;
             viewportReflection.filters=[new BlurFilter(2,2,2)]; 
             viewportReflection.alpha=0.5; 

           
                //文字数分タイマーを繰り返したらタイマーをストップさせる 
                //文字数未満ならカウントアップして次の文字へ進む
               if(wordNum==msg.length-1){
                   
                   wordTimer.stop();
                   
                    //テキストを一旦初期化する
                   scene.removeChild(word);
                   word.material.destroy();
                   word=null;
                   
                   //マテリアルをもう一回作り直す
                   material=new Letter3DMaterial(0x2222ff);
                   material.doubleSided=true;
                   
                   //先頭のアンダーバーを無くしたテキストを表示する
                   word=new Text3D(newText,font,material); 
                   scene.addChild(word);
                   word.y=150;
                   
                   }else{
                wordNum++
                   }
               
           }

            
           
       }
       
       //クリックしたら初期化して実行
       public function onClick(e:MouseEvent):void{
           
           wordNum=0;
           scene.removeChild(word);
           replaceWord="";
           newText="";
           wordTimer.reset();
           wordTimer.start();
           
       }

             
       
       
    }
}