/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sRpv
 */

//bonus party version lulz
package {
  import flash.display.*;
  import flash.events.Event;
  import flash.geom.ColorTransform;
  import flash.utils.getTimer;

  [SWF(backgroundColor="#000000", frameRate="45")]
  public class ch34ex7 extends Sprite {
    protected var r:Number; //radius
    protected var bmp:BitmapData;
    protected var shapes:Vector.<Shape>;
    protected const COPIES:int = 3;
    protected const DIM:ColorTransform = new ColorTransform(0.9, 0.9, 0.9);
    
    public function ch34ex7() {
      bmp = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0);
      var bitmap:Bitmap = new Bitmap(bmp, PixelSnapping.NEVER, false);
      addChild(bitmap);
      
      shapes = new Vector.<Shape>()
      for (var i:int = 0; i < COPIES; i++) {
        var shape:Shape = new Shape();
        shape.x = stage.stageWidth / 2;
        shape.y = stage.stageHeight / 2;
        shape.rotationY = i * 360/COPIES;
        shape.blendMode = BlendMode.ADD;
        shape.alpha = 0.4 * 1/COPIES;
        addChild(shape);
        shapes.push(shape);
      }
      
      r = Math.min(stage.stageWidth, stage.stageHeight) * 0.4;
      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    protected function onEnterFrame(event:Event):void {
      bmp.draw(stage);
      bmp.colorTransform(bmp.rect, DIM);
      for each (var shape:Shape in shapes) {
        draw(shape);
      }
    }

    protected function draw(shape:Shape):void {
      var index:int = getChildIndex(shape);
      var w:Number = 30 * ((stage.mouseX / stage.stageWidth) - 0.5);
      var r2:Number = r * 0.8 * Math.sin(getTimer() / 3000 + index * 0.2);
      shape.rotationY += 2;
      shape.rotationZ = 60 * ((stage.mouseY / stage.stageHeight) - 0.5);
      shape.graphics.clear();
      shape.graphics.beginFill(rgb(index));
      for (var t:Number = 0; t < Math.PI * 2; t += 0.05) {
        var x:Number = r * Math.sin(t) + r2 * Math.sin(t * w);
        var y:Number = r * Math.cos(t) + r2 * Math.cos(t * w);
        if (t == 0) shape.graphics.moveTo(x, y);
        shape.graphics.lineTo(x, y);
      }
      shape.graphics.endFill();
    }
    
    protected function rgb(offset:uint):uint {
      var r:int = int((Math.sin(getTimer() / 1000 + offset*400) + 1)/2 * 255);
      var g:int = int((Math.sin(getTimer() / 2000 + offset*400) + 1)/2 * 255);
      var b:int = int((Math.sin(getTimer() / 3000 + offset*400) + 1)/2 * 255);
      return r << 16 | g << 8 | b;
    }
  }
}