/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sRoZ
 */

package 
{
    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
    
    /**
     * 図形を描くサンプル
     * @author Hikipuro
     */
    public class Main extends Sprite 
    {
        
        /**
         * コンストラクタ
         */
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        /**
         * 初期化イベント
         * @param    e
         */
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            // 線を引く
            graphics.lineStyle(1, 0xff0000);
            graphics.moveTo(10, 10);
            graphics.lineTo(310, 10);
            
            // 四角形を描く (中を塗りつぶさない)
            graphics.lineStyle(1, 0x0000ff);
            graphics.drawRect(10, 20, 300, 10);
            
            // 四角形を描く (中を塗りつぶす)
            graphics.lineStyle(1, 0x0000ff);
            graphics.beginFill(0xcccccc);
            graphics.drawRect(10, 40, 300, 10);
            graphics.endFill();
            
            // 円を描く (中を塗りつぶす)
            graphics.lineStyle(1, 0x00ff00);
            graphics.beginFill(0xffff00);
            graphics.drawCircle(20, 70, 10);
            graphics.endFill();
            
            // 楕円を描く (中を塗りつぶす)
            graphics.beginFill(0xffff00);
            graphics.drawEllipse(50, 60, 60, 20);
            graphics.endFill();
            
            // 角の丸い四角形を描く (中を塗りつぶさない)
            graphics.lineStyle(2, 0x8888ff, 1.0, true);
            graphics.drawRoundRect(10, 90, 200, 30, 20, 20);
            
            // グラデーションのかかった線を描く
            var colors:Array = [0xff0000, 0x0000ff];
            var alphas:Array = [1.0, 1.0];
            var ratios:Array = [0, 255];
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(310, 6, 0, 0, 0);
            
            graphics.lineStyle(6, 0x000000);
            graphics.lineGradientStyle(GradientType.LINEAR, 
                                        colors,
                                        alphas,
                                        ratios,
                                        matrix);
            graphics.moveTo(10, 140);
            graphics.lineTo(310, 140);
            
            // グラデーションのかかった四角形を描く
            var colors2:Array = [0x000000, 0x00ff00];
            var alphas2:Array = [1.0, 1.0];
            var ratios2:Array = [0, 255];
            var matrix2:Matrix = new Matrix();
            matrix2.createGradientBox(310, 20, 0, 0, 0);
            
            graphics.lineStyle();
            graphics.beginGradientFill(GradientType.LINEAR, 
                                        colors2,
                                        alphas2,
                                        ratios2,
                                        matrix2);
            graphics.drawRect(10, 150, 300, 20);
            graphics.endFill();    
            
            // 曲線を描く
            graphics.lineStyle(3, 0x0000ff);
            graphics.moveTo(10, 190);
            graphics.curveTo(10, 240, 310, 230);
        }
        
    }
    
}