/**
 * Copyright vuja22 ( http://wonderfl.net/user/vuja22 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sRdi
 */

// forked from shapevent's Supershapes / Superformula
package {
    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;

        // more info here: http://actionsnippet.com/?p=1134

    
    [SWF(backgroundColor=0x000000)]
    dynamic public class Test extends MovieClip {
        private var canvas:BitmapData;
                private const TWO_PI:Number = Math.PI * 2;
        
        public function Test(){
           // init
            // Superformula (equations from):
            // http://www.geniaal.be/downloads/AMJBOT.pdf
            // http://en.wikipedia.org/wiki/Superformula
            
            
            // test it out:
            canvas = new BitmapData(700,600,false, 0x000000);
            addChild(new Bitmap(canvas, "auto", true));
            superShape(1, 1, 5, 23, 23, 23, new Point(100,80), 30);
            superShape(1, 3, 8, 13, 13, 3, new Point(200,80), 30);
            superShape(1, 1, 8, 3, 13, 3, new Point(300,80), 30);
            superShape(10,8, 16, 30, 13, 3, new Point(450,80), 30);
            superShape(1,1, 1, .5, .5, .5, new Point(100,190), 100);
            for (var i:int = 0; i <150; i++){
              superShape(1,1, 2, 1+i/800, 4, 8-i * .1, new Point(550,350), 50);
            }
            for (i = 0; i <20; i++){
              superShape(1.1,1.2, 6, 2 + i , 4, 9 - i, new Point(200,350), 50);
            }
                        scaleX = scaleY = 500/700;

        }
        // private methods

        private function superShape(a:Number, b:Number, m:Number, n1:Number, n2:Number, n3:Number, pnt:Point, scale:Number):void{
            var r:Number = 0
            var p:Number = 0;
            var xp:Number = 0, yp:Number = 0;
            while(p <= TWO_PI){
                var ang:Number = m * p / 4;
                with(Math){
                    r = pow(pow(abs(cos(ang) / a), n2) + pow(abs(sin(ang) / b), n3),-1/n1);
                    xp = r * cos(p);
                    yp = r * sin(p);
                }
                p += .01;
                canvas.setPixel(pnt.x + xp *scale, pnt.y + yp * scale,  0xFFFFFF);
             }
        }
        

    }

}