/**
 * Copyright thinktaro ( http://wonderfl.net/user/thinktaro )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sQsZ
 */

package
{
	//重いかも
	import flash.display.BlendMode;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import frocessing.color.ColorHSV;
	import org.papervision3d.cameras.CameraType;
	import org.papervision3d.core.effects.BitmapColorEffect;
	import org.papervision3d.core.effects.BitmapLayerEffect;
	import org.papervision3d.core.effects.utils.BitmapClearMode;
	import org.papervision3d.core.effects.utils.BitmapDrawCommand;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	/**
	 * ...
	 * @author thinktaro
	 */
	[SWF(backgroundColor="0x0")]
	public class Corkscrew3D extends BasicView 
	{
		private var _pixels:Pixels;
                  private var direction:int = 10;
		private const NUM_PIXELS:int = 1000;
		public function Corkscrew3D() 
		{
			super(0,0,true,false);
			addEventListener(Event.ADDED_TO_STAGE,initialize);
		}
		private function initialize(evt:Event):void{
			removeEventListener(Event.ADDED_TO_STAGE,initialize);
			var bfx:BitmapEffectLayer = new BitmapEffectLayer(viewport, stage.stageWidth, stage.stageHeight, true, 0, BitmapClearMode.CLEAR_PRE,true);
			bfx.addEffect(new BitmapLayerEffect(new BlurFilter(8, 8, 4), false));
			bfx.addEffect(new BitmapColorEffect(0.98, 0.98, 0.98, 0.98));
			bfx.drawCommand = new BitmapDrawCommand(null,new ColorTransform(1,1,1,1,-20,-25,-24,1),BlendMode.ADD)
			viewport.containerSprite.addLayer(bfx);
			_pixels = new Pixels(bfx);
			scene.addChild(_pixels);
			_pixels.y = -1300;
			camera.y = 500;
			createObject();
			startRendering();
		}
		private function createObject():void {
			var hsv:ColorHSV = new ColorHSV();
			
			for (var j:int = 0; j < 100; j++) {
				var height:Number = 1;
				var radius:Number = 1;
				for (var i:int = 0; i < NUM_PIXELS; i++) {
					var radian:Number = i / NUM_PIXELS * j * 350 * Math.PI / 180;
					hsv.hr = radian;
					var x:Number = radius * Math.cos(radian);
					var y:Number = height * i;
					var z:Number = radius * Math.sin(radian);
					var p:Pixel3D = new Pixel3D(hsv.value32, x, y, z);
					_pixels.addPixel3D(p);
					height *= 1.0005;
					radius *= 1.007;
				}
			}
		}
		protected override function onRenderTick(e:Event = null):void{
			_pixels.rotationY += 1;
			renderer.renderScene(scene, camera, viewport);
                           (camera.y > 1000)?direction *= -1:(camera.y < 0)?direction *= -1:0;
			camera.y += direction;
		}
		
	}
}