/**
 * Copyright raa ( http://wonderfl.net/user/raa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sQOr
 */

// forked from Albert's forked from: Platform engine
// forked from Albert's Platform engine
//http://www.emanueleferonato.com/2008/10/14/new-tile-based-platform-engine-as3-version-updated-to-step-10-plus-scrolling/

package { //
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
 
    //[SWF(width='500', height='400', frameRate='40', backgroundColor='0xffffff')]
    public class Platform extends Sprite
    {
        private var over:String = "";
        private var bonus_speed:Number = 0;
        private var press_left:Boolean = false;
        private var press_right:Boolean = false;
        private var press_up:Boolean = false;
        private var press_down:Boolean = false;
        private var press_space:Boolean = false;
        private var x_pos:Number = 0;
        private var y_pos:Number = 0;
        private var tile_size:Number = 20;
        private var ground_acceleration:Number = 1;
        private var ground_friction:Number = 0.8;
        private var air_acceleration:Number = 0.5;
        private var air_friction:Number = 0.7;
        private var ice_acceleration:Number = 0.15;
        private var ice_friction:Number = 0.95;
        private var treadmill_speed:Number = 2;
        private var max_speed:Number = 3;
        private var xspeed:Number = 0;
        private var yspeed:Number = 0;
        private var falling:Boolean = false;
        private var gravity:Number = 0.5;
        private var jump_speed:Number = 6;
        private var climbing:Boolean = false;
        private var climb_speed:Number = 0.8;
        private var coins:Array = new Array();
        private var level:Array = new Array();
        private var levelObj:Array = new Array
        private var keys:Array = new Array();
        private var player:Array = new Array();
        private var enemy:Array = new Array();
        private var walkable_tiles:Array = new Array(0, 5, 6, 7);
        private var h:hero = new hero();
        private var level_container:Sprite = new Sprite();
 
        private var bottom:Number;
        private var left:Number;
        private var right:Number;
        private var top:Number;
        private var bottom_left:Number;
        private var bottom_right:Number;
        private var top_left:Number;
        private var top_right:Number;
 
        private var climbdir:Number;
        private var current_tile:Number;
        private var friction:Number;
 
        private var speed:Number;
        private var jumping:Boolean;
        private var walking:Boolean;
        private var prev_bottom:Number;
        private var level_width:Number;
        private var level_height:Number;
 
        public function Platform()
        {
            inittrace(stage);
            trace("Start");       
            level[0] = [1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1];
            level[1] = [1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1];
            level[2] = [1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 6, 1, 0, 0, 0, 0, 1];
            level[3] = [1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 1];
            level[4] = [1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 1];
            level[5] = [1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 1];
            level[6] = [1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 6, 1, 0, 0, 0, 0, 0, 1];
            level[7] = [1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 1];
            level[8] = [1, 1, 1, 1, 0, 9, 0, 0, 0, 5, 5, 0, 0, 0, 7, 0, 0, 6, 0, 0, 0, 0, 7, 0, 1];
            level[9] = [1, 1, 1, 1, 1, 1, 1, 2, 2, 8, 8, 8, 8, 1, 1, 3, 3, 1, 4, 4, 1, 8, 1, 8, 1];
 
            player = [4,8];
 
            coins[0] = [2, 2];
            coins[1] = [23, 4];
            coins[2] = [5,2];
 
            enemy[0] = [10, 3, -1];
            enemy[1] = [3, 3, -2];
 
            keys[0] = [1, 5, 5, 8];
 
            create_level(level);
 
            addEventListener(Event.ENTER_FRAME,onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, key_down);
            stage.addEventListener(KeyboardEvent.KEY_UP, key_up);
        }
 
        public function key_down(event:KeyboardEvent):void
        {
            if (event.keyCode == 32)
            {
                press_space = true;
            }
 
            if (event.keyCode == 37)
            {
                press_left = true;
            }
 
            if (event.keyCode == 38)
            {
                press_up = true;
            }
 
            if (event.keyCode == 39)
            {
                press_right = true;
            }
 
            if (event.keyCode == 40)
            {
                press_down = true;
            }
        }
 
        public function key_up(event:KeyboardEvent):void
        {
            if (event.keyCode == 32)
            {
                press_space = false;
            }
 
            if (event.keyCode == 37)
            {
                press_left = false;
            }
 
            if (event.keyCode == 38)
            {
                press_up = false;
            }
 
            if (event.keyCode == 39)
            {
                press_right = false;
            }
 
            if (event.keyCode == 40)
            {
                press_down = false;
            }
        }
 
        public function create_level(l:Array):void
        {
            level_height = l.length;
            level_width = l[0].length;
 
            addChild(level_container);
 
            for (var j:Number = 0; j<level_height; j++)
            {
                levelObj[j] = new Array();
                for (var i:Number = 0; i<level_width; i++)
                {
                    if (l[j][i] != 0)
                    {
                        var t:tile = new tile();
                        t.setXY(
                            i*tile_size/* + Math.random()*5*/,
                            j*tile_size/* + Math.random()*5*/);
                        t.gotoAndStop(l[j][i]);
                        levelObj[j][i] = t;
                        level_container.addChild(levelObj[j][i]);
                    }
                }
            }
 
            place_player();
            level_container.addChild(h);
 
            for (var m:int = 0; m < coins.length; m++)
            {
                var c:coin = new coin();
                c.x = coins[m][0] * tile_size + tile_size / 2;
                c.y = coins[m][1] * tile_size + tile_size/2 + 1;
 
                coins[m] = c;
                level_container.addChild(coins[m]);
            }
 
            for (var n:int = 0; n < keys.length; n++)
            {
                var _k:key = new key();
                _k.x = keys[n][0] * tile_size + tile_size / 2;
                _k.y = keys[n][1] * tile_size + tile_size / 2 + 1;
                _k.openX = keys[n][2];
                _k.openY = keys[n][3];
                keys[n] = _k;
                level_container.addChild(keys[n]);
            }
 
            for (var k:int = 0; k < enemy.length; k++)
            {
                var foe:patrol = new patrol();
                foe.speed = enemy[k][2];
                foe.x = enemy[k][0] * tile_size + tile_size / 2;
                foe.y = enemy[k][1] * tile_size + tile_size / 2 + 1;
 
                enemy[k] = foe;
                level_container.addChild(enemy[k]);
            }
        }
 
        public function onEnterFrame(event:Event):void
        {
          for (var tx:int=0; tx<level_width; ++tx)
          { 
               for (var ty:int=0; ty<level_height; ++ty)
               if (level[ty][tx] != 0){
                  var t:tile = levelObj[ty][tx];
                  //trace(t);
                  //trace(22);
                  if (t)
                      t.update();
                  
                }
        
           }
           h.update();
           //trace(1);
            ground_under_feet();
 
            walking = false;
            climbing = false;
            if (press_left) {
                xspeed-=speed;
                walking = true;
            }
            if (press_right) {
                xspeed += speed;
                walking = true;
            }
            if (press_up) {
                get_edges();
                if (top_right == 6 || bottom_right == 6 || top_left == 6 || bottom_left == 6) {
                    jumping = false;
                    falling = false;
                    climbing = true;
                    climbdir = -1;
                }
            }
            if (press_down) {
                get_edges();
                if (over == "ladder" || top_right == 6 || bottom_right == 6 || top_left == 6 || bottom_left == 6) {
                    jumping = false;
                    falling = false;
                    climbing = true;
                    climbdir = 1;
                }
            }
            if (press_space) {
                get_edges();
                if (!falling && !jumping) {
                    jumping = true;
                    yspeed = -jump_speed;
                }
            }
            if (!walking) {
                xspeed *= friction;
                if (Math.abs(xspeed)<0.5) {
                    xspeed = 0;
                }
            }
            if (xspeed>max_speed) {
                xspeed = max_speed;
            }
            if (xspeed<max_speed*-1) {
                xspeed = max_speed*-1;
            }
            if (falling || jumping) {
                yspeed += gravity;
            }
            if (climbing) {
                yspeed = climb_speed*climbdir;
            }
            if (!falling && !jumping && !climbing) {
                yspeed = 0;
            }
            xspeed += bonus_speed;
            check_collisions();
            h.setXY(x_pos, y_pos);
 
            level_container.x = -x_pos + 250;
            level_container.y = -y_pos + 200;
 
            xspeed -= bonus_speed;
            for (var i:int = 0; i < enemy.length; i++)
            {
                if (enemy[i].hitTestObject(h))
               { 
                    trace("Enemy killed the HERO!");
                    place_player();
                }
                enemy[i].x_pos = enemy[i].x;
                enemy[i].y_pos = enemy[i].y;
 
                enemy[i].x_pos += enemy[i].speed;
 
                enemy[i].left_foot_x = Math.floor((enemy[i].x_pos-6)/tile_size);
                enemy[i].right_foot_x = Math.floor((enemy[i].x_pos+5)/tile_size);
                enemy[i].foot_y = Math.floor((enemy[i].y_pos+9)/tile_size);
                enemy[i].bottom = Math.floor((enemy[i].y_pos+8)/tile_size);
                enemy[i].left_foot = level[enemy[i].foot_y][enemy[i].left_foot_x];
                enemy[i].right_foot = level[enemy[i].foot_y][enemy[i].right_foot_x];
                enemy[i].left = level[enemy[i].bottom][enemy[i].left_foot_x];
                enemy[i].right = level[enemy[i].bottom][enemy[i].right_foot_x];
                 //trace("enemy 2");
                if (enemy[i].left_foot != 0 && enemy[i].right_foot != 0 && enemy[i].left == 0 && enemy[i].right == 0)
                {
                    enemy[i].x = enemy[i].x_pos;
                }
                else {
                    enemy[i].speed *= -1;
                }
                //trace("enemy end");
            }
            for (var j:int = 0; j < coins.length; j++)
            {
                if(coins[j].hitTestObject(h))
                {
                    trace("coin collected");
                    level_container.removeChild(coins[j]);
                }
            }
 
            for (var k:int = 0; k < keys.length; k++)
            {
                //trace(1);
                if(keys[k].hitTestObject(h))
                {
                    trace("Key collected!");
                    level[keys[k].openY][keys[k].openX] = 0;
 
                    level_container.removeChild(levelObj[keys[k].openY][keys[k].openX]);
                    level_container.removeChild(keys[k]);
                }
            }
        }
 
        public function ground_under_feet():void
        {
            bonus_speed = 0;
            var left_foot_x:Number = Math.floor((x_pos-6)/tile_size);
            var right_foot_x:Number = Math.floor((x_pos+5)/tile_size);
            var foot_y:Number = Math.floor((y_pos+9)/tile_size);
            var left_foot:Number = level[foot_y][left_foot_x];
            var right_foot:Number = level[foot_y][right_foot_x];
            if (left_foot != 0) {
                current_tile = left_foot;
            } else {
                current_tile = right_foot;
            }
            switch (current_tile) {
                case 0 :
                    speed = air_acceleration;
                    friction = air_friction;
                    falling = true;
                    break;
                case 1 :
                    over = "ground";
                    speed = ground_acceleration;
                    friction = ground_friction;
                    break;
                case 2 :
                    over = "ice";
                    speed = ice_acceleration;
                    friction = ice_friction;
                    break;
                case 3 :
                    over = "treadmill";
                    speed = ground_acceleration;
                    friction = ground_friction;
                    bonus_speed = -treadmill_speed;
                    break;
                case 4 :
                    over = "treadmill";
                    speed = ground_acceleration;
                    friction = ground_friction;
                    bonus_speed = treadmill_speed;
                    break;
                case 5 :
                    over = "cloud";
                    speed = ground_acceleration;
                    friction = ground_friction;
                    break;
                case 6 :
                    over = "ladder";
                    speed = ground_acceleration;
                    friction = ground_friction;
                    break;
 
                case 7 :
                    over = "trampoline";
                    speed = ground_acceleration;
                    friction = ground_friction;
                    break;
                case 8 :
                    over = "spikes";
                    if (left_foot == 8 && right_foot == 8)
                    {
                        trace("spikes!");
                        place_player();
                    }
            }
        }
 
        public function check_collisions():void
        {
            y_pos += yspeed;
            get_edges();
            var bottomy:Number = bottom*tile_size-9;
            var bl:tile = levelObj[bottom][left];
            var br:tile = levelObj[bottom][right];
            var tl:tile = levelObj[top][left];            
            var tr:tile = levelObj[top][right];
                
            if (yspeed>0) {
                if ((bottom_right != 0 && bottom_right != 6) || (bottom_left != 0 && bottom_left != 6)) {
                    if (bottom_right != 5 && bottom_left != 5) {
                        if ((bottom_right == 7 || bottom_left == 7) && (Math.abs(yspeed)>1))
                        {
                            // trampoline
                            if (bl) bl.setoffs(0,yspeed);
                            if (br) br.setoffs(0,yspeed);
                            h.setoffs(0,yspeed);
                            yspeed *= -1;
                            jumping = true;
                            falling = true;
                        }else {
                            if (bl) bl.setoffs(0,yspeed);
                            if (br) br.setoffs(0,yspeed);
                            h.setoffs(0, yspeed);
                            y_pos = bottomy; //bottom*tile_size-9;
                            yspeed = 0;
                            falling = false;
                            jumping = false;
                        }
                    } else {
                        if (prev_bottom<bottom) {
                            if (bl) bl.setoffs(0,yspeed);
                            if (br) br.setoffs(0,yspeed);
                            h.setoffs(0,yspeed);
                            y_pos = bottomy; //bottom*tile_size-9;
                            yspeed = 0;
                            falling = false;
                            jumping = false;
                        }
                    }
                }
            }
 
            if (yspeed<0) {
                if ((top_right != 0 && top_right != 5 && top_right != 6) || (top_left != 0 && top_left != 5 && top_left != 6)) {
                    if (tl) tl.setoffs(0,yspeed);
                    if (tr) tr.setoffs(0,yspeed);
                    h.setoffs(0,yspeed);
                    y_pos = bottom*tile_size+1+8;
                    yspeed = 0;
                    falling = false;
                    jumping = false;
                }
            }
            x_pos += xspeed;
            get_edges();
 
            if (xspeed < 0) {
                if (!is_walkable(top_left) || !is_walkable(bottom_left)) {
                    x_pos = (left + 1) * tile_size + 6;
                    xspeed = 0;
                }
            }
 
            if (xspeed>0) {
                if (!is_walkable(top_right) || !is_walkable(bottom_right)) {
                    x_pos = right * tile_size - 6;
                    xspeed = 0;
                }
            }
 
            prev_bottom = bottom;
        }
 
        public function get_edges():void
        {
            right = Math.floor((x_pos+5)/tile_size);
            left = Math.floor((x_pos-6)/tile_size);
            bottom = Math.floor((y_pos+8)/tile_size);
            top = Math.floor((y_pos-9)/tile_size);
 
            top_right = level[top][right];
            top_left = level[top][left];
            bottom_left = level[bottom][left];
            bottom_right = level[bottom][right];
        }
 
        public function place_player():void
        {
            x_pos = (player[0] * tile_size) + (tile_size / 2);
            y_pos = (player[1] * tile_size) + (tile_size / 2 + 1);
 
            h.setXY(x_pos, y_pos);
        }
 
        public function is_walkable(tile:int):Boolean {
            var walkable:Boolean = false;
            for (var i:int = 0; i < walkable_tiles.length; i++)
            {
                if (tile == walkable_tiles[i])
                {
                    walkable = true;
                    break;
                }
            }
            return (walkable);
        }
    }
}
import flash.display.AVM1Movie;



import flash.display.Sprite;
import flash.display.MovieClip;
class Config{
    public static const tilewidth:int = 20;
    public static const tileheight:int = 20;
}

class tileobj extends MovieClip
{
    public var _x:Number;
    public var _y:Number;
    public var toffsx:Number;
    public var toffsy:Number;
    public var sleep:Boolean;
    
    public function tileobj()
   {
       super();
       toffsx = 0;
       toffsy = 0;
   }
 
    
    public function setoffs(offsetX:Number, offsetY:Number):void
   {
       sleep = false;
       toffsx = offsetX;
       toffsy = offsetY;
       updateXY();
   }
   
   public function updateXY():void
  {
      super.x = _x+toffsx; 
      super.y = _y+toffsy;
     //trace(toffsx);
  }
  
    public function setXY(gx:Number, gy:Number):void
    {
        //trace(gx,gy);
        _x = gx;
        _y = gy;
        //trace(_x, _y);
        updateXY();
    }
 public function update():void
{
    if (sleep)
        return;
    toffsx *= 0.8;
    toffsy *= 0.8;
    updateXY();
    if (Math.abs(toffsx)<0.1 && Math.abs(toffsy)<0.1)
        sleep = true;
}
 
    override public function get x():Number
   {
       return _x;
   }
   override public function get y():Number
  { 
     return _y;
  }

}

class hero extends tileobj
{
       public function hero()
      {
          super()
          graphics.beginFill(0xff0000);
          graphics.drawRect(-Config.tilewidth/3,-Config.tileheight/10*4,Config.tilewidth/3*2,Config.tileheight/10*9);
          graphics.endFill(); 
      }
}

class tile extends tileobj
{
       public function tile()
      {
          super()
          graphics.beginFill(0x888888);
          graphics.drawRect(0,0,Config.tilewidth,Config.tileheight);
          graphics.endFill(); 
      }
      
      override public function gotoAndStop(frame:Object, scene:String = null):void
     {
           var color:int = 0x555555;
          switch (frame)
          { 
                case 0 :
                    //air
                    break;
                case 1 :
                    // "ground";
                    break;
                case 2 :
                    //"ice";
                    color = 0x88aaff;
                    break;
                case 3 :
                    //"treadmill";
                    color = 0xff66ff;
                    break;
                case 4 :
                    //"treadmill";
                    color = 0xff88ff;
                    break;
                case 5 :
                    // "cloud";
                    color = 0xbbbbbb;
                    break;
                case 6 :
                    // "ladder";
                   color = 0xaaFFaa;
                    break;
 
                case 7 :
                    //"trampoline";
                    color = 0x55ff55;
                    break;
                case 8 :
                    //"spikes";
                    color = 0xff0000;
                    break;
            }
          graphics.beginFill(color);                   
            graphics.drawRect(0,0,Config.tilewidth,Config.tileheight);
          graphics.endFill();          
     }
 
}

class coin extends MovieClip
{
       public function coin()
      {
          super()
          graphics.beginFill(0xcccc00);
          graphics.drawCircle(0, 0, Config.tileheight/3);
          //graphics.drawRect(-Config.tilewidth/2,-Config.tileheight/2,Config.tilewidth,Config.tileheight);
          graphics.endFill(); 
      }
}

class key extends MovieClip
{
    public var openX:int;
    public var openY:int;
       public function key()
      {
          super()
          graphics.beginFill(0xaa00aa);
          graphics.drawCircle(0, -Config.tileheight/4, Config.tileheight/4);          
          graphics.drawRect(-Config.tilewidth/10,-Config.tileheight/4,Config.tilewidth/10*2,Config.tileheight/4*3);
          graphics.drawRect(Config.tilewidth/10, Config.tileheight/15*5, Config.tilewidth/3, Config.tileheight/10);
          graphics.drawRect(Config.tileheight/10, Config.tileheight/15*3, Config.tilewidth/4, Config.tileheight/10);
         
          graphics.endFill(); 
      }
}

class patrol extends MovieClip
{
    public var speed:int;
    public var x_pos:Number;
    public var y_pos:Number;
    public var left_foot_x:Number;
    public var right_foot_x:Number;
    public var foot_y:Number;
    public var bottom:Number;
    public var left_foot:Number;
    public var right_foot:Number;
    public var left:Number;
    public var right:Number;


       public function patrol()
      {
          super()
          speed = 5;
          graphics.beginFill(0x0000aa);
          graphics.drawRect(-Config.tilewidth/3,-Config.tileheight/2,Config.tilewidth/3*2,Config.tileheight);
          graphics.endFill(); 
      }
}

/////  WONDERFL TRACE /////

import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;


function inittrace(s:Stage):void
{
    WTrace.initTrace(s);
}

//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            trace_stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
}