/**
 * Copyright hacker_zxh9vkwz ( http://wonderfl.net/user/hacker_zxh9vkwz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sQ6w
 */

// forked from ProjectNya's LightBlink + SoundMixer
////////////////////////////////////////////////////////////////////////////////
// LightBlink + SoundMixer
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    import flash.net.URLRequest;

    [SWF(backgroundColor="#990000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private static var cols:uint = 16;
        private static var rows:uint = 16;
        private var lights:Array;
        private var sound:Sound;
        private var channel:SoundChannel;
        private static var soundPath:String = "http://www.takasumi-nagai.com/soundfiles/sound001.mp3";
        private var byteArray:ByteArray;
        private static var channels:uint = 256;
        private var factors:uint = 0;

        public function Main() {
            Wonderfl.capture_delay(10);
            init();
        }

        private function init():void {
            graphics.beginFill(0x006600);
            graphics.drawRect(0, 0, 465, 45);
            graphics.endFill();
            graphics.beginFill(0xCC9900);
            graphics.drawRect(0, 45, 465, 5);
            graphics.endFill();
            graphics.beginFill(0x990000);
            graphics.drawRect(0, 50, 465, 365);
            graphics.endFill();
            graphics.beginFill(0xCC9900);
            graphics.drawRect(0, 415, 465, 5);
            graphics.endFill();
            graphics.beginFill(0x006600);
            graphics.drawRect(0, 420, 465, 45);
            graphics.endFill();
            lights = new Array();
            for (var c:uint = 0; c < 2; c++) {
                lights[c] = new Array();
                for (var n:uint = 0; n < cols*rows; n++) {
                    var light:Light = new Light();
                    if (c == 0) {
                        light.x = 225 - 14*(n%cols);
                    } else {
                        light.x = 243 + 14*(n%cols);
                    }
                    light.y = 403 - 340/(rows - 1)*uint(n/cols);
                    addChild(light);
                    light.blink(0);
                    lights[c].push(light);
                }
            }
            //
            sound = new Sound();
            sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
            sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
            byteArray = new ByteArray();
        }
        private function complete(evt:Event):void {
            evt.target.removeEventListener(Event.COMPLETE, complete);
            start();
        }
        private function start():void {
            channel = sound.play(0, 1000);
            addEventListener(Event.ENTER_FRAME, update, false, 0, true);
        }
        private function update(evt:Event):void {
            SoundMixer.computeSpectrum(byteArray, true, factors);
            for (var c:uint = 0; c < 2; c++) {
                for (var n:uint = 0; n < channels; n++) {
                    var light:Light = lights[c][n];
                    var p:Number = byteArray.readFloat();
                    light.blink(p*10);
                }
            }
        }

    }

}


import flash.display.Sprite;
import flash.display.Shape;
import flash.events.Event;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.geom.ColorTransform;

class Light extends Sprite {
    private var base:Sprite;
    private static var center:Number = 4;
    private static var radius:Number = 10;
    private static var color:uint = 0xFFFFFF;
    private var amplitude:Number = 0;
    private var speed:Number;
    private static var radian:Number = Math.PI/180;
    private static var color1:uint = 0xFFFFFF;
    private static var color2:uint = 0xFF99CC;
    private var colorTrans:ColorTransform;

    public function Light() {
        base = new Sprite();
        addChild(base);
        draw();
        colorTrans = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
    }

    // メソッド
    public function blink(p:Number):void {
        setRGB(p);
        base.transform.colorTransform = colorTrans;
    }
    private function setRGB(percent:Number):void {
        var r1:int = (color1 >> 16 & 0xFF);
        var g1:int = (color1 >> 8 & 0xFF);
        var b1:int = (color1 & 0xFF);
        var r2:int = (color2 >> 16 & 0xFF);
        var g2:int = (color2 >> 8 & 0xFF);
        var b2:int = (color2 & 0xFF);
        //colorTrans.alphaMultiplier = 0.75 + 0.5*percent;
        colorTrans.alphaMultiplier = 0.1 + 0.9*percent;
        colorTrans.redOffset = (r1 + r2)*0.5 + (r2 - r1)*0.5*percent;
        colorTrans.greenOffset = (g1 + g2)*0.5 + (g2 - g1)*0.5*percent;
        colorTrans.blueOffset = (b1 + b2)*0.5 + (b2 - b1)*0.5*percent;
    }
    private function draw():void {
        base.graphics.beginFill(color);
        base.graphics.drawCircle(0, 0, center);
        base.graphics.endFill();
        var colors:Array = [color, color];
        var alphas:Array = [0.6, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(radius*2, radius*2, 0, -radius, -radius);
        base.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix);
        base.graphics.drawCircle(0, 0, radius);
        base.graphics.endFill();
    }

}
