/**
 * Copyright krogue ( http://wonderfl.net/user/krogue )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sPy5
 */

/**
 * Cross
 *
 * マウスカーソルにしたがって、ぐるぐる回る十字。
 * 大きさと方向と色とが滑らかに変わる。
 * 
 * @author krogue
 */
package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width="465", height="465", backgroundColor="0", frameRate="60")]
    public class Main extends Sprite {
        private var cross:Cross;
        
        public function Main() {
            addEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
        }
        
        private function onAddedToStage(event:Event):void {
            removeEventListener(Event.ADDED_TO_STAGE, onAddedToStage);
            initialize();
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(event:Event):void {
            update();
        }
        
        private function initialize():void {
            cross = addChild(new Cross()) as Cross;
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        }
        
        private function update():void {
            // do nothing
        }
        
        private function onMouseMove(event:MouseEvent):void {
            cross.update(event.stageX, event.stageY);
        }
    }
}

import flash.display.Sprite;
import flash.display.Shape;
import flash.display.Graphics;
import flash.geom.Point;
import mx.flash.UIMovieClip;

class Cross extends Sprite {
    private const centerPoint:Point = new Point(465 / 2, 465 / 2);
    private const crossOut:Shape = addChild(new Shape()) as Shape;
    private const crossIn:Shape = addChild(new Shape()) as Shape;
    
    public function Cross() {
        crossOut.x = centerPoint.x;
        crossOut.y = centerPoint.y;
        crossIn.x = centerPoint.x;
        crossIn.y = centerPoint.y;
        drawCross(crossOut.graphics, crossIn.graphics, 0xFF000000);
    }
    
    private function drawCross(go:Graphics, gi:Graphics, co:uint):void {
        const ci:uint = 0x99FFFFFF;
        const ri:Point = new Point(-10, -10);
        const ro:Point = new Point(-30, -30);
        // 点を描画する順番
        //     2  3
        // 12  1  4  5
        // 11 10  7  6
        //     9  8
        go.clear();
        go.lineStyle(5, co & 0xFFFFFF, (co >>> 24) / 0xFF, true);
        go.moveTo(+ri.x, +ri.y);
        go.lineTo(+ri.x, +ro.y);
        go.lineTo(-ri.x, +ro.y);
        go.lineTo(-ri.x, +ri.y);
        go.lineTo(-ro.x, +ri.y);
        go.lineTo(-ro.x, -ri.y);
        go.lineTo(-ri.x, -ri.y);
        go.lineTo(-ri.x, -ro.y);
        go.lineTo(+ri.x, -ro.y);
        go.lineTo(+ri.x, -ri.y);
        go.lineTo(+ro.x, -ri.y);
        go.lineTo(+ro.x, +ri.y);
        go.lineTo(+ri.x, +ri.y);
        
        // 十字線
        gi.clear();
        gi.lineStyle(0, ci & 0xFFFFFF, (ci >>> 24) / 0xFF, true);
        gi.moveTo(+ri.x, 0);
        gi.lineTo(-ri.x, 0);
        gi.moveTo(0, +ri.x);
        gi.lineTo(0, -ri.x);
    }
    
    public function update(x:Number, y:Number):void {
        const minDistance:Number = 20;
        const mpt:Point = new Point(x, y);
        const distance:Number = Point.distance(centerPoint, mpt);
        const offset:Point = mpt.subtract(centerPoint);
        const radians:Number = Math.atan2(offset.y, offset.x);
        const degrees:Number = radians * 180 / Math.PI;
        
        if (distance >= minDistance) {
            var scale:Number = Math.sqrt(distance - minDistance);
            scale = Math.max(scale, 1.0);
            crossOut.scaleY = scale;
            crossOut.scaleX = scale;
        }
        crossOut.rotation = degrees;
        crossIn.rotation = degrees;
        const h:uint = Math.floor(crossOut.rotation + 180 + 270) % 360;
        drawCross(crossOut.graphics, crossIn.graphics, h2rgb(h));
    }
    
    // HSV -> RGB ( S=1, V=255 )
    // H= 0..360
    private function h2rgb(h:Number):uint {
        var color:uint = 0xFF000000;
        const v:uint = 0xFF; // 255
        const hi:Number = Math.floor(h / 60);
        const f:Number = v * (h / 60 - hi);
        switch (hi) {
        case 0:
            color |= ((v << 16) | (f << 8));
            break;
        case 1:
            color |= (((v - f) << 16) | (v << 8));
            break;
        case 2:
            color |= ((v << 8) | f);
            break;
        case 3:
            color |= (((v - f) << 8) | v);
            break;
        case 4:
            color |= ((f << 16) | v);
            break;
        case 5:
            color |= ((v << 16) | (v - f));
            break;
        }
        return color;
    }
}