/**
 * Copyright whaison ( http://wonderfl.net/user/whaison )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sPnr
 */

// forked from 9re's Wonderfl Tank Game BulletRenderer Sample 1
// このコードを新着弾一覧http://flash-games.wonderfl.net/tank/list/bullets
// に表示させるためにはinfinite-tank-bullet
// というタグを追加してください
package
{
	// ai0
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.system.Security;
	//
	// net.wonderfl
	import net.wonderfl.game.infinity_tank.development.*;
	/**
	 * @author 9re
	 */
	[SWF(backgroundColor="#000000")]
	// クラス名は必ずBulletRendererにして、BulletRendererBaseを拡張して下さい
	// http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/bullet/BulletRendererBase.html
	public class BulletRenderer extends BulletRendererBase
	{
		private var _ctfm:ColorTransform;
		private var _bullet:BitmapData;
		private var _point:Point;
		private var _color:HSBColor;
		private var _hue:int;
		
		public function BulletRenderer() {
			_ctfm = new ColorTransform(1, 1, 1, 1 - 1/16);
			_bullet = new BitmapData(6, 6);
			_bullet.fillRect(new Rectangle(0, 0, 6, 6), 0x7fff0000);
			_point = new Point();
			_color = new HSBColor(0, 1, 1);
		}

		// このメソッドは毎フレーム呼ばれます。
		// _sceneプロパティーについては、詳しくは
		// http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/model/BattleScene.html
		// をご覧下さい
		override public function draw($bitmapData:BitmapData):void {
			$bitmapData.lock();
			_color.hue = _hue;
			_hue += 3;
			_hue %= 60;
			_hue = (_hue > 30) ? 60 - _hue : _hue;
			_bullet.fillRect(new Rectangle(0, 0, 6, 6), 0x7f000000 | HSBColor.convertHSBtoRGB(_color.hue, 1, 1));
			// 弾道の尾を引かせるために前の像をアルファで少し残す
			$bitmapData.colorTransform($bitmapData.rect, _ctfm);
			// myBulletListが自分の弾のリスト。このようにfor文で回す
 			for (var i:BoundBox = _scene.myBulletList; i; i = i.next) {
				// i.positionに弾の座標が入ります。中心座標なので、左へ2、上へ3だけずらします
				_point.x = i.position.x - 2;
				_point.y = i.position.y - 3;
				// bitmapdataに弾のビットマップを座標の所へコピーする
				$bitmapData.copyPixels(_bullet, _bullet.rect, _point);
			}
			$bitmapData.unlock();
		}
		
	}


}

class HSBColor
{
    /**
     * Constructs an HSVColor with optional parameters
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function HSBColor(hue:Number = NaN, saturation:Number = NaN, 
        brightness:Number = NaN)
    {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
    }
    
    private var _hue:Number;
    /**
     * The hue value for the HSV color. This represents an angle, in 
     * degrees, around the HSV cone. The supplied value will be modulated
     * by 360 so that the stored value of hue will be in the range [0,360).
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function get hue():Number
    {
        return _hue;
    }
    public function set hue(value:Number):void
    {
        _hue = value % 360;
        _hue += 360;
        _hue %= 360;
    }
    
    private var _saturation:Number;
    /**
     * The saturation parameter for this HSV color. This is a value between
     * 0 (black) and 1 (full saturation), which represents the distance
     * from the center in the HSV cone.
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function get saturation():Number
    {
        return _saturation;
    }
    public function set saturation(value:Number):void
    {
        _saturation = value;
    }
    
    private var _brightness:Number;
    /**
     * The brightness parameter for this HSB color. This is a value between
     * 0 (black) and 1 (full brightness), which represents the distance
     * from the apex of the HSB cone.
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function get brightness():Number
    {
        return _brightness;
    }
    public function set brightness(value:Number):void
    {
        _brightness = value;
    }
    
    /**
     * Converts an HSB color specified by the parameters to a
     * uint RGB color.
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public static function convertHSBtoRGB(hue:Number, saturation:Number, 
        brightness:Number):uint
    {
        // Conversion taken from Foley, van Dam, et al
        var r:Number, g:Number, b:Number;
        if (saturation == 0)
        {
            r = g = b = brightness;
        }
        else
        {
            var h:Number = (hue % 360) / 60;
            var i:int = int(h);
            var f:Number = h - i;
            var p:Number = brightness * (1 - saturation);
            var q:Number = brightness * (1 - (saturation * f));
            var t:Number = brightness * (1 - (saturation * (1 - f)));
            switch (i) {
                case 0:
                    r = brightness;
                    g = t;
                    b = p;
                    break; 
                case 1:
                    r = q;                    
                    g = brightness;
                    b = p;
                    break; 
                case 2:
                    r = p;
                    g = brightness;
                    b = t; 
                    break;
                case 3:
                    r = p;
                    g = q;
                    b = brightness;
                    break; 
                case 4:
                    r = t;
                    g = p;
                    b = brightness; 
                    break;
                case 5: 
                    r = brightness;
                    g = p;
                    b = q;
                    break;
            }
        }
        r *= 255;
        g *= 255;
        b *= 255;
        return (r << 16 | g << 8 | b);
    }
    
    /**
     * Converts a color from RGB format into an HSBColor
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    static public function convertRGBtoHSB(rgb:uint):HSBColor
    {
        // Conversion taken from Foley, van Dam, et al
        var hue:Number, saturation:Number, brightness:Number;
        var r:Number = ((rgb >> 16) & 0xff) / 255;
        var g:Number = ((rgb >> 8) & 0xff) / 255;
        var b:Number = (rgb & 0xff) / 255;
        var max:Number = Math.max(r, Math.max(g, b));
        var min:Number = Math.min(r, Math.min(g, b));
        var delta:Number = max - min;
        brightness = max;
        if (max != 0)
            saturation = delta / max;
        else
            saturation = 0;
        if (saturation == 0)
            hue = NaN;
        else
        {
            if (r == max)
                hue = (g - b) / delta;
            else if (g == max)
                hue = 2 + (b - r) / delta
            else if (b == max)
                hue = 4 + (r - g) / delta;
            hue = hue * 60;
            if (hue < 0)
                hue += 360;
        }
        return new HSBColor(hue, saturation, brightness);
    }
}