/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sPXC
 */

package
{
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.TriangleCulling;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Point;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    
    import net.hires.debug.Stats;
    
    public class Triangles_test2 extends Sprite
    {
        private var len:int = 3;
        
        private var vertices:Vector.<Number>;
        private var indices:Vector.<int>;
        private var uvt:Vector.<Number>;
        
        private var pv:Vector.<Number>;
        private var sortedIndices:Vector.<int>;
        
        private var faces:Array;
        
        private var bd:BitmapData;
        private var g:Graphics;
        
        private var rot:Number = 0;
        private var proj:Matrix3D;
        
        public function Triangles_test2()
        {
            super();
            vertices = new <Number>[];
            indices = new <int>[];
            uvt = new <Number>[];
            pv = new <Number>[];
            faces = [];
            
            create1();
            
            sortedIndices = new Vector.<int>(indices.length, true);
            var pp:PerspectiveProjection = new PerspectiveProjection();
            pp.fieldOfView = 40;
            proj = pp.toMatrix3D();
            
            bd = new BitmapData(256,256);
            for(var b:int = 0; b<=256; b++)
            {
                for(var g:int = 0; g<=256; g++)
                {
                    bd.setPixel( g,b, (0x00 | (g<<8) | b) );
                }
            }
            
            this.g = (addChild( new Shape() ) as Shape).graphics ;
            
            addChild( new Stats() )
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMove );
        }
        private function create2():void
        {
            
        }
        private function create1():void
        {
            var s:int = 100;
            for(var i:int = 0; i<1000; i++)
            {
                var n:int = i*9;
                var o:Number = 465 > 1;
                vertices[n] = s * Math.random();
                vertices[n+1] = s * Math.random();
                vertices[n+2] = s * Math.random();
                vertices[n+3] = s * Math.random();
                vertices[n+4] = s * Math.random();
                vertices[n+5] = s * Math.random();
                vertices[n+6] = s * Math.random();
                vertices[n+7] = s * Math.random();
                vertices[n+8] = s * Math.random();
                
                uvt[n] = 0.5;
                uvt[n+1] = 1;
                uvt[n+2] = 0;
                
                uvt[n+3] = 1;
                uvt[n+4] = 0;
                uvt[n+5] = 0;
                
                uvt[n+6] = 0;
                uvt[n+7] = 1;
                uvt[n+8] = 0.5;
                
                n = i * 3;
                
                indices[n] = n;
                indices[n+1] = n+1;
                indices[n+2] = n+2;
                
                faces[i] = new Face();
            }
        }
        
        private function onMove(e:MouseEvent):void
        {
            e.updateAfterEvent();
            
            var m:Matrix3D = new Matrix3D();
            //m.appendRotation( rot, Vector3D.Y_AXIS);
            
            m.appendRotation(mouseY * 2, Vector3D.X_AXIS);
            m.appendRotation(mouseX * 2, Vector3D.Y_AXIS);
            m.appendTranslation(250,200,600);
            // 重要
            m.append( proj );
            
            pv.length = 0;
            Utils3D.projectVectors(m,vertices,pv,uvt);
            
            // z-sort
            var face:Face;
            var inc:int = 0;
            var len:int = indices.length;
            for (var i:int = 0; i<len; i+=3)
            {
                face = faces[inc] as Face;
                face.x = indices[i];
                face.y = indices[int(i + 1)];
                face.z = indices[int(i + 2)];
                var i3:int = i*3;
                face.w = uvt[int(i3 + 2)] + uvt[int(i3 + 5)] + uvt[int(i3 + 8)];
                inc++;
            }
            inc = 0;
            faces.sortOn("w", Array.NUMERIC);
            for each (face in faces){
                sortedIndices[inc++] = face.x;
                sortedIndices[inc++] = face.y;
                sortedIndices[inc++] = face.z;
            }
            
            //
            g.clear();
            g.beginBitmapFill( bd);
            g.drawTriangles( pv, sortedIndices, uvt, TriangleCulling.NEGATIVE);
            g.endFill();
            
            rot++;
        }
    }
}
class Face
{
    public var w:Number = 0;
    public var x:Number = 0;
    public var y:Number = 0;
    public var z:Number = 0;
}