/**
 * Copyright atsumo ( http://wonderfl.net/user/atsumo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sPT6
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Back;
	import org.libspark.betweenas3.tweens.ITween;
	
	
	public class Sample extends Sprite {
    
    	private var _ball:Ball;
    	private var _tw:ITween;
    	
    	private var INTERVAL:int = 40;
    	private var _count:int;
    	
    	public function Sample(){
    		_ball = new Ball();
    		addChild(_ball);
    						
    		addEventListener(Event.ENTER_FRAME , onEnterFrame);
    		//addEventListener(MouseEvent.CLICK , onClick);
    	}
    	
    	private function onClick(e:Event):void
    	{
    		_tw = BetweenAS3.tween(_ball,{x:Math.random()*stage.stageWidth,y:Math.random()*stage.stageHeight});
    		_tw.play();
    		trace("こうなったのか")
    	}
    	
    	private function onEnterFrame(e:Event):void
    	{
    		
    		
    		if(_count % INTERVAL == 0)
    		{
    			_tw = BetweenAS3.tween(_ball,{x:Math.random()*stage.stageWidth,y:Math.random()*stage.stageHeight,color:Math.random()*0xFFFFFF},null,Math.random()*2,Back.easeInOut);
    			_tw.play();
    		}
    			
    		_count++;
    		
    	}
    }
}

import flash.display.Sprite;

class Ball extends Sprite
{
	private var _color:uint;
	private var _radius:Number;
	
	public function Ball(color:uint = 0x000000, radius:Number = 30)
	{
		_color = color;
		_radius = radius;
		
		update();
	}
	
	private function update():void
	{
		graphics.clear();
		graphics.beginFill(_color);
		graphics.drawCircle(0,0,_radius);
		graphics.endFill();
	}
	
	public function set color(color:uint):void
	{
		_color = color;
		update();
	}
	
	public function get color():uint
	{
		return _color;
	}
	
	public function set radius(radius:Number):void
	{
		_radius = radius;
		update();
	}
	
	public function get radius():Number
	{
		return _radius;
	}

}