/**
 * Copyright partlyhuman ( http://wonderfl.net/user/partlyhuman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sO1h
 */

package {
    import flash.display.*;
import flash.events.*;
import flash.geom.*;

[SWF(backgroundColor="#000000")]        
    public class FlashTest extends Sprite {
        
                    protected var cursor_50:Shape;
        protected var cursor_100:Shape;
        protected var canvas:Graphics;
        
        protected var pp:PerspectiveProjection;
        protected var mPerspective:Matrix3D;
        protected var mPerspectiveInverted:Matrix3D;
        
        public function FlashTest() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            pp = new PerspectiveProjection();
            pp.projectionCenter = new Point(stage.stageWidth/2, stage.stageHeight/2);
            pp.fieldOfView = 25;
            root.transform.perspectiveProjection = pp;
            
            mPerspective = pp.toMatrix3D();
            mPerspectiveInverted = mPerspective.clone();
            mPerspectiveInverted.invert();
            
            
            var sprite:Sprite = new Sprite();
            stage.addChild(sprite);
            canvas = sprite.graphics;
            
            cursor_50 = new Shape();
            cursor_50.graphics.beginFill(0, 0.5);
            cursor_50.graphics.drawCircle(0,0,10);
            cursor_50.z = 50;
            
            cursor_100 = new Shape();
            cursor_100.graphics.copyFrom(cursor_50.graphics);
            cursor_100.z = 100;
            
            stage.addChild(cursor_100);
            stage.addChild(cursor_50);
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        protected function onEnterFrame(event:Event):void
        {
            canvas.clear();
            cursor_100.x = cursor_50.x = stage.mouseX;
            cursor_100.y = cursor_50.y = stage.mouseY;
            
            var v:Vector3D = new Vector3D(stage.mouseX, stage.mouseY, 0);
            var v_:Vector3D; //post-projection
            
            
            canvas.lineStyle(2, 0xff0000, 1);
            v.z = 50;
            v_ = Utils3D.projectVector(mPerspective, v);
            canvas.drawRect(v_.x, v_.y, 10, 10);
            v.z = 100;
            v_ = Utils3D.projectVector(mPerspective, v);
            canvas.drawRect(v_.x, v_.y, 10, 10);
            
            canvas.lineStyle(2, 0x00ff00, 1);
            v.z = 50;
            v_ = Utils3D.projectVector(mPerspectiveInverted, v);
            canvas.drawRect(v_.x, v_.y, 10, 10);
            v.z = 100;
            v_ = Utils3D.projectVector(mPerspectiveInverted, v);
            canvas.drawRect(v_.x, v_.y, 10, 10);
        }
    }
}