/**
 * Copyright flabaka ( http://wonderfl.net/user/flabaka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sMWI
 */

package {
    
    import away3dlite.cameras.Camera3D;
    import away3dlite.containers.ObjectContainer3D;
    import away3dlite.containers.Scene3D;
    import away3dlite.containers.View3D;
    import away3dlite.core.render.BasicRenderer;
    import away3dlite.primitives.Cube6;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import net.hires.debug.Stats;
    
    [swf(width = "465", height = "465", backgroundColor = "0xffffff", frameRate = "30")]
    
    public class Main extends Sprite {
        
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderer;
        private var view:View3D;
        private var cube:Cube6;
        
        public function Main() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            init();
            view.render();
        }
        
        private function init():void 
        {
            initEngine();
            initObjects();
            initListener();
            addChild(new Stats());
        }
        
        private function initListener():void 
        {
            addEventListener(Event.ENTER_FRAME, loop);
            stage.addEventListener(Event.RESIZE, onResize);
            onResize();
        }
        
        private function loop(e:Event):void 
        {
            cube.rotationX += 2;
            view.render();
        }
        
        private function onResize(e:Event = null):void
        {
            view.x = stage.stageWidth / 2;
            view.y = stage.stageHeight / 2;
        }
        
        private function initObjects():void
        {
            cube = new Cube6();
            scene.addChild(cube);
        }
        
        private function initEngine():void 
        {
            scene = new Scene3D();
            
            camera = new Camera3D();
            camera.y = -1000;
            camera.z = -1500;
            camera.lookAt(new Vector3D(0, 0, 0));
            
            renderer = new BasicRenderer();
            
            view = new View3D();
            view.scene = scene;
            view.camera = camera;
            view.renderer = renderer;
            addChild(view);
            }
    }
}