/**
 * Copyright yotsu42keisuke ( http://wonderfl.net/user/yotsu42keisuke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sM0Q
 */

// forked from wh0's microstock theft engine
package {
    import mx.utils.Base64Decoder;
    import flash.display.*;
    import flash.events.*;
    import flash.system.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.text.*;
    public class MSTE extends Sprite {
        
        private static const PROXY:String = 'http://5ivestar.org/proxy/';
        private static const CONTEXT:LoaderContext = new LoaderContext(true);
        
        private var qty:int = 0;
        private var src:Bitmap;
        private var lo:BitmapData;
        private var hi:BitmapData;
        private var sf:ShaderFilter;
        private var debug:TextField;
        
        public function MSTE() {
            Security.loadPolicyFile(PROXY + 'crossdomain.xml');
            
            debug = new TextField();
            debug.x = 300;
            debug.width = 165;
            debug.height = 465;
            addChild(debug);
            
            var sl:Loader = new Loader();
            sl.contentLoaderInfo.addEventListener(Event.COMPLETE, srcGet);
            sl.load(new URLRequest(PROXY + 'http://www.istockphoto.com/file_thumbview_approve/8861099/2/istockphoto_8861099-rustic-coffee-crop-on-burlap-with-copy-space.jpg'), CONTEXT);
            
            var ll:Loader = new Loader();
            ll.contentLoaderInfo.addEventListener(Event.COMPLETE, loGet);
            ll.load(new URLRequest(PROXY + 'http://www.istockphoto.com/file_thumbview_approve/12714269/2/istockphoto_12714269-colored-pencil-frame.jpg'), CONTEXT);
            
            var hl:Loader = new Loader();
            hl.contentLoaderInfo.addEventListener(Event.COMPLETE, hiGet);
            hl.load(new URLRequest(PROXY + 'http://www.istockphoto.com/file_thumbview_approve/12728495/2/istockphoto_12728495-scalloped-retro-photo-frame.jpg'), CONTEXT);
            
            // see bottom for shader source
            var d:Base64Decoder = new Base64Decoder();
            d.decode('oQECAAAMX091dENvb3JkAKEBAgQADGQAowAEc3JjAKMBBGxvAKMCBGhpAKECBAEAD2RzdAAdBQDBAAAQAAIFAMEEABAAMAEA8QAAEAAwAgDxBQAQATADAPEFABACAgEA4gIAGAACAwDiAgAYAAUBAOIDABgA');
            sf = new ShaderFilter(new Shader(d.toByteArray()));
            sf.shader.data.d.value = [0, 0];
            debug.appendText('shader loaded\n');
        }
        
        private function srcGet(e:Event):void {
            src = e.target.content;
            addChild(src);
            debug.appendText('source image loaded\n');
            if (++qty == 3)
                done();
        }
        
        private function loGet(e:Event):void {
            lo = new BitmapData(200, 49, false, 0x000000);
            lo.copyPixels(e.target.content.bitmapData, new Rectangle(22, 166, 200, 49), new Point(0, 0));
            sf.shader.data.lo.input = lo;
            debug.appendText('black image loaded\n');
            if (++qty == 3)
                done();
        }
        
        private function hiGet(e:Event):void {
            hi = new BitmapData(200, 49, false, 0xffffff);
            hi.copyPixels(e.target.content.bitmapData, new Rectangle(32, 166, 200, 49), new Point(0, 0));
            sf.shader.data.hi.input = hi;
            debug.appendText('white image loaded\n');
            if (++qty == 3)
                done();
        }
        
        private function done():void {
            src.filters = [sf];
            stage.addEventListener(MouseEvent.MOUSE_MOVE, update);
        }
        
        private function update(e:MouseEvent):void {
            sf.shader.data.d.value = [e.stageX - 100, e.stageY - 25];
            src.filters = [sf];
        }
        
    }
}

/**
parameter "_OutCoord", float2, f0.rg, in
parameter "d", float2, f4.rg, in
texture  "src", t0
texture  "lo", t1
texture  "hi", t2
parameter "dst", float4, f1, out

sub f0.rg, f4.rg

texn f1, f0.rg, t0
texn f2, f0.rg, t1
texn f3, f0.rg, t2

sub f1.rgb, f2.rgb
sub f3.rgb, f2.rgb
div f1.rgb, f3.rgb
*/