/**
 * Copyright kmr ( http://wonderfl.net/user/kmr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sLyG
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.PerspectiveProjection;
	import flash.geom.Point;

	public class BallFlowSprite extends Sprite {
		private var balls:Array;
		private static var NUM_BALL:uint = 100;
		private var VP_X:Number = stage.stageWidth / 2;
		private var VP_Y:Number = stage.stageHeight / 2;
		private static var GRAVITY:Number = 0.2;
		private static var INITIAL_POSITION_Y:Number = 50;
		private static var INITIAL_POSITION_Z:Number = -1;
		private var Y_LEVEL:Array = [100, 150, 200, 250, 300];
		private var Z_LEVEL:Array = [0, -50, -100, -150, -1000]
		private static var BOUNCE:Number = -0.3;
		
		public function BallFlowSprite()
		{
			super();
			init();
		}
		
		private function init():void {
			this.balls = new Array();
			for (var i:uint = 0; i < NUM_BALL; i++) {
				var ball:Ball3D = new Ball3D(1, Math.random() * 0xffffff);
				this.balls.push(ball);
				ball.x = VP_X;
				ball.y = INITIAL_POSITION_Y;
				ball.z = INITIAL_POSITION_Z;
				ball.vx = Math.random() * 2 - 1;
				ball.vy = Math.random() * 2;
				ball.vz = Math.random() * -2;
				addChild(ball);
			}			
			var projector:PerspectiveProjection = new PerspectiveProjection();
			projector.projectionCenter = new Point(VP_X, Y_LEVEL[Y_LEVEL.length - 1] / 2);
			projector.fieldOfView = 90;
			transform.perspectiveProjection = projector;

			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		private function onEnterFrame(evt:Event):void {
			for (var i:uint = 0; i < this.balls.length; i++) {
				var ball:Ball3D = this.balls[i] as Ball3D;
				move(ball);
			}
		}
		
		private function move(ball:Ball3D):void {
			var radius:Number = ball.radius;
			ball.vy += GRAVITY;
			ball.x += ball.vx;
			ball.y += ball.vy;
			ball.z += ball.vz;
			
			if (ball.vy < 0) {
				return;
			}
			
			for (var i:uint = 0; i < Y_LEVEL.length; i++) {
				if (ball.y + ball.radius > Y_LEVEL[i] &&
				    ball.y + ball.radius < Y_LEVEL[i+1]) {
					if (ball.z <= Z_LEVEL[i] && ball.z > Z_LEVEL[i+1]) {
						ball.y = Y_LEVEL[i] - ball.radius;
						ball.vy *= BOUNCE;
					}
					break;
				}
			}
			
		}
	}
}

class Ball extends flash.display.Sprite {
    protected var _radius:Number;
    protected var _color:uint;
    protected var _vx:Number;
    protected var _vy:Number;
		
    public function Ball(radius:Number=40, color:uint=0xff0000, vx:Number=0, vy:Number=0) {
        this._radius = radius;
        this._color = color;
        this._vx = vx;
        this._vy = vy;
        init();
    }

    private function init():void {
        graphics.beginFill(this._color);
        graphics.drawCircle(0, 0, this._radius);
        graphics.endFill();
    }
		
    public function set radius(raduius:Number):void {
        this._radius = radius;
    }
		
    public function get radius():Number {
        return this._radius;
    }
		
    public function set color(color:uint):void {
        this._color = color;
    }
		
    public function get color():uint {
        return this._color;
    }
		
    public function set vx(vx:Number):void {
        this._vx = vx;
    }
		
    public function get vx():Number {
        return this._vx;
    }
		
    public function set vy(vy:Number):void {
        this._vy = vy;
    }
		
    public function get vy():Number {
        return this._vy;
    }
}

class Ball3D extends Ball {
    private var _vz:Number;
		
    public function Ball3D(radius:Number=40, color:uint=0xff0000, vx:Number=0, vy:Number=0, vz:Number=0) {
        super(radius, color, vx, vy);
	this._vz = vz;
    }
		
    public function set vz(vz:Number):void {
        this._vz = vz;
    }
		
    public function get vz():Number {
        return this._vz;
    }
}


