/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sLpu
 */

// forked from strowberrycake's forked from: Picasa KaleidoScope(Picasaの写真を万華鏡化)
// forked from strowberrycake's Picasa KaleidoScope(Picasaの写真を万華鏡化)
// forked from strowberrycake's forked from: KaleidoScope
// forked from umhr's KaleidoScope
package  
{
    
    import flash.display.Sprite;
    import flash.events.Event;
    /**
     * KaleidoScope
     * @author umhr
     * 
     */
    public class WonderflMain extends Sprite 
     {
        
        public function WonderflMain() 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            addChild(new Canvas());
        }
    }
}

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * ...
     * @author umhr
     */
    class Canvas extends Sprite 
    {
        private var _scope:Scope;
        private var _bitmap:Bitmap;
        private var _modestBitmapData:PicasaBitmapData;
        private var _addCount:Number = 1;
        public function Canvas() 
        {
            init();
        }
        private function init():void {
            if (stage) onInit();
            else addEventListener(Event.ADDED_TO_STAGE, onInit);
        }
        private function onInit(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, onInit);
            // entry point
            _bitmap = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFF0000FF));
            var bitmap:Bitmap = new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xFF0000FF));
            
            _scope = new Scope(bitmap.bitmapData, stage.stageWidth, stage.stageHeight, 4);
            
            addEventListener(Event.ENTER_FRAME, enterFrame);
            
            var naname:Number = Math.sqrt(stage.stageWidth * stage.stageWidth + stage.stageHeight * stage.stageHeight);
            
            _modestBitmapData = new PicasaBitmapData(Math.ceil(naname), Math.ceil(naname));
            
            addChild(_modestBitmapData);
            
            addChild(_bitmap);
            
        }
        
        private function enterFrame(e:Event):void 
        {
            _scope.souceBitmapData.fillRect(_scope.souceBitmapData.rect, 0x0);
            _scope.souceBitmapData = _modestBitmapData.getBitmapData();
            
            var add:Number = (mouseX - stage.stageWidth * 0.5) * 0.005;
            add += (mouseY - stage.stageWidth * 0.5) * 0.15;
            _addCount = _addCount * 0.9 + add * 0.1;
            _bitmap.bitmapData = _scope.getImage(_addCount);
            
        }
    }
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.geom.Matrix;
    /**
     * ...
     * @author umhr
     */
    class Scope 
    {
        public var souceBitmapData:BitmapData;
        public var num:int;
        public var count:int;
        public var targetWidth:Number;
        public var targetHeight:Number;
        public function Scope(souceBitmapData:BitmapData, targetWidth:Number, targetHeight:Number, num:int, count:int = 0) 
        {
            this.souceBitmapData = souceBitmapData;
            this.targetWidth = targetWidth;
            this.targetHeight = targetHeight;
            this.num = num;
            this.count = count;
        }
        
        public function getImage(addCount:Number = 1, count:int = -1):BitmapData {
            var result:BitmapData = new BitmapData(targetWidth, targetHeight);
            
            if (count > -1) {
                this.count = count;
            }
            
            var naname:Number = Math.sqrt(targetWidth * targetWidth + targetHeight * targetHeight);
            
            var matrix:Matrix = new Matrix();
            matrix.translate( -Math.floor(naname * 0.5), -Math.floor(naname * 0.5));
            matrix.rotate(this.count * 0.001);
            matrix.translate( Math.floor(targetWidth * 0.5), Math.floor(targetHeight * 0.5));
            
            var shape:Shape = new Shape();
            shape.graphics.beginBitmapFill(souceBitmapData, matrix, false, true);
            shape.graphics.moveTo(0, 0);
            shape.graphics.lineTo(Math.ceil(targetWidth * 0.5), 0);
            shape.graphics.lineTo(Math.ceil(targetWidth * 0.5), Math.ceil(targetHeight * 0.5));
            shape.graphics.lineTo(0, Math.ceil(targetHeight * 0.5));
            shape.graphics.endFill();
            
            var w:int = result.width;
            var h:int = result.height;
            
            w += (w % 2 == 0)?0:1;
            h += (h % 2 == 0)?0:1;
            
            result.draw(shape, new Matrix( 1, 0, 0, 1, 0, 0));
            result.draw(shape, new Matrix( -1, 0, 0, 1, w, 0));
            result.draw(shape, new Matrix( -1, 0, 0, -1, w, h));
            result.draw(shape, new Matrix( 1, 0, 0, -1, 0, h));
            
            this.count += addCount;
            
            return result;
        }
        
    }

    import com.modestmaps.core.MapExtent;
    import com.modestmaps.Map;
    import com.modestmaps.mapproviders.*;
    import com.modestmaps.mapproviders.microsoft.*;
    import com.modestmaps.TweenMap;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;

    class ModestBitmapData extends Sprite
    {
        // Our modest map
        private var map:Map;
        private var _area:Bitmap;
        /**
         * This constructor is called automatically when the SWF starts
         */
        private var _stageWidth:Number;
        private var _stageHeight:Number;
        public function ModestBitmapData(stageWidth:Number, stageHeight:Number)
        {
            _stageWidth = stageWidth;
            _stageHeight = stageHeight;
            init();
        }
        
        private function init():void
        {
            _area = new Bitmap(new BitmapData(_stageWidth, _stageHeight));
            // create map
            var d:Number = 0.01;
            map = new TweenMap(_stageWidth, _stageHeight,
                               true,
                               new MicrosoftAerialMapProvider(),
                               new MapExtent(35.684 + d, 35.684 - d, 139.761 + d, 139.761 - d)
                               );
            addChild(map);
        }
        
        public function getBitmapData():BitmapData {
            _area.bitmapData.fillRect(_area.bitmapData.rect, 0xFFFF0000);
            //_area.bitmapData.draw(map);
            return _area.bitmapData;
        }
        
    }

        
        import flash.display.Bitmap;
        import flash.display.BitmapData;
        import flash.display.Sprite;
        import flash.events.Event;
        import flash.events.IOErrorEvent;
        import org.libspark.betweenas3.BetweenAS3;
        import org.libspark.betweenas3.tweens.ITween;
        /**
         * ...
         * @author umhr
         */
        class PicasaBitmapData extends Sprite 
         {
            
            private var _area:Bitmap;
            private var _canvas:Sprite;
            private var _stageWidth:Number;
            private var _stageHeight:Number;
            private var _photos:PicasaPhotos;
            private var _count:int;
            private var _photoCount:int = 0;
            private var _frontBitmap:Bitmap = new Bitmap();
            private var _backBitmap:Bitmap = new Bitmap();
            public function PicasaBitmapData(stageWidth:Number, stageHeight:Number)
            {
                _stageWidth = stageWidth;
                _stageHeight = stageHeight;
                init();
            }
            private function init():void 
            {
                _area = new Bitmap(new BitmapData(_stageWidth, _stageHeight));
                _canvas = new Sprite();
                _photos = new PicasaPhotos();
                _photos.addEventListener(Event.COMPLETE, onComplete);
                _photos.addEventListener(IOErrorEvent.IO_ERROR, onIoError);
                
                //この↓の「q:」部分のワードを変えることで、違う検索結果で万華鏡が楽しめます。
                var parameters:Object = { q:"strawberrycakebot", imgmax:"640", "max-results":999 };

                _photos.load( parameters );
            }
            private function onIoError(event:Event):void {
                    trace("無いよ");
            }
            private function onComplete(event:Event):void {
                setPhoto();
                //trace(_photos.loader.items.length)
            }
            public function getBitmapData():BitmapData {
                
                _count ++;
                if (_count % 180 == 0) {
                    _count = 0;
                    setPhoto();
                }
                
                _area.bitmapData.fillRect(_area.bitmapData.rect, 0x00000000);
                _area.bitmapData.draw(_canvas);
                return _area.bitmapData;
            }
            
            private function setPhoto():void {
                
                _backBitmap = _photos.loader.getBitmap(String(_photoCount));
                _backBitmap.scaleX = _backBitmap.scaleY = 1;
                _backBitmap.scaleX = _backBitmap.scaleY = _stageWidth / Math.min(_backBitmap.width, _backBitmap.height);
                //_backBitmap.alpha = 1;
                
                _photoCount ++;
                _photoCount = _photoCount % _photos.loader.items.length;
                
                _frontBitmap = _photos.loader.getBitmap(String(_photoCount));
                _frontBitmap.scaleX = _frontBitmap.scaleY = 1;
                _frontBitmap.scaleX = _frontBitmap.scaleY = _stageWidth / Math.min(_frontBitmap.width, _frontBitmap.height);
                _frontBitmap.visible = true;
                var t:ITween;
                t = BetweenAS3.tween(_frontBitmap, { alpha:1 }, { alpha:0 }, 3);
                t.onComplete = onComplete2;
                t.play();
                
                while (_canvas.numChildren > 0) {
                    _canvas.removeChildAt(0);
                }
                
                _canvas.addChildAt(_backBitmap, 0);
                _canvas.addChildAt(_frontBitmap, 1);
            }
            private function onComplete2():void {
                _backBitmap.visible = false;
            }
            
        }
        


import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.MovieClip;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import flash.system.Security;
import flash.utils.ByteArray;
import flash.utils.Dictionary;
import flash.utils.getQualifiedClassName;
class PicasaPhotos {
        public var xmlLoader:MultiLoader;
        public var loader:MultiLoader;
        public var credits:Array = [];
        private var _complete:Function = function(event:Event):void{};
        private var _ioError:Function = function(event:Event):void{};
        public function PicasaPhotos() {
            Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");
            xmlLoader = new MultiLoader("xml");
            loader = new MultiLoader("photos");
        }
        public function addEventListener(type:String, listener:Function):void {
            this["_" + type] = listener;
        }
        public function load(props:Object = null):void {
           
           
        //↓の部分で、下を機能させるとCC(クリエイティブ・コモンズ)モード検索で集まった画像、上を機能させると通常の検索での画像で集まった画像で万華鏡を楽しむことができます。
           
           var defaultProps:Object = { "max-results":3, imgmax:"320", kind:"photo", "start-index":"1"}
         //var defaultProps:Object = { "max-results":3, imgmax:"320", imglic:"creative_commons", kind:"photo", "start-index":"1"};            
           
        //(「"start-index":」部分の番号を変えることにより、万華鏡アニメーションを始める画像の場所を変更することも可能です)   
           
            var xmlURL:String = "http://photos.googleapis.com/data/feed/base/all?alt=rss";
            
            var p:String;
            for (p in props) {
                defaultProps[p] = props[p];
            }
            
            for (p in defaultProps) {
                xmlURL += "&" + p + "=" + encodeURIComponent(decodeURIComponent(defaultProps[p]));
            }
            xmlLoader.add(xmlURL, { id:"xml", type:"text" } );
            xmlLoader.addEventListener(Event.COMPLETE, loadIMG);
            xmlLoader.start();
        }
        private function loadIMG(event:Event):void {
            var myXML:XML = xmlLoader.getXML("xml");
            default xml namespace = new Namespace("http://search.yahoo.com/mrss/"); 
            var n:int = myXML.channel.item.length();
            if (n == 0) {
                atIoError(null);
                return;
            }
            for (var i:int = 0; i < n; i++) {
                var url:String = myXML.channel.item[i].group.content.@url;
                loader.add(url, { context:new LoaderContext(true), id:String(credits.length), type:"image" } );
                credits.push(myXML.channel.item[i].group.credit);
            }
            loader.addEventListener(Event.COMPLETE, atComp);
            loader.start();
        }
        private function atIoError(event:Event):void {
            _ioError(event);
        }
        private function atComp(event:Event):void {
            _complete(event);
        }
}

        class MultiLoader{
            public static var IMAGE_EXTENSIONS:Array = ["swf", "jpg", "jpeg", "gif", "png"];
            public static var TEXT_EXTENSIONS:Array = ["txt", "js", "xml", "php", "asp"];
            public static const COMPLETE:String = "complete";
            private var _listener:Function = function(event:Event):void{};
            private var _loads:Dictionary;
            private var _keyFromId:Dictionary;
            private var _loadCount:int;
            private var _itemsLoaded:int;
            public var items:Array;
            public function MultiLoader(name:String = ""){
                _loads = new Dictionary();
                _keyFromId = new Dictionary();
                _itemsLoaded = 0;
                items = [];
            }
            public function add(url:String, props:Object = null):void {    
                var loadingItem:LoadingItem = new LoadingItem();
                loadingItem.url = url;
                loadingItem.type = getType(url, props);
                if(props){
                    if(props.context){
                        loadingItem.context = props.context;
                    }
                    if (props.id) {
                        _keyFromId[props.id] = url;
                    }
                    if (props.preventCache) {
                        loadingItem.preventCache = props.preventCache;
                    }
                }
                items.push(loadingItem); 
            }
            private function getType(url:String, props:Object = null):String{
                var result:String = "";
                if (props && props.type) {
                    return props.type;
                }
                var i:int;
                var extension:String;
                var n:int = IMAGE_EXTENSIONS.length;
                for (i = 0; i < n; i++) {
                    extension = IMAGE_EXTENSIONS[i];
                    if(extension == url.substr(-extension.length).toLowerCase()){
                        result = "image";
                        break;
                    }
                }
                if(result == ""){
                    n = TEXT_EXTENSIONS.length;
                    for (i = 0; i < n; i++) {
                        extension = TEXT_EXTENSIONS[i];
                        if(extension == url.substr(-extension.length).toLowerCase()){
                            result = "text";
                            break;
                        }
                    }
                }
                return result;
            }
            
            public function start():void{
                var n:int = items.length;
                for (var i:int = 0; i < n; i++) {
                    var type:String = items[i].type;
                    var url:String = items[i].url;
                    url += (items[i].preventCache)?"?rand=" + Math.random():"";
                    var uRLRequest:URLRequest = new URLRequest(url);
                    if(type == "image"){
                        _loads[items[i].url] = loadImage(uRLRequest, items[i].context);
                    }else if(type == "text"){
                        _loads[items[i].url] = loadText(uRLRequest);
                    }else if (type == "byteImage") {
                        byteImage(uRLRequest, items[i].context);
                    }
                }
            }
            public function addEventListener(type:String,listener:Function):void{
                _listener = listener;
            }
            public function getBitmap(key:String):Bitmap{
                key = keyMatching(key);
                var bitmap:Bitmap;
                try{
                    if (getQualifiedClassName(_loads[key].content) == "flash.display::MovieClip") {
                        var mc:MovieClip = _loads[key].content;
                        var bitmapData:BitmapData = new BitmapData(mc.width, mc.height);
                        bitmapData.draw(mc);
                        bitmap = new Bitmap(bitmapData);
                    }else {
                        bitmap = _loads[key].content;
                    }
                }catch (e:*) {
                    //bitmap = new Bitmap();
                }
                return bitmap;
            }
            public function getBitmapData(key:String):BitmapData{
                key = keyMatching(key);
                var bitmap:Bitmap = getBitmap(key);
                var bitmapData:BitmapData = new BitmapData(bitmap.width, bitmap.height);
                bitmapData.draw(bitmap);
                return bitmapData;
            }
            private function loadImage(url:URLRequest, context:LoaderContext = null):Loader {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
                loader.load(url,context);
                return loader;
            }
            private function byteImage(url:URLRequest, context:LoaderContext = null):void {
                var loader:Loader = new Loader();
                loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadBytes);
                loader.load(url, context);
                function loadBytes(event:Event):void {
                    _loads[url.url] = new Loader();
                    _loads[url.url].contentLoaderInfo.addEventListener(Event.COMPLETE, onComp);
                    _loads[url.url].loadBytes(event.target.bytes);
                }
            }
            public function getBinary(key:String):ByteArray{
                return _loads[keyMatching(key)].contentLoaderInfo.bytes;
            }
            
            public function getText(key:String):String {
                key = keyMatching(key);
                return key?_loads[key].data:key;
            }
            public function getXML(key:String):XML {
                return XML(getText(key));
            }
            private function keyMatching(key:String):String {
                return _loads[key]?key:_keyFromId[key];
            }
            
            private function loadText(url:URLRequest):URLLoader{
                var loader:URLLoader = new URLLoader();
                loader.addEventListener(Event.COMPLETE, onComp);
                loader.load(url);
                return loader;
            }
            private function onComp(event:Event):void{
                _itemsLoaded ++;
                if (_itemsLoaded == items.length) {
                    _itemsLoaded = 0;
                    _listener(event);
                }
            }
            public function get itemsTotal():int{
                return items.length;
            }
            public function get itemsLoaded():int{
                return _itemsLoaded;
            }
            public function get loadedRatio():Number {
                return _itemsLoaded / items.length;
            }
        }


class LoadingItem{
        public var url:String;
        public var preventCache:Boolean;
        public var type:String;
        public var status:String;
        public var context:LoaderContext;
        public function LoadingItem(){};
}
