/**
 * Copyright yun ( http://wonderfl.net/user/yun )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sKnM
 */

// forked from yun's Picasaから画像を検索して表示
/*
確認用URL
http://photos.googleapis.com/data/feed/base/all?alt=json&kind=photo&q=waterdrop&imglic=commercial&max-results=3&imgmax=288

Picasa Web Albums Data API
http://code.google.com/intl/ja/apis/picasaweb/docs/2.0/reference.html
*/
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.filters.DropShadowFilter;
    import com.adobe.serialization.json.JSONDecoder;
    
    public class Main extends Sprite
    {
        public function Main()
        {
            // 検索結果のロード
            var myURLLoader:URLLoader = new URLLoader();
            myURLLoader.addEventListener( Event.COMPLETE, onCompleteJSON );
            var jsonURL:String = "http://photos.googleapis.com/data/feed/base/all?alt=json&kind=photo&q=waterdrop&imglic=commercial&max-results=3&imgmax=288";
            // crossdomain.xml（クロスドメインポリシーファイル）の位置を指定
            Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");
            myURLLoader.load( new URLRequest( jsonURL ) );
        }
        
        private function onCompleteJSON( e:Event ):void
        {
            // 取得したデータをJSON型にする。
            var decoder:JSONDecoder = new JSONDecoder( e.currentTarget.data );
            var json:Object = decoder.getValue();
            
            // JSONを解析
            var titlesStr:String = json.feed.entry[0].title.$t;
            var linkURL:String = json.feed.entry[0].link[1].href;
            var creditStr:String = json.feed.entry[0].media$group.media$credit[0].$t;    // *1
            var imgURL:String = json.feed.entry[0].media$group.media$content[0].url;    // *2
            
            var textData:String = "";
            textData += titlesStr + "\n";
            textData += linkURL + "\n";
            textData += creditStr + "\n";
            textData += imgURL + "\n";
            textData += "******\n";
            textData += e.currentTarget.data;
            
            // 背景のグレーの文字。JSONの文字列を流し込んでいる。
            var tf:TextField = new TextField();
            tf.text = textData;
            tf.textColor = 0xCCCCCC;
            tf.wordWrap = true;
            tf.width = tf.height = 465;
            addChild( tf );
            
            // タイトル、クレジット、リンクのテキストを入れて、ドロップシャドウをかける
            var fld:TextField = new TextField();
            fld.autoSize = TextFieldAutoSize.LEFT;
            fld.width = 300;
            fld.x = 50;
            fld.y = 50;
            fld.multiline = true;
            fld.text = textData;
            var dsf:DropShadowFilter = new DropShadowFilter();
            dsf.alpha = .6;
            fld.filters = [dsf];
            addChild( fld );
            
            // 画像のロード
            var myLoader:Loader = new Loader();
            var myURLRequest:URLRequest = new URLRequest( imgURL );
            
            // クロスドメインポリシーファイルをドキュメントルートから取得
            var myLoaderContext:LoaderContext = new LoaderContext( true );    // *8
            myLoader.load( myURLRequest, myLoaderContext );
            myLoader.contentLoaderInfo.addEventListener( Event.COMPLETE, onCompleteImg );
        }
        
        private function onCompleteImg( e:Event ):void
        {
            // 読み込んだ画像をBitmapData化し、SpriteにbeginBitmapFillで転写。
            // この操作を複数ドメイン上で行うにはクロスドメインポリシーファイルによる許可が必要。
            var myBitmap:Bitmap = e.target.content;
            var myBitmapData:BitmapData = new BitmapData( myBitmap.width, myBitmap.height );
            myBitmapData.draw( myBitmap );
            var mySprite:Sprite = new Sprite();
            mySprite.graphics.beginBitmapFill( myBitmapData );
            mySprite.graphics.drawRoundRect( 0, 0, myBitmap.width, myBitmap.height, 10, 10 );
            mySprite.x = 50;
            mySprite.y = 150;
            var dsf:DropShadowFilter = new DropShadowFilter();
            dsf.alpha = .6;
            mySprite.filters = [dsf];
            addChild( mySprite );
        }
    }
}