/**
 * Copyright 883108 ( http://wonderfl.net/user/883108 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sKmt
 */

package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import flash.geom.Point;
	public class CurveLineDrawerDocument2 extends Sprite {
		private var _maxNum:uint = 10;

		public function CurveLineDrawerDocument2() {
			init();
		}

		private function init():void {
			var tex:TextField = new TextField  ;
			addChild(tex);
			tex.width = 450;
			tex.x = tex.y = 10;
			tex.multiline = true;
			tex.text = 'ランダムに生成されたポイントに対して滑らかに曲線を引きます。\n補完するポイントを予め算出してから描画するため、\n曲線同士が必ずなだらかにつながります。';
			// ランダムにポイントを生成し、配列に格納
			var points:Array = [];
			for (var i:uint = 0; i< _maxNum; i++) {
				points[i] = new Point(Math.random() * stage.stageWidth | 0,Math.random() * stage.stageHeight | 0);
			}
			// 線の設定を行い、まず、１つ目の中間点を求めたらそこに移動する。
			// この処理を行う事により、各ポイントを結ぶ曲線同士がスムーズにつながる。
			graphics.lineStyle(0);
			var xStart:Number = (points[0].x + points[_maxNum -1].x) / 2;
			var yStart:Number = (points[0].y + points[_maxNum -1].y) / 2;
			graphics.moveTo(xStart, yStart);
			// 残りの点をループ処理し、各中間点まで曲線を描く
			var xt:Number,yt:Number;
			for (i = 0; i< _maxNum -1; i++) {
				xt = (points[i].x + points[i+1].x) / 2;
				yt = (points[i].y + points[i+1].y) / 2;
				graphics.curveTo(points[i].x, points[i].y, xt, yt);
			}
			// 終点と始点を結び、終了
			graphics.curveTo(points[i].x, points[i].y, xStart, yStart);
		}
	}
}