/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sKiz
 */

package 
{
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.net.URLRequest;
    import com.bit101.components.PushButton;
    import flash.text.TextField;
    
    /**
     * ...
     * @author umhr
     */
    public class Main extends Sprite 
    {
        private var _tf:TextField;
        private var _type:String;
        private var _content:*;
        public function Main():void 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            _type = "";
            _tf = new TextField();
            _tf.width = _tf.height = 465;
            _tf.multiline = true;
            _tf.wordWrap = true;
            _tf.y = 20;
            this.addChild(_tf);
            
            new PushButton(this, 0, 0, "Load File", onStart);
        }
        public function onStart(event:Event):void {
            if(event.target.label == "Load File" || _type == ""){
                event.target.label = "hoge";
                var loaderFile:LoadFile = new LoadFile();
                loaderFile.atComplete = atComp;
                loaderFile.start();
                event.target.label = "addChild()";
                _tf.text = "";
                if(_content){
                    this.removeChild(_content);
                }
            }else {
                event.target.label = "Load File";
                _content.y = 20;
                this.addChild(_content);
            }
        }
        private function atComp(event:Event):void {
            
            _tf.appendText(event.target.content + "\n");
            var info : LoaderInfo = event.target as LoaderInfo;
            _tf.appendText("MIME タイプ : " + info.contentType + "\n");
            _tf.appendText("ファイルの場所 : " + info.url + "\n");
            _tf.appendText("ローダーの場所 : " + info.loaderURL + "\n");
            _tf.appendText("幅 : " + info.width + "\n");
            _tf.appendText("高さ : " + info.height + "\n");
            if(info.contentType == "application/x-shockwave-flash"){
                _tf.appendText("これはSWFファイルです。" + "\n");
                _tf.appendText("SWFファイルのバージョン : " + info.swfVersion + "\n");
                _tf.appendText("FPS : " + info.frameRate + "\n");
                _tf.appendText("ASのバージョン : " + info.actionScriptVersion + "\n");
                if (info.actionScriptVersion == 3) {
                    _type = "AS3.0";
                    _content = event.target.content;
                }else {
                    _type = "AS1.0/2.0";
                    _content = event.target.content.parent;
                }
            }else if (info.contentType == "image/jpeg") {
                _type = "JPEG";
                _tf.appendText("これはJPEGファイルです。" + "\n");
                _content = event.target.content;
            }else if (info.contentType == "image/gif") {
                _type = "GIF";
                _tf.appendText("これはGIFファイルです。" + "\n");
                _content = event.target.content;
            }else{
                _type = "";
                _tf.appendText("これはSWFファイルではありません" + "\n");
            }
        }
        
    }
    
}

import flash.display.Loader;
import flash.events.Event;
import flash.net.FileReference;
import flash.system.LoaderContext;
class LoadFile{
    private var _fileReference:FileReference;
    public var atComplete:Function = function(event:Event):void{};
    /**
     * 開始
     *
     */
    public function start():void
    {
        if(_fileReference){
            return;
        }
        _fileReference = new FileReference();
        _fileReference.browse();
        _fileReference.addEventListener(Event.SELECT, atSelect);
    }
    /**
     * ファイルの選択が完了すると動く
     * @param event
     *
     */
    private function atSelect(event:Event):void{
        _fileReference.removeEventListener(Event.SELECT, atSelect);
        _fileReference.addEventListener(Event.COMPLETE, atFileComplete);
        _fileReference.load();
    }
    /**
     * 選択したファイルを読み込み完了すると動く
     * @param event
     *
     */
    private function atFileComplete(event:Event):void{
        _fileReference.removeEventListener(Event.COMPLETE, atFileComplete);
        var loader:Loader = new Loader();
        loader.loadBytes(event.target.data, new LoaderContext());
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, atBytesComplete);
    }
    /**
     * 読み込んだファイルのバイトアレイを変換完了で動く
     * @param event
     *
     */
    private function atBytesComplete(event:Event):void{
        event.target.removeEventListener(Event.COMPLETE, atBytesComplete);
        atComplete(event);
    }
}
