/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sKhR
 */






package 
{
    import flash.display.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.media.*;
    import flash.net.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.effects.utils.*;
    import org.papervision3d.view.layer.*;
    
    public class Sample extends BasicView {
        
        private var soundChannel:SoundChannel;
        private var sphere1:Sphere;
        private var sphere2:Sphere;
        
        public function Sample():void {
            // 背景を黒に設定
            viewport.opaqueBackground = 0x000000;
            
            // エフェクトレイヤーを追加
            var bfx:BitmapEffectLayer = new BitmapEffectLayer( viewport, 465, 465 );
            bfx.addEffect( new BitmapLayerEffect( new BlurFilter( 16, 16, 5 ) ) );
            bfx.drawCommand = new BitmapDrawCommand( null, new ColorTransform( 1, 1, 1, 0.15 ), BlendMode.ADD );
            bfx.clippingPoint = new Point( 0, 0 );
            viewport.containerSprite.addLayer( bfx );
            
            // 球体を作成
            var material1:WireframeMaterial = new WireframeMaterial( 0xFF0000 );
            var material2:WireframeMaterial = new WireframeMaterial( 0x00CCFF );
            sphere1 = new Sphere( material1, 800, 20, 20 );
            sphere2 = new Sphere( material2, 800, 20, 20 );
            sphere1.x = 600;
            sphere2.x = -600;
            scene.addChild( sphere1 );
            scene.addChild( sphere2 );
            
            // エフェクトレイヤーに追加
            bfx.addDisplayObject3D( sphere1 );
            bfx.addDisplayObject3D( sphere2 );
                        
            // 音楽読み込み
            var sound:Sound = new Sound( new URLRequest( "http://mutast.heteml.jp/works/music/music.mp3" ) );
            soundChannel = sound.play();
            
            startRendering();
            addEventListener( Event.ENTER_FRAME, loop );
        }
        
        private function loop( e:Event ):void {

            var volume:Number = ( soundChannel.leftPeak + soundChannel.rightPeak ) / 2;

            sphere1.scale -= 0.02;
            sphere2.scale -= 0.02;
            sphere1.scale = Math.max( volume, sphere1.scale );
            sphere2.scale = Math.max( volume, sphere2.scale );
   
            sphere1.rotationX += soundChannel.leftPeak * 5;
            sphere1.rotationY += soundChannel.rightPeak * 5;
            sphere2.rotationX += soundChannel.leftPeak * 10;
            sphere2.rotationY += soundChannel.rightPeak * 10;

            var rateX:Number = mouseX / stage.stageWidth;
            var targetX:Number = -5000 * ( rateX - 0.5 );
            camera.x += ( targetX - camera.x ) * 0.2;
            
            var rateY:Number = mouseY / stage.stageHeight;
            var targetY:Number = 5000 * ( rateY - 0.5 );
            camera.y += ( targetY - camera.y ) * 0.2;
        }
    }
}



// forked from AKYH's forked from: 残像エフェクトつきサウンドビジュアライザ
// forked from yun's 残像エフェクトつきサウンドビジュアライザ
// forked from yun's サウンドビジュアライザ
// forked from yun's カメラの動きにイージングを付ける
// forked from yun's カメラの動きを指定
// forked from yun's 3Dオブジェクトに動きを付ける
// forked from yun's シンプルな3Dオブジェクト