/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sKbN
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import frocessing.color.ColorHSV;
    
    [SWF(backgroundColor="0x000000", frameRate="60", width="465", height="465")]
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            addChild(new Bitmap(bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0), "auto", true));
            canvas = new Shape();
            addEventListener(Event.ENTER_FRAME, loop);
            var i:int, n:int = 10;
            for(i = 0; i < n; i++)
            {
                addEventListener(Event.ENTER_FRAME, getLoop(-0.2 + i * 0.8));
            }
            addEventListener(Event.ENTER_FRAME, endLoop);            
        }
        private const colorTf:ColorTransform = new ColorTransform(1,1,1,1,-4,-4,-4);
        private var bmd:BitmapData;
        private var canvas:Shape;
        private function loop(e:Event):void
        {
            bmd.lock();
            bmd.colorTransform(bmd.rect, colorTf);
        }
        
        private function getLoop(t:Number):Function
        {
            var color:ColorHSV = new ColorHSV();
            return function(e:Event):void
            {
                color.h = t * 20;
                var g:Graphics = canvas.graphics, r:Number;
                g.clear();
                g.lineStyle(0, color.value);
                r = Math.exp(Math.sin(t)) - 2 * Math.cos(4 * t) + Math.pow(Math.sin((t-Math.PI/2)/12),5);
                g.moveTo(465 / 2 + 50 * r * Math.cos(t), 465 / 2 - 30 * r * Math.sin(t));
                t += 0.03;
                r = Math.exp(Math.sin(t)) - 2 * Math.cos(4 * t) + Math.pow(Math.sin((t-Math.PI/2)/12),5);
                g.lineTo(465/2 + 50 * r * Math.cos(t), 465/2-30*r*Math.sin(t));
                bmd.draw(canvas);
            }
        }
        
        private function endLoop(e:Event):void
        {
            bmd.unlock();
        }
    }
}