/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sIJ3
 */

package  
{
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.b2Body;
    import com.actionsnippet.qbox.QuickBox2D;
    import com.actionsnippet.qbox.QuickObject;
    import flash.display.Graphics;
    import flash.display.MovieClip;
    import flash.display.Sprite;

    public class Ring extends MovieClip 
    {
        private var sim:QuickBox2D;
        private var segmentWidth:Number;
        private var segmentHeight:Number;
        
        public function Ring() 
        {
            sim = new QuickBox2D(this, { debug:true } );
            sim.gravity = new b2Vec2;
            sim.createStageWalls();
            addRing(7, 7, 5);
            // start simulation
            sim.start();
            sim.mouseDrag();            
        }
        
        private function addRing(cx:Number, cy:Number,r:Number):void 
        {
            var extraWidthFactor:Number = 1.2;
            segmentWidth = 0.5;
            var segmentAmount:Number = 20;
            var deltaAngle:Number = Math.PI * 2 / segmentAmount;
            segmentHeight = 2 * r * Math.sin(deltaAngle * 0.5)*extraWidthFactor;
            var angle:Number = 0;
            var box:Object = 
            { 
                x:cx + r * Math.cos(angle), 
                y:cy + r * Math.sin(angle), 
                width:segmentWidth, 
                height:segmentHeight, 
                fixedRotation:false,
                angularDamping:1, 
                density:1,
                fillAlpha:0
                };
            box["groupIndex"] = -1;
            var pre:QuickObject = sim.addBox( box );
            box["groupIndex"] = 1;
            var first:QuickObject = pre;
            for (var i:int = 0; i <segmentAmount-1; i++) 
            {
                angle += deltaAngle;
                box["angle"] = angle;
                box["x"] = cx + r * Math.cos(angle);
                box["y"] = cy + r * Math.sin(angle);
                if (i == segmentAmount - 2)
                {
                    box["groupIndex"] = -1;
                    box["fillAlpha"] = 0.5;
                }
                var curr:QuickObject = sim.addBox(box);
                addJoint( pre.body, curr.body );
                pre = curr;
            }
            curr = first;
            addJoint(pre.body,curr.body,-pre.body.GetAngle()+curr.body.GetAngle());
        }
        
        private function addJoint(aArg:b2Body, bArg:b2Body,referenceAngleArg:Number=0):QuickObject 
        {
            var radius:Number = 1;
            var getAngle:Number = aArg.GetAngle()+Math.PI*0.5;
            var output:QuickObject = sim.addJoint( { a:aArg, b:bArg, type:QuickBox2D.REVOLUTE 
            ,lowerAngle: -2, upperAngle:2, enableLimit:true, referenceAngle:referenceAngleArg,
            vecA:new b2Vec2(
                aArg.GetPosition().x + segmentHeight * 0.5 * Math.cos(getAngle), 
                aArg.GetPosition().y + segmentHeight * 0.5 * Math.sin(getAngle)
                ),
                collideConnected:false
            } );
            var g:Graphics = Sprite(sim.main.addChild(new Sprite)).graphics;
            g.beginFill(0xff0000);
            g.drawCircle(output.params.vecA.x * 30, output.params.vecA.y * 30, 2.5);
            return output
        }
        
        
        
    }

}


