/**
 * Copyright sinketu ( http://wonderfl.net/user/sinketu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sH8t
 */

// forked from ll_koba_ll's CameraSample03
package {
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.events.Event;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.filters.BlurFilter;

    [SWF(frameRate=30)]
    public class CameraSample03 extends Sprite { 
        private var _camera:Camera;
        private var _video:Video;

        private var _canvasBitmapData:BitmapData;
        private var _eraseBitmapData:BitmapData;
        private var _nowBitmapData:BitmapData;
        private var _effectBitmapData:BitmapData;
        private var _prevBitmapData:BitmapData;
        private var _compareBitmapData:BitmapData;
        private var _zero:Point;
        private var _mirrorMatrix:Matrix;
        private var _blur:BlurFilter;
        private var _fillRect:Rectangle;
        private const VIDEO_WIDTH:Number = 240;
        private const VIDEO_HEIGHT:Number = 240;

        public function CameraSample03() {
            _camera = Camera.getCamera();
            if (_camera == null) {
                return;
            }
            
            _camera.setMode(VIDEO_WIDTH, VIDEO_HEIGHT, 15);

            _video = new Video(_camera.width, _camera.height);
            _video.attachCamera(_camera);
            
            _canvasBitmapData = new BitmapData(_camera.width, _camera.height, false, 0x000000);
            _effectBitmapData = new BitmapData(_camera.width, _camera.height, true, 0x00000000);
            _nowBitmapData = new BitmapData(_camera.width, _camera.height, true, 0x00000000);
            _prevBitmapData = new BitmapData(_camera.width, _camera.height, false, 0x000000);

            _blur = new BlurFilter(2,2,3);
            _fillRect = new Rectangle(0, _nowBitmapData.height - 5, _nowBitmapData.width, 5);

            var scale:Number = 465/VIDEO_WIDTH;

            var canvas:Bitmap = addChild(new Bitmap(_canvasBitmapData)) as Bitmap;
            canvas.scaleX = canvas.scaleY = scale;
            
            var whiteEffectBitmap:Bitmap=addChild(new Bitmap(_effectBitmapData)) as Bitmap;
            whiteEffectBitmap.scaleX=whiteEffectBitmap.scaleY=scale;

            addEventListener(Event.ENTER_FRAME, enterFrameHandler);

            _zero = new Point();

            _mirrorMatrix = new Matrix();
            _mirrorMatrix.scale(-1, 1); // 反転                                                                                        
            _mirrorMatrix.translate(VIDEO_WIDTH, 0); // 元の位置に戻す

        }

        private function enterFrameHandler(e:Event):void {
            _canvasBitmapData.lock();
            _nowBitmapData.lock();
            _prevBitmapData.lock();
            _effectBitmapData.lock();
            _canvasBitmapData.draw(_video, _mirrorMatrix);
            _nowBitmapData.copyPixels(_canvasBitmapData, _canvasBitmapData.rect, _zero);
            // 前回との差分を取る
            _nowBitmapData.draw(_prevBitmapData, null, null, BlendMode.DIFFERENCE);
            // 前回と同じところは透明に
            _nowBitmapData.threshold(_nowBitmapData, _nowBitmapData.rect, _zero, "<", 0xFF333333, 0x00000000);
            
            // 前回と違う部分
            _nowBitmapData.threshold(_nowBitmapData, _nowBitmapData.rect, _zero, ">", 0xFF333333, 0xFFFFFFFF);
            
            _prevBitmapData.copyPixels(_canvasBitmapData, _canvasBitmapData.rect, _zero);
            _effectBitmapData.draw(_nowBitmapData, null, new ColorTransform(1,1,1,0.8,255,255,0), BlendMode.ADD);
            // blurで塗りつぶされてしまわないように常に透明部分が存在するように
            _effectBitmapData.fillRect(_fillRect, 0x00FFFFFF); 
            _effectBitmapData.applyFilter(_effectBitmapData, _effectBitmapData.rect, _zero, _blur);
            _canvasBitmapData.unlock();
            _nowBitmapData.unlock();
            _prevBitmapData.unlock();
            _effectBitmapData.unlock();
        }
    }
}
