/**
 * Copyright and.korolyov ( http://wonderfl.net/user/and.korolyov )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sGKj
 */

package {
    import flash.display.Graphics;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    import flash.geom.Rectangle;
    import flash.display.Stage;
    import flash.display.Sprite;    
    public class Pingpong extends Sprite {
        public function Pingpong() {
            //graphics.beginFill(0x000000);
            //graphics.drawCircle(400,300,50);
            //graphics.endFill();
            mainMenu = new MainMenu();
            addChild(mainMenu);            
            mainMenu.ShowMenu();            
            mainMenu.addEventListener(MouseEvent.CLICK, gameStart);                                              
        }
        
        public function gameStart(e:Event):void{            
            removeChild(mainMenu);
            mainMenu.removeEventListener(MouseEvent.CLICK, gameStart);            
            
            graphics.beginFill(0x2FCC6B,1);
            graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            graphics.beginFill(0x000000,1);
            graphics.drawRect(0,stage.stageWidth-30, stage.stageHeight,30);
            graphics.endFill();    
            
            graphics.beginFill(0xFFFFFF);
            graphics.drawCircle((stage.stageWidth+4)/2, (stage.stageHeight-30)/2,40);
            graphics.endFill();
            
            graphics.beginFill(0x2FCC6B);    
            graphics.drawCircle((stage.stageWidth+4)/2, (stage.stageHeight-30)/2,30); 
            graphics.endFill();    

            graphics.beginFill(0xC5803A);            
            graphics.drawRect(stage.stageWidth/2, 0, 5, stage.stageHeight-30);
            graphics.endFill();
                        
            var keys1:Array = [Keyboard.W, Keyboard.S];
            var keys2:Array = [Keyboard.UP, Keyboard.DOWN];
                  
            bat1 = new Bat(keys1, 0, 0);            
            bat2 = new Bat(keys2, stage.stageHeight - 20,0);
            ball = new Ball();
            
            textPoints1 = new TextField();
            textPoints2 = new TextField();
               
            addChild(bat1);    
            addChild(bat2);      
            addChild(ball);
            addChild(textPoints1);
            addChild(textPoints2);   
            points1 = 0;
            points2 = 0;
            ball.Start();         

            //stage.addEventListener(MouseEvent.CLICK,
            //function (e:Event):void {graphics.clear(); });
            //stage.focus = this;
            stage.addEventListener(KeyboardEvent.KEY_DOWN, bat1.moveByKb);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, bat2.moveByKb);
            stage.addEventListener(Event.ENTER_FRAME, ballMove);
            
            //stage.addEventListener(Event.ENTER_FRAME, showText);
                        
            textPoints1.x = 50;
            textPoints1.y = stage.stageHeight - 30;
            textPoints1.defaultTextFormat = new TextFormat(null, 24, 0xFFFFFF);
            textPoints2.x = stage.stageWidth - 50;
            textPoints2.y = stage.stageHeight - 30;
            textPoints2.defaultTextFormat = new TextFormat(null, 24, 0xFFFFFF);
            textPoints1.text = "0";
            textPoints2.text = "0";
        }
        
        
        public function ballMove(e:Event):void{            
          ball.x = ball.x + ball.dx;
          ball.y = ball.y + ball.dy;
          if (ball.x <= 0) { points2++; textPoints2.text = String(points2); ball.Start();}//ball.dx = -ball.dx;
          if (ball.y <= 0) ball.dy = -ball.dy;
          if (ball.x >= stage.stageWidth){ points1++; textPoints1.text = String(points1); ball.Start();}//ball.dx = -ball.dx;
          if (ball.y >= stage.stageHeight - 50) ball.dy = -ball.dy;
                   
          if (ball.hitTestObject(bat1)) {
              ball.dx = -ball.dx; 
              bullet1 = new Bullet(bat1.x + 20, bat1.y + 40, 20);
              stage.addChild(bullet1);
              stage.addEventListener(Event.ENTER_FRAME, bullet1.Shoot);
              if (bullet1.hitTestObject(bat2)) {
                stage.removeEventListener(Event.ENTER_FRAME, bullet1.Shoot);
                stage.removeChild(bullet1);
              }
          }
          if (ball.hitTestObject(bat2)) {
              ball.dx = - ball.dx; 
              bullet2 = new Bullet(stage.stageHeight - 20, bat2.y + 40, -20);
              addChild(bullet2);
              stage.addEventListener(Event.ENTER_FRAME, bullet2.Shoot);
              if (bullet2.hitTestObject(bat1)) {
                stage.removeEventListener(Event.ENTER_FRAME, bullet2.Shoot);
                stage.removeChild(bullet2);
              }
          }                     
        }
        
            private var bat1:Bat;            
            private var bat2:Bat;
            private var ball:Ball;
            private var bullet1:Bullet;
            private var bullet2:Bullet;
            private var points1:int;
            private var points2:int;
            private var textPoints2:TextField;
            private var textPoints1:TextField;
            private var mainMenu:MainMenu;
            

    }
}
import flash.display.Graphics;
import flash.ui.ContextMenu;
import flash.display.SimpleButton;
import flash.text.Font;
import flash.text.TextFieldAutoSize;
import flash.ui.Keyboard;
import flash.display.Sprite;
import flash.events.KeyboardEvent;
import flash.events.Event;
class Bat extends Sprite {
    
    private var keys:Array;
    public function Bat (keys:Array, newx:int, newy:int){
        graphics.beginFill(0xC5803A);
        graphics.drawRect(newx,newy,20,80); 
        graphics.endFill();
        this.keys = keys;   
    }
    
    public function moveByKb (e:KeyboardEvent):void
    {        
        //graphics.clear();
        if (y < 0) y = 0;
        if (e.keyCode == keys[0]) 
        {
            if (y >= 0 && y < stage.stageHeight) y = y - 20; 
        }
        
        if (e.keyCode == keys[1]) 
        {
            if (y >= 0 && y < stage.stageHeight - 50) y = y + 20; 
        }
    }        
    
    
}
class Ball extends Sprite {
    public function Ball (){
        graphics.beginFill(0xFFFFFF);
        graphics.drawCircle(0,0, 20); 
        graphics.endFill();
           
    }    
    public var dx:int = 0;
    public var dy:int = 0;
    public function Start():void{
        x = (stage.stageWidth) / 2;
        y = (stage.stageHeight - 30) / 2;
        var n1:Number = Math.random() - 0.5;
        var n2:Number = Math.random() - 0.5;
        var sign:int = n1 > 0 ? 1 : -1;
        dx = 6 * sign;
        sign = n2 > 0 ? 1: -1;
        dy = 8 * sign;
        }
    public function Move(e:Event):void{
        x = x + dx;
        y = y + dy;
        if (x <= 0) dx = -dx;
        if (y <= 0) dy = -dy;
        if (x >= stage.stageWidth) dx = -dx;
        if (y >= stage.stageHeight - 30) dy = -dy;
        }
}

import flash.ui.Keyboard;
import flash.display.Sprite;
import flash.events.KeyboardEvent;
import flash.events.Event;
import flash.text.TextFormat;
import flash.text.TextField;
class MainMenu extends Sprite {    
    public function MainMenu (){        
        menuName = new TextField();
        menuName.defaultTextFormat = new TextFormat("Verdana", 36, 0xEDDBB4); 
        menuName.text = "PING-PONG";     
        menuName.autoSize = TextFieldAutoSize.CENTER;
        //menuName.width = 300;   
        
        start = new CustomSimpleButton();
        
    }
    public function ShowMenu():void{
        graphics.beginFill(0x2FCC6B,1);
        graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
        graphics.endFill();
        
        menuName.x = (stage.stageWidth - menuName.width) / 2;
        menuName.y = stage.stageHeight / 5;             
        addChild(menuName);
        
        start.x = (stage.stageWidth - start.width) / 2;
        start.y = stage.stageHeight / 2;
        addChild(start);
                
    }
    
    private var menuName:TextField;
    private var start:SimpleButton;
}

import flash.display.DisplayObject;
import flash.display.Shape;
import flash.display.SimpleButton;
class CustomSimpleButton extends SimpleButton {
    private var upColor:uint   = 0xFFCC00;
    private var overColor:uint = 0xCCFF00;
    private var downColor:uint = 0x00CCFF;
    private var size:uint      = 80;

    public function CustomSimpleButton() {
        downState      = new ButtonDisplayState(downColor, size);
        overState      = new ButtonDisplayState(overColor, size);
        upState        = new ButtonDisplayState(upColor, size);
        hitTestState   = new ButtonDisplayState(upColor, size * 2);
        hitTestState.x = -(size / 4);
        hitTestState.y = hitTestState.x;
        useHandCursor  = true;
    }
}

class ButtonDisplayState extends Shape {
    private var bgColor:uint;
    private var size:uint;

    public function ButtonDisplayState(bgColor:uint, size:uint) {
        this.bgColor = bgColor;
        this.size    = size;
        Draw();
    }

    private function Draw():void {
        graphics.beginFill(bgColor);
        graphics.drawRoundRect(0, 0, size + size / 2, size, 20);
        graphics.endFill();
    }
}

class Bullet extends Shape {
    private var dx:int
    public function Bullet(x:int, y:int, dx:int) {
        graphics.beginFill(0xFFFFFF);
        graphics.drawCircle(x, y, 3);
        graphics.endFill()
        //this.x = x;
        //this.y = y;
        this.dx = dx;        
    } 
    public function Shoot(e:Event):void{
        x = x + dx;
    }


    
}




