/**
 * Copyright hakerlab ( http://wonderfl.net/user/hakerlab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/sGHu
 */

// forked from tororo_zz's VG 10×10
/* ---------------------------------------------------------------------------
 * 10×10　ちょっと段差あり
 * ---------------------------------------------------------------------------
 */

/* ---------------------------------------------------------------------------
 * AsMain
 * --------------------------------------------------------------------------- */
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.utils.*;

    [SWF(frameRate="36")]
    　
    public class AsMain extends MovieClip
    {
        
        /* ---------------------------------------------------------------------------
         * AsMainParam
         * --------------------------------------------------------------------------- */
        //*--クラスとステージ関連付け
        public var main:AsMain
        public var sT:Stage = stage;
        public var baseSp:Sprite = new Sprite; //マップベース メモ：キャラクター、エフェクト、オブジェクト等
        //*----------
        
        //*--メインエンターフレム操作
        public var mainBln:Boolean = true
        //*----------
        
        //*--インターフェイスファンクション
        public var mapMake:Function
        public var mapPointer:Function
        public var fontPop:Function
        
        public var mainEF:String = "mEnterFrame"
        //*----------
        
        //*--インターフェイスオブジェクト
        public var mapObj:Object = { } //マップ管理情報格納
        public var chipObj:Object = { } //マップBitmapData格納
        public var fontObj:Object = { } //フォントBitmapData格納
        public var charaObj:Object = { } //キャラBitmapData格納
        public var noMapObj:Object = { num:1, ch: { chParty:null } } //ノーマルマップ管理情報格納 ctl:{ at:{ atType:0 }, ch:{ chType:null }
        public var atMapObj:Object = { num:3, ch: { chParty:null } }
        public var nullObj:Object = //マップ管理Null情報格納
        {
            map:null,
            poin:null,
            swap:null,
            dcost: { "1":null, "2":null },
            ctl: { num:null, ch: { chType:null } }
        }
        //*----------
        
        //*--チップサイズ
        public var chipSize:int = 32; //チップサイズ
        public var chipFont:int = 8; //フォント
        //*----------
        
        //*--全体のマップサイズ --MapAddで値の格納
        public var mapx:int;
        public var mapy:int;
        //*----------
        
        //*--マップ:標準位置修正 --MapAddで値の格納
        public var mapW:Number; //微調整値
        public var mapH:Number; //微調整値
        //*----------
        
        //*--マップポイント:標準位置修正 --MapAddで値の格納
        public var poinW:Number; //微調整値
        public var poinH:Number; //微調整値
        //*----------
        
        //*--キャラクター:標準位置修正 --MapAddで値の格納
        public var charaW:Number; //微調整値
        public var charaH:Number; //微調整値
        //*----------
        
        //*--URLの格納
        public var urlAry:Array =
        [
            "http://assets.wonderfl.net/images/related_images/c/c0/c044/c04462cf321f37db5099c8125960b8de9317fbcf", //map_chip
            "http://assets.wonderfl.net/images/related_images/a/a7/a70a/a70a6384cdd81f51123a8df8720dd180a9bf7fe3",  //Hei_hajime
            "http://assets.wonderfl.net/images/related_images/3/33/3354/3354fbc8d74aab0ba3032f3426df49ccff182545",  //Hei_aitemu
            "http://assets.wonderfl.net/images/related_images/9/99/995c/995cfa618e58ce68caa30fc8da2d25e1d2c9249d",  //Hei_ken
            "http://assets.wonderfl.net/images/related_images/f/f7/f792/f79241c9787a7d5946ee644925c82f0b93e8ec18",  //Hei_yari
            "http://assets.wonderfl.net/images/related_images/7/76/769e/769ec928983d0a9d204875bd5658e19d0bc30d15",  //Hei_yumi
            "http://assets.wonderfl.net/images/related_images/8/84/84e3/84e3d47782c8f9b65a8318fc4cb8ca0def607d77",  //Hei_kaihuku
            "http://assets.wonderfl.net/images/related_images/5/50/5059/5059707dd760a90667230577e6ea30d60031a671",  //Hei_kuroma
            "http://assets.wonderfl.net/images/related_images/1/1b/1bac/1bacd860bed37801581b4351af877428d256df67",  //Hei_kuma
            "http://assets.wonderfl.net/images/related_images/0/06/06dd/06dd326dd39ae242a60ae81f92b9b91b46826342",  //Mon_sura.gif
            "http://assets.wonderfl.net/images/related_images/4/45/45f0/45f00eaabd61b6acc29550fe9d59117acd35fca7",  //Mon_gobu.gif
            "http://assets.wonderfl.net/images/related_images/4/46/462d/462d4386fa6828d7634f7c38712eaadd7de269b9",  //Mon_morii.gif
            "http://assets.wonderfl.net/images/related_images/4/4b/4bff/4bffff602a61e2d5e9bf64cefea18a2f848b5fd2" //font_chip
        ]        
        //*----------
        
        //*--画像アクセスプロパティ
        public var bmdObj:Object = { } //一時的に読込クラスの格納
        public var heiNum:int = 8 //現在の職業数
        public var monNum:int = 3 //現在のモンスター数
        public var chNum:int = heiNum + monNum
        public var mapNum:int = 0
        public var ftNum:int = chNum + 1
        //*----------
                
        //*--繰返し使用
        public var point:Point = new Point( 0, 0 )
        public var rct:Rectangle = new Rectangle( 0, 0, 32, 32 )
        public var chbmd:BitmapData = new BitmapData( 32, 32, true, 0x00ffffff )
        //*----------
        
        /* ---------------------------------------------------------------------------
         * AsMainParamChara キャラクタープロパティアクセス関連
         * --------------------------------------------------------------------------- */
        //*--フレーム
        public var f0:int = 1
        public var f1:int = 12
        public var f2:int = f1*2
        public var f3:int = f1*3
        public var f4:int = f1*4
        //*----------
        
        //*--方向関連Array
        public var vcx:Number = 0.5; //*1フレームに進む距離
        public var vcy:Number = 0.25; //*
        public var vecx:Array = [ , 0, 1 , 0, -1 ]; //*方向情報修正値 メモ：職業によって状況確認を変えるように
        public var vecy:Array = [ , 1, 0 , -1, 0 ]; //*
        public var vecxd:Array = [ , -1, 1, 1, -1 ]; //*移動ベクトル
        public var vecyd:Array = [ , 1, 1, -1, -1 ]; //*
        //*----------
        
        //*--キャラアクションの設定
        public var acObj:Array =
        [
            [ 0 ], //0:登場
            [ f2, 1, f1, 2 ], //1:待機
            [ f2, 3, f1, 4 ], //2:移動
            [ f3, 1, f1, 2, f2, 5 ], //3:攻撃
            [ f3, 1, f1, 8, f2, 9 ], //4:死亡
            [ f3, 1, f1, 2, f2, 10 ], //5:万歳
            [ f4, 6, f2, 7 ], //6:首振
            [ f3, 1, f2, 11 ], //7:ダメージ
            [ f4, 1, f2, 4 ], //8:ジャンプ
            [ f4, 1, f2, 10 ] //9:ハイジャンプ
        ]
        //*----------
                        
        /**
         *--キャラクタープロパティ
         *
         * @param search キャラ検索範囲
         * @param jump キャラ高低差移動範囲
         * @param scLg 遠距離アクション範囲
         * @param acSh 近距離アクション範囲
         * @param scUp 上攻撃範囲
         * @param scDn 下攻撃範囲
         * @param seUp 上検索範囲
         * @param seDn 下検索範囲
         * @param name キャラタイプ名
        **/
        
        public var charaType:Array =
        [ , //1からカウントするようにする
            { serch:3, jump:1, acLg:1, acSh:1, acUp:2, acDn:-2, seUp:2, seDn:-2, name:"HAJIME" },
            { serch:3, jump:1, acLg:1, acSh:1, acUp:2, acDn:-2, seUp:2, seDn:-2, name:"AITEMU" },
            { serch:3, jump:1, acLg:1, acSh:1, acUp:2, acDn:-2, seUp:2, seDn:-2, name:"KEN" },
            { serch:3, jump:1, acLg:2, acSh:1, acUp:2, acDn:-2, seUp:2, seDn:-2, name:"YARI" },
            { serch:3, jump:1, acLg:3, acSh:2, acUp:2, acDn:-2, seUp:2, seDn:-2, name:"YUMI" },
            { serch:3, jump:1, acLg:3, acSh:1, acUp:2, acDn:-2, seUp:2, seDn:-2, name:"KAIHUKU" },
            { serch:3, jump:1, acLg:3, acSh:1, acUp:2, acDn:-2, seUp:2, seDn:-2, name:"KUROMA" },
            { serch:3, jump:1, acLg:1, acSh:1, acUp:2, acDn:-2, seUp:2, seDn:-2, name:"KUMA" },
            { serch:1, jump:1, acLg:1, acSh:1, acUp:1, acDn:-1, seUp:1, seDn:-1, name:"SURA" },
            { serch:2, jump:2, acLg:1, acSh:1, acUp:1, acDn:-1, seUp:1, seDn:-1, name:"GOBULIN" },
            { serch:3, jump:1, acLg:2, acSh:1, acUp:1, acDn:-1, seUp:1, seDn:-1, name:"MORII" }
        ]
        
        
        /* ---------------------------------------------------------------------------
         * Main コンストラクタ
         * --------------------------------------------------------------------------- */
        public function AsMain():void
        {
            main = this
            //new InfoSet( sT ); //FPS計測 メモ：不要ならなくてもよい
            //new TestTimer()
                        
            init()
        }//MIN_AS
        
        public function init():void
        {
            //*--マップベース
            sT.frameRate = 36
            sT.addChildAt( baseSp, 0);
            baseSp.addChildAt( new Sprite, 0 )
            
            //*--インターフェイスファンクション
            mapMake = new MapAdd( main ).mapMake
            mapPointer = new MapPointer( main ).mapPointer
            fontPop = new MapFontPop( main ).popFont
            
            //*--画像読込
            imgLoadStart();
        }//init
        
        /**
         *--画像読込を全て完了させる
         **/
        public function imgLoadStart():void
        {
            //*--EventGroupでイベント登録
            var eGrp:EventGroup = new EventGroup( imgLoadEnd );
            
            //*--EventGroupでイベント追加
            new LoaderMap( main, mapNum, eGrp ); //mapSet読込み
            new LoaderFont( main, ftNum, eGrp ) //font読込み
            for( var i:int= 1; i <= chNum; i++ ){ new LoaderChara( main, i, eGrp ) }  //chara読込み
        }
        
        /**
         *--画像読込がすべて完了したら　EventGroupで登録したimgLoadEndが起動
         **/
        public function imgLoadEnd( event:Event ):void
        {
            //*--インターフェイスオブジェクト:ビットマップデータを格納
            new MapAtObj( main ) //画像読込chipObjに格納
            new MapFont( main ) //画像読込fontObjに格納
            for( var i:int= 1; i <= chNum; i++ ){ charaObj[i] = bmdObj[i].retnObj(); } //画像読込chaObjに格納
            
            //*--受渡し処理が完了したので一時データ廃棄
            bmdObj = null
            urlAry = null
                        
            //*--ゲームスタート
            gameStart();
        } //init_start
        
        //パーティーの登録
        public var tpHei:CharaPartyMain
        public var tpMon:CharaPartyMain
        
        /**
         *--ゲームスタート
         **/
        public function gameStart():void
        {
            //*--マップインターフェイスの登録
            mapMake(); //マップ情報をmapObjに格納およびマップ描画
            mapPointer(); //ポインター表示およびマップパラメータ表示
            
            main.addEventListener( Event.ENTER_FRAME, mainEnterFrame );
            
            tpHei = new CharaPartyMain( main, 1 )
            tpMon = new CharaPartyMain( main, 2 )
            //*--テスト表示
            //testFtAdd()    
            testChAdd()
            testTimerAdd()
        }//gameStart
        
        //*--メインのEnterFrameからキャラクター等のモーションを更新
        public function mainEnterFrame( event:Event ):void
        {
            if ( mainBln ) { main.dispatchEvent( new Event( "mEnterFrame"))  }
        }
                    
        public function testChAdd():void
        {
            //new ArtifactCrystal( main, 2, 2 )
            testAAdd( tpHei, 1, 2, 1 )//Heiの表示
            
            testAAdd( tpHei, 5, 9, 10 )//Heiの表示
            testAAdd( tpHei, 4, 10, 10 )//Heiの表示
            
            testAAdd( tpMon, 9, 4, 4 )//Monの表示
            testAAdd( tpMon, 10, 4, 3 )//Monの表示
            testAAdd( tpMon, 11, 3, 3 )//Monの表示
        }
        
        public function testTimerAdd():void
        {
            var chTimer:Timer = new Timer( 5000 )
            chTimer.addEventListener( TimerEvent.TIMER, testCh )
            chTimer.start()
        }//testTimerAdd
        
        public function testCh( event:TimerEvent ):void
        {
            var obj:Object
            
            obj = itiObj( 8, 1 )
            testAAdd( tpHei, obj.job, obj.x, obj.y )//Heiの表示
            
            obj = itiObj( 3, 9 )
            testAAdd( tpMon, obj.job, obj.x, obj.y )//Monの表示
        }//testCh
        
        public function itiObj( na:int, nb:int ):Object
        {
            return { job:Math.random() * na + nb ,x:Math.random() * mapx + 1, y:Math.random() * mapy + 1 }
        }
        
        public function testAAdd( chParty:CharaPartyMain, id:int, xt:int,  yt:int ):void
        {
            var obj:Object = mapObj[ xt ][ yt ]
            var sptNum:int = getAdd( obj.swap.ch ).numChildren
            if( obj.ctl.num == 1 && sptNum == 0 ){ new CharaMain( main, chParty, id, xt, yt ) }
        }//testAAdd
        
        public function testFtAdd():void
        {
            var pn:Object = { sp:new Sprite, x:10, y:30 }
            sT.addChild( pn.sp );
            
            fontPop( pn.sp, "012 3456789", pn.x, pn.y + 10, "W", false);
            fontPop( pn.sp, "ABC DEFGHIJKLMNOPQRSTUVWXYZ", pn.x, pn.y + 20, "R", false);
            fontPop( pn.sp, "abc defghijklmnopqrstuvwxyz", pn.x, pn.y + 30, "G", false);
            fontPop( pn.sp, ".()[]#$%&'\"!?^+-*/=;:_<>", pn.x, pn.y + 40, "B", false );
            fontPop( pn.sp, "0123456789@0123456789", pn.x, pn.y + 50, "W", false);
        }//testFtAdd
        
        

        /* ---------------------------------------------------------------------------
         * AsMainFunction
         * --------------------------------------------------------------------------- */    
        //*--マップ位置の調整 //MapAddからのアクセス
        public function mapAdj( mapData:Object ):void
        {
            var mapP:Object = mapData["dataP"]
            
            //*--全体のマップサイズ( マップ数 )
            main.mapx = mapP.x
            main.mapy = mapP.y
            main.mapW = main.sT.stageWidth/2 - main.chipSize/2 + 24;
            main.mapH = main.sT.stageHeight/2 - main.chipSize/2 - main.mapy * 6 - 2.5;
            main.poinW = main.mapW - 9
            main.poinH = main.mapH - 9
            main.charaW = main.mapW + 0
            main.charaH = main.mapH - 8
            
        }//mapAdj
        
        //*--絶対値の最適化関数
        public function myabs( n:Number ):Number { return ( n ^ ( n >> 31)) - ( n >> 31); }//myabs
                
        //*--マップ管理情報の初期化
        public function noctl( nx:int, ny:int ):void { mapObj[ nx ][ ny ].ctl = noMapObj }//noctl
                
        //*--マップ管理情報にキャラクターを格納
        public function chctl( nx:int, ny:int, cha:CharaMain ):void { mapObj[ nx ][ ny ].ctl = { num:2, ch:cha } }//chctl
        
        //*--マップ管理情報にアーティファクトの格納 メモ：修正必要
        public function atctl( nx:int, ny:int ):void { mapObj[ nx ][ ny ].ctl = atMapObj }//atctl
        
        //*--深度指定したスクリプトにアクセス
        public function getAdd( swap:int ):Sprite { return baseSp.getChildAt( swap ) as Sprite }//getAdd
        
        //*--キャラ向きの反対方向
        public function mkbk( mk:int ):int { return ( mk <= 2 )? mk + 2 : mk - 2 }
        
        //*--マップ座標外かチェック
        public function mapOut( nx:int, ny:int ):Boolean
        {
            return ( nx <= mapx && nx > 0 && ny <= mapy && ny > 0 )? true : false
        }//mapOut
        
        //*--方向の管理情報マップオブジェ格納チェック
        public function mapCkObj( nx:int, ny:int ):Object
        {
            return ( mapOut( nx, ny ) )? mapObj[ nx ][ ny ] : nullObj //移動方向の情報
        }//mapCkObj
        
        //*--マップ重み付け
        public function mapDcost( cha:CharaMain, bln:Boolean ):void
        {
            var mk:int = mkbk( cha.muki ); //進行方向の反対側はコスト低
            var rnCost:int = cha._LV
            var myCost:int = rnCost + 1
            var party:int = cha.chParty
            
            mapObj[ cha.xv ][ cha.yv ].dcost[ party ] += ( bln )? myCost: -myCost
            
            for ( var i:int = 1; i <= 4; i++)
            {
                if ( i == mk ) { continue }
                var obj:Object = mapCkObj( cha.xv + vecx[i], cha.yv + vecy[i] )
                if ( obj.map != null ) { obj.dcost[party] += ( bln )? rnCost: -rnCost }
            }
        }//mapDcost
        
        //*--mukiの特定 キャラクターの方向確範囲定計算
        public function mkSc( tg:CharaMain, cha:CharaMain ):int
        {
            var sx:int = tg.xv - cha.xv
            var sy:int = tg.yv - cha.yv
            var mk:int = cha.muki
            
            switch( true )
            {                
                case sx == 0 : return ( sy > 0 )? 1 : 3
                case sy == 0 : return ( sx > 0 )? 2 : 4
                
                case sx > 0 && sy > 0 : return ( myabs( sx ) > myabs( sy ) || mk == 2 )? 2 : 1
                case sx > 0 && sy < 0 : return ( myabs( sx ) > myabs( sy ) || mk == 2 )? 2 : 3
                case sx < 0 && sy < 0 : return ( myabs( sx ) > myabs( sy ) || mk == 4 )? 4 : 3
                case sx < 0 && sy > 0 : return ( myabs( sx ) > myabs( sy ) || mk == 4 )? 4 : 1
            }
                        
            return 0
        }//mkSc
        
    }//class Main
}
import flash.utils.ObjectInput;//package


/* ---------------------------------------------------------------------------
 * LoaderChara
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    
    /**-public**/ class LoaderChara extends Bitmap
    {
        public var main:AsMain;
        public var bmdObj:Object = { }
        public var loaderA:Loader = new Loader();
        public var loaderB:Loader = new Loader();
        public var bmdc:BitmapData//雛形コピー用
        public var chip:int;
        
        public function LoaderChara( _main:AsMain, num:int, eGrp:EventGroup ):void
        {
            main = _main
            chip = main.chipSize
            bmdc = new BitmapData(chip, chip, true, 0xffffffff);//雛形コピー用
            
            main.bmdObj[num] = this
            
            eGrp.addEvent(this, Event.COMPLETE);
          
            loaderA.load( new URLRequest( main.urlAry[num] ) );
            loaderA.contentLoaderInfo.addEventListener(Event.COMPLETE, initHandler);
            

        }//LoaderMap
        
        private function initHandler(event:Event):void
        {    
            loaderB.contentLoaderInfo.addEventListener(Event.INIT, completeHandler);
            loaderB.loadBytes(loaderA.contentLoaderInfo.bytes);
        }//initHandler
        
        public function completeHandler( event:Event ):void
        {
            var num:int
            
            var loadimg:Loader = event.currentTarget.loader;
            var bmp:Bitmap = new Bitmap();
            var bd:BitmapData = new BitmapData(loadimg.width, loadimg.height, false);
            bd.draw(loadimg);
            bmp.bitmapData = bd
                        
            for ( var i:int = 0; i < 4; i++ ) //方向番号　1～4
            {
                var h:int = i + 1
                bmdObj[h] = { }
                for ( var v:int = 0; v < 11; v++ ) //モーション番号　1～11
                {
                    var w:int = v + 1
                    bmdObj[h][w] = bmpch( bmp, v, i ); //読込んだ画像をBitmapDataに変換
                }
            }
            
            dispatchEvent(new Event(Event.COMPLETE));
            
        }//completeHandler
        
        /**-ビットマップデータ切取
         * @param tage　読込んだBitmap
         * @param v　X軸修正値
         * @param i　Y軸修正値**/
        public function bmpch(tage:Bitmap, w:int = 0, h:int = 0):BitmapData
        {

            var tagebmd:BitmapData = tage.bitmapData;
            var clipbmd:BitmapData = bmdc.clone()
            clipbmd.copyPixels( tagebmd, tagebmd.rect, new Point( ( -chip) * w, ( -chip) * h ) );//clipbmdに描画
            clipbmd.threshold(clipbmd, clipbmd.rect, new Point(), "==", 0xFFFFFFFF, 0x0, 0x00FFFFFF);//透過処理        

            return clipbmd
        }//bmpch

        public function retnObj():Object
        {
            return bmdObj;
        }//completeHandler
        
    }//class LoaderMap
//}package


/* ---------------------------------------------------------------------------
 * LoaderFont
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    
    /**-public**/ class LoaderFont extends Bitmap
    {
        public var main:AsMain;
        public var bmdObj:Object = { }
        public var loaderA:Loader = new Loader();
        public var loaderB:Loader = new Loader();
        public var bmdc:BitmapData//雛形コピー用
        public var chip:int;
        
        public function LoaderFont( _main:AsMain, num:int, eGrp:EventGroup ):void
        {
            main = _main
            chip = main.chipFont
            bmdc = new BitmapData(chip, chip, true, 0xffffffff);//雛形コピー用
            
            main.bmdObj[num] = this
            
            eGrp.addEvent(this, Event.COMPLETE);
          
            loaderA.load( new URLRequest( main.urlAry[num] ) );
            loaderA.contentLoaderInfo.addEventListener(Event.COMPLETE, initHandler);
            

        }//LoaderMap
        
        private function initHandler(event:Event):void
        {    
            loaderB.contentLoaderInfo.addEventListener(Event.INIT, completeHandler);
            loaderB.loadBytes(loaderA.contentLoaderInfo.bytes);
        }//initHandler
        
        public function completeHandler( event:Event ):void
        {
            var num:int
            
            var loadimg:Loader = event.currentTarget.loader;
            var bmp:Bitmap = new Bitmap();
            var bd:BitmapData = new BitmapData(loadimg.width, loadimg.height, false);
            bd.draw(loadimg);
            bmp.bitmapData = bd
                        
            for ( var i:int = 0; i < 6; i++ ) //方向番号　1～4
            {
                for ( var v:int = 0; v < 16; v++ ) //モーション番号　1～11
                {
                    bmdObj[num++] = bmpch( bmp, v, i ); //読込んだ画像をBitmapDataに変換
                }
            }
            
            dispatchEvent(new Event(Event.COMPLETE));
            
        }//completeHandler
        
        /**-ビットマップデータ切取
         * @param tage　読込んだBitmap
         * @param v　X軸修正値
         * @param i　Y軸修正値**/
        public function bmpch(tage:Bitmap, w:int = 0, h:int = 0):BitmapData
        {

            var tagebmd:BitmapData = tage.bitmapData;
            var clipbmd:BitmapData = bmdc.clone()
            clipbmd.copyPixels( tagebmd, tagebmd.rect, new Point( ( -chip) * w, ( -chip) * h ) );//clipbmdに描画
            clipbmd.threshold(clipbmd, clipbmd.rect, new Point(), "==", 0xFFFFFFFF, 0x0, 0x00FFFFFF);//透過処理        

            return clipbmd
        }//bmpch

        public function retnObj():Object
        {
            return bmdObj;
        }//completeHandler
        
    }//class LoaderMap
//}package


/* ---------------------------------------------------------------------------
 * LoaderMap
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    
    /**-public**/ class LoaderMap extends Bitmap
    {
        public var main:AsMain;
        public var bmdObj:Object = { }
        public var loaderA:Loader = new Loader();
        public var loaderB:Loader = new Loader();
        public var bmdc:BitmapData//雛形コピー用
        public var chip:int;
        
        public function LoaderMap( _main:AsMain, num:int, eGrp:EventGroup ):void
        {
            main = _main
            chip = main.chipSize
            bmdc = new BitmapData(chip, chip, true, 0xffffffff);//雛形コピー用
            
            main.bmdObj[num] = this
            
            eGrp.addEvent(this, Event.COMPLETE);
          
            loaderA.load( new URLRequest( main.urlAry[num] ) );
            loaderA.contentLoaderInfo.addEventListener(Event.COMPLETE, initHandler);
            

        }//LoaderMap
        
        private function initHandler(event:Event):void
        {    
            loaderB.contentLoaderInfo.addEventListener(Event.INIT, completeHandler);
            loaderB.loadBytes(loaderA.contentLoaderInfo.bytes);
        }//initHandler
        
        public function completeHandler( event:Event ):void
        {
            var num:int

            var loadimg:Loader = event.currentTarget.loader;
            var bmp:Bitmap = new Bitmap();
            var bd:BitmapData = new BitmapData(loadimg.width, loadimg.height, false);
            bd.draw(loadimg);
            bmp.bitmapData = bd
            
            for ( var i:int = 0; i < 9; i++ ) //方向番号　1～4
            {
                for ( var v:int = 0; v < 6; v++ ) //モーション番号　1～11
                {
                    bmdObj[num++] = bmpch( bmp, v, i ); //読込んだ画像をBitmapDataに変換
                }
            }

            dispatchEvent(new Event(Event.COMPLETE));
            
        }//completeHandler
        
        /**-ビットマップデータ切取
         * @param tage　読込んだBitmap
         * @param v　X軸修正値
         * @param i　Y軸修正値**/
        public function bmpch(tage:Bitmap, w:int = 0, h:int = 0):BitmapData
        {

            var tagebmd:BitmapData = tage.bitmapData;
            var clipbmd:BitmapData = bmdc.clone()
            clipbmd.copyPixels( tagebmd, tagebmd.rect, new Point( ( -chip) * w, ( -chip) * h ) );//clipbmdに描画
            clipbmd.threshold(clipbmd, clipbmd.rect, new Point(), "==", 0xFFFFFFFF, 0x0, 0x00FFFFFF);//透過処理        

            return clipbmd
        }//bmpch

        public function retnObj():Object
        {
            return bmdObj;
        }//completeHandler
        
    }//class LoaderMap
//}package


/* ---------------------------------------------------------------------------
 * EventGroup
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.events.EventDispatcher;
    import flash.events.Event;
    
    /**-public**/ class EventGroup extends EventDispatcher
    {
        private var eventCount:uint;
        
        /**-コンストラクタ
         * @param func　DispatchEventで起動させる関数**/
        public function EventGroup( func:Function ):void
        {
            this.addEventListener(Event.COMPLETE, func);
        }//EventGroup
        
        /**-イベント追加
         * @param target　イベント追加するオブジェクト
         * @param type　イベント追加するイベント名**/
        public function addEvent( target:EventDispatcher, type:String ) : void
        {
            target.addEventListener(type, onEvent);
            eventCount++;
        }//addEvent
        
        /**-イベント発生**/
        private function onEvent( event:* ):void
        {
            event.target.removeEventListener( event.type, onEvent );
            eventCount--;
            if (eventCount == 0)
            {
                dispatchEvent(new Event(Event.COMPLETE));//グループイベント完了
            }
        }//onEvent
    }//class EventGroup
//}package


/* ---------------------------------------------------------------------------
 * CharaMain
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    import flash.events.*;
    
    /**-public**/ class CharaMain extends Bitmap
    {
        /* ---------------------------------------------------------------------------
         * CharaParam
         * --------------------------------------------------------------------------- */
        
        //*--クラスとステージ関連付け
        protected var main:AsMain
        protected var chara:CharaMain
        protected var chpm:CharaPartyMain
        protected var chStatus:CharaStatus
        protected var baseSp:Sprite
        //*----------
        
        //*--位置情報
        public var xv:int //X軸
        public var yv:int //Y軸
        public var zv:int //高低
        public var sv:int //深度
        //*----------
        
        //*--キャラタイプ関連
        public var chSp:Sprite //キャラ表示アクセス
        public var chTyName:String //キャラ職業名
        public var chType:int //キャラタイプ
        public var chParty:int //キャラパーティー
        public var chTarget:int //ターゲット
        public var chDcolor:String //ダメージカラー
        public var chBmdObj:Object //キャラを表示するBitmapData情報
        //*----------
        
        //*--キャラステータス
        public var _LV:int
        public var _EXP:int
        public var maxHP:int
        public var maxSP:int
        public var _HP:int //Health Points
        public var _SP:int //Spirit Points
        public var _AT:int //Attack
        public var _FH:int //Faith
        public var _DF:int //Defense
        public var _KE:int //Knowledge
        //*----------
        
        //*--キャラアクションフラグ関連
        public var chSearch:int //キャラ検索範囲
        public var chJump:int //ジャンプ範囲
        public var chAcLg:int //遠距離アクション範囲
        public var chAcSh:int //近距離アクション範囲
        public var chAcUp:int //上高低アクション範囲
        public var chAcDn:int //下高低アクション範囲
        public var chSeUp:int //上高低検索範囲
        public var chSeDn:int //下高低検索範囲
        public var chStObj:Object//ターゲットに対してのアクション優先順位
        //*----------
        
        //*--アクション関連
        public var func:Function //アクション関数起動用
        public var fre:int //Frameカウント用        
        public var muki:int //方向　1: 左下 ; 2: 右下 ; 3: 右上 ; 4: 左上 
        public var mofun:int //モーション　1:待機 ; 2:移動 ; 3:攻撃 ; 4:死亡 ; 5:万歳 ; 6:首振 ; 7:ダメージ
        public var moac:int //モーションオブジェナンバー 1:待機 ; 2:移動 ; 3:攻撃 ; 4:死亡 ; 5:万歳 ; 6:首振 ; 7:ダメージ ; 8:ジャンプ
        //*----------
        
        //*--キャラモーション用プロパティ
        public var chShAry:Array = [ ] //サーチ用
        public var chMovAry:Array = [ ]
        public var chRoot:Array = [ ] //A*　アルゴリズム用
        public var chMovSet:Array = [ ]//移動用数値格納
        public var chAcAry:Array = [ ]//キャラモーションの複製を格納
        public var chAcNum:int //キャラクターモーションナンバー
        public var chAcCut:int //画像変換のタイミング
        public var chAcEnd:int //フレームエンド
        public var chDei:Boolean //死亡モーションの時の防止処理
        //*----------
                
        /* ---------------------------------------------------------------------------
         * CharaMotion
         * --------------------------------------------------------------------------- */
        //*--functionの格納用
        public var moAry:Array =
        [
            chStart, //登場 0
            chCut, //待機 1
            chMoving, //移動 2
            chCut, //攻撃 3
            chDeath, //死亡 4
            chCut, //万歳 5
            chCut, //首振 6
            chCut //ダメージ 7
        ]
        
        //*--コントラクタ
        public function CharaMotion():void { }//CharaMotion
                
        //*--モーションを変えて行動を変換の初期化
        public function charaMotion():void
        {
            fre = 0
            chAcNum = 1
            
            func = moAry[ mofun ];
            
            chAcAry = main.acObj[ moac ] //acObjのmofunを格納
            chAcEnd = chAcAry[ 0 ]
            
            if ( chAcEnd != 0 ) { chBmdCh() } //モーションエンドフレーム値チェック falseならstartC関数
        }//charaMotion
        
        //*--キャラクターモーション代入 特定フレームでBitmapDataをキャラに代入
        public function chCut():void
        {            
            if ( fre == chAcCut ){ chBmdCh() };
            if ( fre == chAcEnd && !chDei ) { chara.charaMoSelect() }
        }//chCut
        
        //*--キャラの配列を代入
        public function chBmdCh():void
        {
            chara.bitmapData = chBmdObj[muki][ chAcAry[ chAcNum++ ] ];
            chAcCut = chAcAry[ chAcNum++ ]; //次の特定フレームを指定
        }//chBmdCh
                
        //*--登場 ピクセルディゾルブ
        public function chStart():void
        {
            chAcEnd = chara.bitmapData.pixelDissolve( chBmdObj[muki][10] , main.rct, main.point , chAcEnd , 32 );
            if ( fre == main.f3 ) { chara.charaMoSelect() }
        }//chStart
        
        //*--キャラの移動モーション処理 深度変換
        public function chMoving():void
        {
            var obj:Object = chMovSet[0]
            if ( fre == obj.fre ) { baseSp.swapChildrenAt( baseSp.getChildIndex( chSp ), sv ); } //深度変換 移動前の深度から移動後の深度に変換
            if ( fre >= obj.st ) { chMoveXY( obj ) }
            chCut();
        }//chMoving
                
        //*--キャラ座標変換
        public function chMoveXY( obj:Object ):void
        {
            if ( fre > obj.en ) { chMovSet.shift(); return };
            chara.x += obj.xm;
            chara.y += obj.ym;
            chara.dispatchEvent( new Event( "MoveXY")) //キャラ座標変動のイベント登録　HPバーの移動
        }//chMoveXY
        
        //*--キャラ削除 移動中の死亡モーションを考える
        public function chDeath():void
        {
            chCut();
            if ( fre == main.f3 ) { chara.charaRemve() } //死亡モーションの終了フレームかチェック
        }//chDeath
        
        
        /* ---------------------------------------------------------------------------
         * CharaFunction
         * --------------------------------------------------------------------------- */
        /**
         *--キャラアクション系フラグチェック一覧
         **/
         //*--ジャンプチェック
        public function ckJump( gabs:int ):Boolean { return chJump >= gabs }
        
        //*--アクション距離チェック
        public function ckAcDis( hc:int ):Boolean { return chAcLg >= hc && hc >= chAcSh }
        
        //*--アクション高低チェック
        public function ckAcGap( gp:int ):Boolean { return chAcUp >= gp && gp >= chAcDn }
        
        //*--検索高低チェック
        public function chSeGap( gp:int ):Boolean { return chSeUp >= gp && gp >= chSeDn }
        
        /**
         *--CharaMoSelect関数
         **/    
        //*--移動タイミングを格納 CharaMoSelect.charaMoveでchMovSetに格納
        public function mov( _st:int, _en:int, _xm:Number, _ym:Number ,_fre:int):Object
        {
            return { st:_st, en:_en, xm:_xm, ym:_ym, fre:_fre }
        }//mov
        
        //*--A* 新しいノードをオブジェクトで返す CharaMoSelect.chAstarで使用
        public function node( ns:int, nc:int, nh:int, nx:int, ny:int, nz:int, ng:int, nd:int, np:Object ):Object
        {            
            return { s:ns, c:nc, h:nh, ax:nx, ay:ny, az:nz, g:ng, ad:nd, ap:np }
        }//node
        
        //*--コストの計算
        public function mkch( mk:int ):void
        {
            main.mapDcost( chara, false )
            muki = mk
            main.mapDcost( chara, true )
        }
        
        //*--モーションファンクションとモーションナンバーを変換
        public function moch( int0:int ):void
        {
            moac = mofun = int0
        }//moch
        
        //*--ランダムでモーション決定　メモ：もっと簡略化するように
        public function randomMotion():int
        {
            var m:int = Math.random() * 100
            //1:待機 ; 2:移動 ; 3:攻撃 ; 4:死亡 ; 5:万歳 ; 6:首振 ; 7:ダメージ; 8:ジャンプ 8は使わない
            switch( true )
            {
                case 80 >= m && m >= 41: return 2
                case 100 >= m && m >= 81: return 6
            }
            
            return 1 //どれにも当てはまらなければ1:待機
            
        }//randomMotion
        
        //*--方向管理のチェック
        public function returnCk( nx:int, ny:int, nz:int, tgp:Boolean = true ):Object
        {            
            var obj:Object = main.mapCkObj( nx, ny ) //方向の管理情報
            if ( obj.map == null ) { return { re:1 } } //マップ座標外かチェック
            
            var dcost:int = obj.dcost[ chTarget ]
            var ngv:int = obj.map.z - nz
            var ngabs:int = main.myabs( ngv )
            var sptNum:int = ( tgp )? main.getAdd( obj.swap.ch ).numChildren : 0 //移動方向のキャラスクリプトにアクセス
            
            if ( obj.ctl.num != 1 || sptNum != 0 || dcost >= 3 ) { return { re:2 }  } //移動できるかチェック
            if ( !ckJump( ngabs ) ) { return { re:3 }  }  //移動できる高低差かチェック
            
            var reobj:Object = { re:0, x:obj.map.x, y:obj.map.y, z:obj.map.z, gv:ngv, gabs:ngabs, swap:obj.swap }
            return reobj
        }
        
        /**
         *--A* アルゴリズム 経路検索    
        **/
        public function chAstar( endx:int, endy:int, bln:Boolean = true ):void
        {
            var opL:Array = [ node( 0, 0, 0, xv, yv, zv, 0, 0, 0 ) ] //openList キャラ位置nodeを初めに格納
            var clL:Array = [ ] //closeList
            var opBln:Boolean
            
            while( opL.length > 0 )//Openリストが空かチェック
            {
                var nObj:Object = opL.sortOn("s", Array.NUMERIC).shift(); //scoreが最小を先頭に
                
                if ( !bln ) { if ( endx == nObj.ax && endy == nObj.ay ) { opBln = true; break; } } //ﾀｹﾞﾎﾟｲﾝﾀｰで位置指定された場合に判定するようにできないか？
                if ( bln ) { if ( ckAcDis( nObj.h ) && ckAcGap( nObj.g ) ) { opBln = true; break; } }//アクションできる範囲、高低差にいるなら検索終了
                if ( nObj.c > 50 ) { opL = [ ]; break; } //無限ループ回避 trace( "1000");
                
                clL.push( nObj ); //openの検索が終了したのでCloseリストへ移す
                
                var fObj:Object = { c:nObj.c + 1, cl:clL.length, op:opL.length }
                
                rn:for( var nd:int = 1; nd <= 4; nd++ )//四方を調べる
                {                    
                    var obj:Object = returnCk( nObj.ax + main.vecx[ nd ], nObj.ay + main.vecy[ nd ], nObj.az, false )
                    if ( obj.re != 0 ) { continue rn }
                    
                    for ( var i:int = 0; i < fObj.op; i++ ) { if ( opL[i].ax == obj.x && opL[i].ay == obj.y ) { continue rn } } //オープンリストに同じ値があるかチェック
                    for ( var j:int = 0; j < fObj.cl; j++ ) { if ( clL[j].ax == obj.x && clL[j].ay == obj.y ) { continue rn } } //クローズリストに同じ値があるかチェック
                    
                    var heuri:int = main.myabs( endx - obj.x ) + main.myabs( endy - obj.y );
                    var score:int = fObj.c + heuri
                    
                    opL.push( node( score, fObj.c, heuri, obj.x, obj.y, obj.z, obj.gv, nd, nObj ) ) //オープンリストに格納
                }
            }//aStar
            
            if ( nObj.ap == 0 ) { return }
            if ( opL.length == 0 && !opBln ) { return }
            while ( nObj.ap != 0 ) { chRoot.unshift( nObj.ad ); nObj = nObj.ap;  } //親リンクをたどってaRootに入れる
            
            //main.ｆontPop( chSp, "!", chara.x + 12, chara.y, "B");
            //trace( "opLn: " + opL.length, "clLn: " + clL.length, "aRoot: " + chRoot.length, "[ " + chRoot + " ]"  )
        }//aStar
        

        /* ---------------------------------------------------------------------------
         * CharaMoSelect
         * --------------------------------------------------------------------------- */
        /**
         *--キャラモーション選択処理
         **/
        public function charaMoSelect():void
        {            
            charaSearch() //標的処理確認
            
            charaSearchCheck() //charaSearchのチェック
            charaMove() //移動処理
            
            charaMotion() //モーション変換起動 CharaMotion.cMotion
        }//moveSelect
        
        /**
         *--標的情報の確認//もう少し見やすくできないか？
         **/
        public function charaSearch():void
        {
            var mkCk:int = main.mkbk( muki ); //後ろの敵は見れないようにする
            
            chShAry = [ ]
            chMovAry = [ ]
            
            for ( var i:int = 1; i <= chSearch; i++ )
            {
                var xt:int = 0
                var yt:int = i
                var inj:Object = { 1: i, 2: i * 2, 3: i * 3, 4: i * 4 }
                
                rn:for( var v:int= 0; v < inj[4]; v++) //左下から メモ：もう少し改良が必要
                {
                    var obj:Object = main.mapCkObj( xv + xt, yv + yt )
                        
                    if ( v < inj[1] ) { xt++ } else if ( v < inj[3] ) { xt-- } else { xt++ }
                    if ( v < inj[2] ) { yt-- } else { yt++ }
                    
                    if ( obj.ctl.num == 1 && chShAry.length == 0 ) { chMovAry.push( { mx:obj.map.x, my:obj.map.y } ) }
                    if ( obj.ctl.num != 2) { continue rn }
                    
                    var tage:CharaMain = obj.ctl.ch //方向のキャラ管理情報
                    if ( tage.chParty != chTarget ) { continue rn } //標的対象か確認
                    
                    var gv:int = tage.zv - zv //ターゲットとの高低差
                    if ( !chSeGap( gv ) ) { continue rn } //視界高低差範囲か確認
                                        
                    var mk:int = main.mkSc( tage, chara )//サーチ範囲上のターゲット方向
                    if ( mofun != 6 && mkCk == mk ) { continue rn } //背後サーチの除外 首振りの場合は後ろも見れる
                    
                    chShAry.push( { tage:tage, hc:i, gp:gv, sot:tage[chStObj.str] } ); //chShAryに格納
                }
            }
            
            chpm.serchJointly( chara ) //視界の共有
            //if ( chParty == 1 && chShAry.length != 0 ) trace( chTyName, chShAry )
        }//charaSearch
                        
        public function charaSearchCheck():void
        {
            if ( chShAry.length == 0 ) { charaMofun() }    else { charaDecision() }
        }
        
        //*--mofunをランダムで変換する メモ：アクションごとの確立で変換できるように改善要：moveCharaは職業によって移動癖を作る
        public function charaMofun():void
        {
            moch( randomMotion() )  //moch( 1 )
            
            if ( mofun == 2 )
            {
                var mlen:int = chMovAry.length
                if ( mlen == 0 ) { moch( 1 ); return }
                
                var mInt:int = Math.random() * mlen
                var obj:Object = chMovAry[ mInt ]
                chAstar( obj.mx, obj.my, false )
            }
            
        }//charaMofun
                
        //*--charaSearchCk サーチ結果からの行動決定
        public function charaDecision():void
        {
            //*--ﾋｭｰﾘｽﾃｨｯｸとﾀｹﾞHPでｿｰﾄ
            var sh:Object = chShAry.sortOn( [ "hc", "sot" ], [ Array.NUMERIC, chStObj.num ] )//ターゲット決定方法の改善必要
            var shLen:int = sh.length
            var ary:Array = [ ]
            
            //*--囲まれているか確認　改善必要　移動できない場所も含んだ場合を考える ｴｽｹｰﾌﾟ処理は未完成
            for ( var i:int = 0; i < shLen; i++ ) { if ( sh[i].hc == 1 ) { ary.push( sh[i].mk ); } }
            
            if ( ary.length != 3 ) { chAcArea() } else { chEscape( ary ) }
            
        }//charaSearchCk
        
        //*--アクション範囲判定
        public function chAcArea():void
        {
            var tg:Object = chShAry[0]
            var acBln:Boolean = ( ckAcDis( tg.hc ) && ckAcGap( tg.gp ) )
            
            if ( acBln ) { chAction( tg.tage ); } //ターゲット相手に処理を移行
            if ( !acBln && chRoot.length == 0 ) { chAstar( tg.tage.xv, tg.tage.yv ) }
            
        }//chPriorAction
        
        //*--エスケープ判定
        public function chEscape( ary:Array ):void
        {
            for ( var j:int = 1; j <= 4; j++ )
            {
                if ( ary.indexOf( j ) == -1 )
                {                    
                    if ( returnCk( xv + main.vecx[ j ], yv + main.vecy[ j ], zv ) != 0 ) { chAcArea(); return }
                    mkch( j ); moch( 2 )
                }
            }
        }//chEscape
        
        /**
         *--攻撃処理　ターゲット相手からの処理 chActionの種類は職業によって違うので新しいクラスを作るように
        **/        
        public function chAction( tg:CharaMain ):void
        {
            chRoot = [ ]; mkch( main.mkSc( tg, chara ) ); moch( 3 );
            
            if ( tg.mofun == 0 ) { return } //攻撃対象が登場モーションかチェック
            if ( tg.mofun == 2 ) { moch( 1 ); return } //攻撃対象が移動モーションかチェック
            if ( tg._HP <= 0 ) { moch( 5 ); return } //攻撃対象のHPが０なら消去処理
            
            var dame:int = ( Math.random() * _AT + _AT / 2 ) - ( Math.random() * tg._DF + tg._DF / 2 ) //ステータスの改善が必要　high と　row　を作る
            
            tg._HP -= dame
            
            tg.dispatchEvent( new Event( "SteChange")) //キャラステータスチェンジのイベント登録
            main.fontPop( tg.chSp, String( dame ), tg.x + 12, tg.y, chStatus.fdclr[ tg.chParty ] );
            if ( tg._HP > 0 || tg.chDei ) { return } //攻撃対象のHPが０なら消去処理 モーション変換起動 CharaMotion.cMotion
            
            charaLvUp1()
            
            tg.chDei = true; tg.moch( 4 ); tg.charaMotion();
        }//chActage
        
        public function charaLvUp1():void
        {
            _LV++
            _AT++
            maxHP++
            _HP += 10
            if ( _HP >= maxHP ) { _HP = maxHP }
            dispatchEvent( new Event( "SteChange"))
        }
        
        /**
         *--キャラクターの移動処理 //壁にずっと向かう現象を解消しないとだめ
        **/
        public function charaMove():void
        {
            if ( chRoot.length != 0 ) { mkch( chRoot.shift() ); moch( 2 ) } //chRootが空でないかチェック
            if ( mofun != 2 ) { return } //モーションが移動かチェック
                        
            var obj:Object = returnCk( xv + main.vecx[ muki ], yv + main.vecy[ muki ], zv )
            if ( obj.re != 0 ) { if ( obj.re == 2 ) { chRoot = [ ] }; moch( 1 ); return; }
            
            main.noctl( xv, yv ) //現在の管理情報をノーマルにする
            main.mapDcost( chara, false )//test--map重み
            
            //*--位置情報の修正
            xv = obj.x;
            yv = obj.y;
            zv = obj.z;
            sv = obj.swap.ch //深度修正値を格納 
                        
            main.chctl( xv, yv, chara ) //移動先の管理情報をキャラにする
            main.mapDcost( chara, true )//test--map重み            
            
            var nx:Number = main.vcx * main.vecxd[ muki ]
            var ny:Number = main.vcy * main.vecyd[ muki ]
            if ( obj.gv == 0 ) { chMovSet = [ mov( main.f0, main.f2, nx, ny, ( muki <= 2 )? main.f0 : main.f2 ) ]; return }
            
            //*--高低差が0以外の処理　メモもう少し改善要
            var xt:Number = main.vcx * obj.gabs; //ジャンプ修正X値
            var yt:Number = main.vcy * obj.gabs; //ジャンプ修正Y値
            var nObj:Object = ( obj.gv >= 0 )? { f:ny - xt, b:ny + yt  } : { f:ny - yt, b:ny + xt  }
            var sfre:int = ( muki <= 2 )? main.f0 : main.f4 //mukiが1or2ならf0 3or4ならfreEnd
            moac = ( obj.gabs == 1 )? 8 : 9
            chMovSet = [ mov( main.f2, main.f3 - 1, nx, nObj.f, sfre ), mov( main.f3, main.f4, nx, nObj.b, sfre ) ]
        }//charaMoveCk
        
        
        /* ---------------------------------------------------------------------------
         * CharaMain
         * --------------------------------------------------------------------------- */
        /**
         *--コンストラクタ
         *
         * @param _main AS_MINプロパティアクセス用
         * @param typeStr キャラタイプ typeStr:String, 
         * @param typeNum キャラナンバー
         * @param xk 初期マップX軸値
         * @param yk 初期マップY軸値
         **/
        public function CharaMain( _main:AsMain, chPmain:CharaPartyMain, chId:int, xk:int, yk:int ):void
        {
            var objMap:Object = _main.mapObj[ xk ][ yk ] //mapObj関連付け            
            var objCh:Object = _main.charaType[ chId ] //charaType関連付け
            
            //*--クラスとステージ関連
            main = _main
            chara = this
            chpm = chPmain
            baseSp = main.baseSp
            chStatus = new CharaStatus( chara ) //HPバーの表示
            
            //*--位置情報
            xv = objMap.map.x
            yv = objMap.map.y
            zv = objMap.map.z
            sv = objMap.swap.ch
                        
            //*--キャラタイプ関連 メモ：職業によってポイントが違ようにしよう
            chSp = main.getAdd( sv ) //深度指定した空のスクリプトにアクセス
            chTyName = objCh.name //キャラ名
            chType = chId //キャラタイプ
            chParty = chpm.partyId //キャラパーティー
            chTarget = ( chpm.partyId == 1 )? 2 : 1 //ターゲット
            
            chBmdObj = main.charaObj[ chType ] //キャラを表示するBitmapData情報
            chDcolor = objCh.dclr //キャラダメージ時の色
            
            //*--キャラステータス
            _LV = 1
            _EXP = 0
            _HP = maxHP = Math.random() * 10 + 30
            _SP = maxSP = 0
            _AT = 5 //Math.random() * 3 + 1 //( chType == "Hei")? 3 
            _FH = 0
            _DF = 2
            _KE = 0
            
            //*--キャラキャラアクションフラグ関連
            chSearch = objCh.serch //キャラ検索範囲 メモ：キャラごとにサーチ方法の変化を考える
            chJump = objCh.jump //ジャンプ範囲
            chAcLg = objCh.acLg //遠距離アクション範囲
            chAcSh = objCh.acSh //近距離アクション範囲
            chAcUp = objCh.acUp //上アクション範囲
            chAcDn = objCh.acDn //下アクション範囲
            chSeUp = objCh.seUp //上検索範囲
            chSeDn = objCh.seDn //下検索範囲
            chStObj = { str:"_HP", num:Array.NUMERIC } //ターゲットに対してのアクション優先順位
            
            //*--キャラ位置
            chara.bitmapData = main.chbmd.clone()
            chara.x = objMap.poin.w + main.charaW;
            chara.y = objMap.poin.h + main.charaH - zv * 3;
            muki = 1
            
            //*--キャラ行動起動
            charaAdd()
        }//CharaHei
        
        /**
         *--キャラデータ表示
         **/
        public function charaAdd():void
        {
            chara.dispatchEvent( new Event( "Add")) //キャラ表示のイベント登録
            
            chpm.chpEntry( chara ) //パーティの登録
            
            main.chctl( xv, yv, chara ) //キャラクター　マップ情報に収納しておく    
            main.mapDcost( chara, true )//test--map重み            
            
            main.addEventListener( main.mainEF, chEnterFrame );
            chSp.addChild( chara )
            charaMotion() //初期モーション格納 CharaMotion.charaMotion
        }//charaAdd
        
        /**
         *--キャラデータ削除　CharaMotion.deathMoからのアクセス
         **/
        public function charaRemve( ):void //bln:Boolean ):void
        {            
            chara.dispatchEvent( new Event( "Remove")) //キャラ削除のイベント登録
            
            chpm.chpCancell( chara ) //パーティの解除
            
            main.noctl( xv, yv ) //管理情報をノーマルマップにする
            main.mapDcost( chara, false )//test--map重み
            
            main.removeEventListener( main.mainEF, chEnterFrame )
            chSp.removeChild( chara )
            chara = null
        }//charaRemve
        
        /**
         *--func関数に格納したしたモーションを起動 CharaMotion.charaMotionで初期化
         **/
        public function chEnterFrame( event:Event ):void
        {
            func(); fre++
        }//chEnterFrame
    }//class CharaMain
//}package


/* ---------------------------------------------------------------------------
 * CharaStatus
 * --------------------------------------------------------------------------- */
//package
//{

    /**-public**/ class CharaStatus extends Sprite
    {

        public var ch:CharaMain
        public var sta:CharaStatus
        public var barBmp:Bitmap
        
        public var fdclr:Object =
        {
            1:"R",
            2:"W"
        }
        
        public var bclr:Object =
        {
            Box:0x0000000,
            1: { bar:0xff0064FF, front:0xff6482FA, rest:0xff000096 },
            2: { bar:0xffFF6400, front:0xffFA8264, rest:0xff960000 }    
        }
                
        /**
         *--コントラクタ HPバーの初期設定
        **/

        public function CharaStatus( chara:CharaMain ):void
        {
            sta = this
            ch = chara
            
            ch.addEventListener( "Add", staAdd )
            ch.addEventListener( "Remove", staRemove )
            ch.addEventListener( "MoveXY", staMove )
            ch.addEventListener( "SteChange", steChBar )
        }//Charastatus
        
        //*--HPバー表示
        public function staAdd( event:Event ):void
        {
            var obj:Object = { w:[ 0, 0, 11, 11], h:[ 0, 3, 0, 3 ] }
            
            
            barBmp = new Bitmap( new BitmapData( 12, 4, true, bclr[ ch.chParty ].bar ) )
            barBmp.x = 10
            barBmp.y = 1
            //barBmp.alpha = 0.7
            
            for ( var i:int = 0 ; i < 4; i++ ) { barBmp.bitmapData.setPixel32( obj.w[i], obj.h[i], bclr.Box ); } //描画
            sta.addChild( barBmp ) //表示
                        
            ch.chSp.addChild( sta )
            staMove( new Event( "MoveXY") )
            steChBar( new Event( "SteChange") )
        }//staAdd
        
        //*--HPバー削除
        public function staRemove( event:Event ):void
        {
            ch.removeEventListener( "Add", staAdd )
            ch.removeEventListener( "Remove", staRemove )
            ch.removeEventListener( "MoveXY", staMove )
            ch.removeEventListener( "SteChange", steChBar)
            ch.chSp.removeChild( sta )
            sta = null
        }//staRemve
        
        //*--HPバー移動
        public function staMove( event:Event ):void
        {
            sta.x = ch.x
            sta.y = ch.y
        }
        
        //*--HP変化表示
        public function steChBar( event:Event ):void
        {
            var dot:int = ch._HP / ch.maxHP * 10
            var fclr:int = bclr[ ch.chParty ].front
            var rclr:int = bclr[ ch.chParty ].rest
            
            for ( var w:int = 1; w <= 10; w++ )
            {
                if ( dot >= w ) { for ( var hf:int = 1 ; hf <= 2 ; hf++ ) { barBmp.bitmapData.setPixel32( w, hf, fclr ); } }
                else { for ( var hb:int = 1 ; hb <= 2 ; hb++ ) { barBmp.bitmapData.setPixel32( w, hb, rclr ); } }
            }
                    
        }//chBar
    }//CharaStatus
//}package

/* ---------------------------------------------------------------------------
 * CharaPartyMain
 * --------------------------------------------------------------------------- */
//package
//{
    
    /**-public**/ class CharaPartyMain
    {
        private var main:AsMain
        
        public var partyId:int
        public var partylen:int
        public var chPartyAry:Array = [ ]
        
        /**
         * --コンストラクタ
         **/
        public function CharaPartyMain( _main:AsMain, _partyId:int ):void 
        {
            main = _main
            partyId = _partyId
        }//CharaPartyMain
        
        // *--パーティキャラの登録
        public function chpEntry( chara:CharaMain ):void
        {
            chPartyAry.push( chara )
            partylen = chPartyAry.length
            //trace( "add", partyId, partylen )    
        }//chEntry
        
        // *--パーティキャラの解除
        public function chpCancell( chara:CharaMain ):void
        {
            var ary:Array = chPartyAry.slice()
            chPartyAry = [ ]
                        
            for ( var i:int = 0; i < partylen; i++ )
            {
                if ( ary[i].xv != chara.xv && ary[i].yv != chara.yv ) { chPartyAry.push( ary[ i ] ) }
            }
                        
            partylen = chPartyAry.length
            //trace( "dei", partyId, partylen )    
        }//chCancell
        
        // *--サーチの共有
        public function serchJointly( chara:CharaMain ):void
        {            
            rn:for ( var i:int = 0; i < partylen; i++ )
            {
                if ( chPartyAry[i] == null ) { continue rn }
                if ( chPartyAry[i] == chara ) { continue rn }
                
                var cha:CharaMain = chPartyAry[i]
                var shlen:int = cha.chShAry.length
                                                
                rd:for ( var j:int = 0; j < shlen; j++ )
                {
                    var obj:Object = cha.chShAry[ j ]
                    var tage:CharaMain = obj.tage
                    
                    if ( tage._HP <= 0 ) { continue rd }
                    
                    var chShlen:int = chara.chShAry.length                
                    for ( var d:int = 0; d < chShlen; d++ ) //すでに登録されていないかﾁｪｯｸ
                    {
                        var cktg:CharaMain = chara.chShAry[d].tage
                        if ( cktg.xv == tage.xv && cktg.yv == tage.yv ) { continue rd }
                    }
                    
                    var h:int = main.myabs( tage.xv  - chara.xv ) + main.myabs( tage.yv - chara.yv )
                    if ( h > 10 ) { continue rd } //共有範囲限定
                    
                    var gv:int = tage.zv - chara.zv //ターゲットとの高低差
                    
                    chara.chShAry.push( { tage:tage, hc:h, gp:gv, sot:tage[ chara.chStObj.str] } )
                }
            }
            
            //trace( " ")
        }//serchJointly
        
    }//class CharaPartyMain
//}package


/* ---------------------------------------------------------------------------
 * ArtifactMain
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    
    /**-public**/ class ArtifactMain extends Bitmap
    {
        public var main:AsMain
        public var artifact:ArtifactMain
        public var atSp:Sprite
        
        public function ArtifactMain( _main:AsMain, atNum:int, obj:Object, sv:int, zv:int ):void
        {
            main = _main
            artifact = this
            
            artifact.bitmapData = main.chipObj["Artifact"][atNum]
            artifact.y = ( zv + 1 ) * -3
            
            atSp = main.getAdd( sv + 2 )
            atSp.x = obj.wv + main.mapW;
            atSp.y = obj.hv + main.mapH;
            
            main.atctl( obj.xv, obj.yv )
            atSp.addChild( artifact )
            
        }//ArtifactMain
    }//class ArtifactMain
//}package


/* ---------------------------------------------------------------------------
 * ArtifactCrystal
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.events.*;
    import flash.display.*;
    
    /**-public**/ class ArtifactCrystal extends Bitmap //--ポインター表示関連
    {
        //*--クラスとステージ関連
        public var main:AsMain
        public var cry:ArtifactCrystal
        public var baseSp:Sprite
        
        //*--クリスタル表示表示用
        public var crySp:Sprite //キャラ表示アクセス
        public var cryObj:Object
        public var fre:int
                
        //*--コントラクタ
        public function ArtifactCrystal( _main:AsMain, xk:int, yk:int ):void
        {
            var objMap:Object = _main.mapObj[ xk ][ yk ] //mapObj関連付け    
            main = _main
            cry = this
            baseSp = main.baseSp
            
            //*--初期位置
            main.atctl( xk, yk )
            cryObj = main.chipObj["Crystal"];
            crySp = main.getAdd( objMap.swap.ch )
            crySp.addChild( cry );
            
            cry.x = objMap.poin.w + main.charaW;
            cry.y = objMap.poin.h + main.charaH - objMap.map.z * 3;
            cry.addEventListener( Event.ENTER_FRAME, crystalFre );
        }//ArtifactCrystal
                
        //*---マップポイントのビットマップ表示格納
        public function crystalFre( event:Event ):void //ポインター
        {
            if ( ++fre == 1 ) cry.bitmapData = cryObj[1];
            if ( fre == 12 ) cry.bitmapData = cryObj[2];
            if ( fre == 24 ) cry.bitmapData = cryObj[1];
            if ( fre == 36 ) cry.bitmapData = cryObj[3];
            if ( fre == 48 ) { fre = 0; }
            
        }//crystalFre
            
    }//class ArtifactCrystal
//}package


/* ---------------------------------------------------------------------------
 * MapAdd
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    import flash.geom.*;
        
    /**-public**/ class MapAdd
    {
        protected var main:AsMain
        
        /**
         *--コントラクタ マップオブジェに一つ一つアクセスできるようなクラスを作る　もっとマップ生成を楽にできるように
         **/
        public function MapAdd( _main:AsMain ):void { main = _main }//MapAdd
        //( mapInt >> 16 ) & 0xFF;　高さ
        //( mapInt >> 8 ) & 0xFF;　チップナンバー
        //( mapInt >> 0 ) & 0xFF;　アーティファクトナンバー
        
        //*--x5*y5マップ
        public function mapMake_5_5():Object
        {            
            return {
            
            dataP:{ x:5, y:5 },
            
            dataC:[ ,
            [ 0x000E01, 0x000E01, 0x000E00, 0x000E02, 0x000E02,,].reverse(),
            [ 0x000E00, 0x000E00, 0x000E00, 0x020E02, 0x000E00,,].reverse(),
            [ 0x000F00, 0x030F00, 0x010E00, 0x020E00, 0x000E00,,].reverse(),
            [ 0x000E00, 0x000E04, 0x000E00, 0x000E00, 0x000E00,,].reverse(),
            [ 0x010E00, 0x010E00, 0x020E03, 0x000E00, 0x000E00,,].reverse()]}        
        }
                
        //public function mapMake_5_5z():Object
        //{
            //
        //}
        
        //*--x10*y10マップ
        public function mapMake_10_5():Object
        {
            return {
            
            dataP:{ x:10, y:5 },
                
            dataC:[ ,
            [ 0x000E01, 0x000E01, 0x000E00, 0x000E02, 0x000E02,,].reverse(),
            [ 0x000E00, 0x000E00, 0x000E00, 0x020E02, 0x000E00,,].reverse(),
            [ 0x000F00, 0x030F00, 0x010E00, 0x020E00, 0x000E00,,].reverse(),
            [ 0x000E00, 0x000E04, 0x000E00, 0x000E00, 0x000E00,,].reverse(),
            [ 0x010E00, 0x010E00, 0x020E03, 0x000E00, 0x000E00,,].reverse(),
            [ 0x000E00, 0x000E00, 0x000E00, 0x000E02, 0x000E02,,].reverse(),
            [ 0x000E00, 0x000E00, 0x000E00, 0x020E02, 0x000E00,,].reverse(),
            [ 0x000F00, 0x030F00, 0x010E00, 0x020E00, 0x000E00,,].reverse(),
            [ 0x000E00, 0x000E04, 0x000E00, 0x000E00, 0x000E00,,].reverse(),
            [ 0x010E00, 0x010E00, 0x020E03, 0x000E00, 0x000E00,,].reverse()]}
        }
        
        //*--x10*y10マップ
        public function mapMake_10_10():Object
        {
            return {
            
            dataP:{ x:10, y:10 },
                
            dataC:[ ,
            [ 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x010200, 0x020200, 0x010200,,].reverse(),
            [ 0x000200, 0x040A00, 0x050A00, 0x000E00, 0x000E00, 0x000E00, 0x000E00, 0x000400, 0x000400, 0x020200,,].reverse(),
            [ 0x000200, 0x030A00, 0x020A00, 0x000E00, 0x000E00, 0x000E00, 0x000E00, 0x000400, 0x000400, 0x010200,,].reverse(),
            [ 0x000200, 0x000E00, 0x010F00, 0x001000, 0x001000, 0x001000, 0x001000, 0x000E00, 0x000E00, 0x000200,,].reverse(),
            [ 0x000200, 0x000E00, 0x000E00, 0x001000, 0x001000, 0x001000, 0x001000, 0x000E00, 0x000E00, 0x000200,,].reverse(),
            [ 0x000200, 0x000E00, 0x000E00, 0x001000, 0x001000, 0x001000, 0x001000, 0x000E00, 0x000E00, 0x000200,,].reverse(),
            [ 0x000200, 0x000E00, 0x000E00, 0x001000, 0x001000, 0x001000, 0x001000, 0x000E00, 0x000E00, 0x000200,,].reverse(),
            [ 0x000200, 0x000300, 0x000300, 0x000E00, 0x000E00, 0x000E00, 0x010F00, 0x021600, 0x051600, 0x000200,,].reverse(),
            [ 0x000200, 0x000300, 0x000300, 0x000E00, 0x000E00, 0x000E00, 0x000E00, 0x031600, 0x041600, 0x000200,,].reverse(),
            [ 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200, 0x000200,,].reverse()]}
        }
        
        //*--x10*y10マップ
        public function mapMake_10_10z():Object
        {
            return {
            
            dataP:{ x:10, y:10 },
                
            dataC:[ ,
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse()]}
        }
        
        //*--x10*y10マップ
        public function mapMake_30_30():Object
        {
            return {
            
            dataP:{ x:30, y:30 },
                
            dataC:[ ,
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse()]}
        }
        
        //*--x10*y10マップ
        public function mapMake_25_25():Object
        {
            return {
            
            dataP:{ x:25, y:25 },
                
            dataC:[ ,
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse(),
            [ 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00, 0x000D00,,].reverse()]}
        }
        /**
         *--main.mapObjに情報格納 メモ：もっと見やすく組み直し
         **/
        public function mapMake():void
        {
            //*--マップ読込み
            var mapData:Object = mapMake_10_10() 
            //var mapData:Object = mapMake_10_10z() 
            //var mapData:Object = mapMake_10_5()
            //var mapData:Object = mapMake_5_5() //マップ読込み
            //var mapData:Object = mapMake_25_25()
            
            //*--座標初期処理
            main.mapAdj( mapData )
            
            //*--マップ情報の表示と格納
            var sortAry:Array = mapAlign( mapData ) //マップ位置情報格納
            mapInfoStorage( sortAry )
            mapFrame( sortAry )
        }//MapMake
        
        /**
         *--マップ配置情報格納 深度、座標
         **/
        public function mapAlign( mapData:Object ):Array
        {
            var sortAry:Array = [ ]
            for ( var xp:int=1; xp <= main.mapx; xp++ )
            {
                main.mapObj[xp] = { }
                for ( var yp:int= 1; yp <= main.mapy; yp++ )
                {
                    var cd:int = ((( xp + yp - 1) & 0xff ) << 16 | ( xp & 0xff ) << 8 | ( yp & 0xff ) << 0 ) //X軸、Y軸、Z軸を16進法に変換
                    var wd:int = ( xp - yp - 2 ) * 12
                    var hd:int = ( xp + yp - 2 ) * 6
                    
                    var mapInt:int = mapData.dataC[xp][yp]
                    
                    var zp:int = ( mapInt >> 16 ) & 0xFF;
                    var fp:int = ( mapInt >> 8 ) & 0xFF;
                    var atp:int = ( mapInt >> 0 ) & 0xFF;
                    
                    main.mapObj[xp][yp] = { }
                    sortAry.push( { cv:cd, wv:wd, hv:hd, xv:xp, yv:yp, zv:zp, fv:fp, atv:atp } )
                }
            }
            
            return sortAry.sortOn( "cv", Array.NUMERIC ) //深度を奥から描画していくためソートしてリターン
        }
        
        /**
         *--マップ情報格納、マップ表示
         **/
        public function mapInfoStorage( sortAry:Array ):void
        {
            var sortLen:int = sortAry.length
            var chpMap:Object = main.chipObj["MapFace"]
            
            //*--マップ情報格納、マップ表示
            for ( var v:int = 0 ; v < sortLen ; v++ )
            {
                var obj:Object = sortAry[v]
                var face:int = obj.fv
                var atv:int = obj.atv
                var wv:int = obj.wv
                var hv:int = obj.hv
                var xv:int = obj.xv
                var yv:int = obj.yv
                var zv:int = obj.zv
                var sv:int = v * 4 + 1
                
                //*--管理情報格納
                main.mapObj[xv][yv] =
                {
                    map: { x:xv, y:yv, z:zv },
                    poin: { w:wv, h:hv },
                    swap: { mp:sv, pn:sv + 1, ch:sv + 2, ef:sv + 3 }, //マップ、ポインタ、キャラ、エフェクトの標準深度
                    dcost: { 1:0, 2:0 },
                    ctl: main.noMapObj
                }
                
                //*--マップ、ポイント、キャラ、エフェクト深度用の空スプリット
                for ( var s:int = 0; s <= 3; s++ ) { main.baseSp.addChild( new Sprite ) }
                var spr:Sprite = main.getAdd( sv )  //main.baseSp.getChildAt( sv ) as Sprite
                spr.x = wv + main.mapW;
                spr.y = hv + main.mapH;
                
                //*--マップ表示
                var zp:int = 3 * zv
                var clipBmd:BitmapData = new BitmapData( main.chipSize, 16 + zp, true, 0x00ffffff );//0x00ffffff 0x0F0000FF
                var clipBmp:Bitmap = new Bitmap( clipBmd );
                var bmd:BitmapData = chpMap[face]
                
                obj.bmd = clipBmd //縁用表示用にsortAryにBitmapDataを格納しておく
                clipBmp.y = 14 - zp
                spr.addChild( clipBmp )
                
                for ( var i:int = zv ; i >= 0 ; i-- )
                {
                    main.point.y = -14 + i * 3
                    clipBmd.copyPixels( bmd, bmd.rect, main.point, null, null, true );
                }
                
                //*--Artifact表示 
                if ( atv != 0 ){ new ArtifactMain( main, atv, obj , sv, zv ) }
            }
        }
        
        /**
         *--マップ縁　段差縁　表示
         **/
        public function mapFrame( sortAry:Array ):void
        {
            var sortLen:int = sortAry.length
            for ( var v:int = 0 ; v < sortLen ; v++ )
            {
                var objs:Object = sortAry[v]
                var xp:int = objs.xv
                var yp:int = objs.yv
                var zp:int = objs.zv
                var bmd:BitmapData = objs.bmd
                                
                rb: for ( var i:int = 1; i <= 4; i++ )
                {
                    var obj:Object = main.mapCkObj( xp + main.vecx[i], yp + main.vecy[i] )
                    var dBln:Boolean = ( obj.map == null )? true : false
                    var cBln:Boolean = ( i > 2 )? true : false
                    if ( dBln && cBln ) { fraAdd( bmd, zp, i ) } //外枠上
                    else if ( dBln && !cBln ) { fraAdd( bmd, zp, i, false ) } //外枠下
                    else if ( zp - obj.map.z > 0 && cBln ) { fraAdd( bmd, zp, i ) } //段差上
                }
            }
            
            main.point.y = 0 //メインポイントの初期化
        }//mapFrame
        
        public function fraAdd( bmd:BitmapData, zp:int, i:int, bln:Boolean = true ):void
        {
            var bmdF:BitmapData = main.chipObj["Frame"][ i ]
            if ( bln ) { main.point.y = -14 } else { main.point.y = -14 + zp * 3 }
            bmd.copyPixels( bmdF, bmdF.rect, main.point, null, null, true );
        }//frameAdd
        
    }//class MapAdd
//}package


/* ---------------------------------------------------------------------------
 * MapAtObj
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    
    /**-public**/ class MapAtObj
    {
        protected var main:AsMain
        
        /**
         *--コントラクタ マップアーティファクトの整理格納
        **/
        public function MapAtObj( _main:AsMain ):void
        {
            main = _main
            var atObj:Object = main.bmdObj[main.mapNum].retnObj() //画像読込chipObjに格納
                        
            main.chipObj["MapFace"] = atStorage( atObj , 0 , 23) //マップ    
            main.chipObj["Frame"] = atStorage( atObj , 24 , 29) //マップ    
            main.chipObj["Pointer"] = atStorage( atObj , 30, 35) //ポイント
            main.chipObj["Crystal"] = atStorage( atObj , 36, 41) //クリスタル
            main.chipObj["Artifact"] = atStorage( atObj , 42, 53) //アーティファクト
            
        }//MapAtObj
        
        public function atStorage( atObj:Object, v:int, w:int ):Object
        {
            var acObj:Object = { }
            var num:int
            
            for ( var i:int = v; i <= w; i++){ acObj[++num] = atObj[i] }
            
            return acObj
        }//atStorage    
    }//class MapAtObj
//}package


/* ---------------------------------------------------------------------------
 * MapFont
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    import flash.geom.*;
    
    /**-public**/ class MapFont
    {
        public var main:AsMain
                
        public function MapFont( _main:AsMain ):void
        {
            main = _main
            
            //*--カラーフォントを格納
            var fontObj:Object = main.bmdObj[main.ftNum].retnObj()
            main.fontObj["W"] = fontObj//0xffffffff
            main.fontObj["R"] = colorChange( fontObj, 0xffffc8c8 )
            main.fontObj["G"] = colorChange( fontObj, 0xffc8ffc8 )
            main.fontObj["B"] = colorChange( fontObj, 0xffc8c8ff )
        }//FontDrow
            
        public function colorChange( Obj:Object, colr:int ):Object
        {
            var colorObj:Object = { }
            
            for ( var i:int = 0 ; i <= 95 ; i++ )
            {                    
                var fot:BitmapData = Obj[i].clone()
                
                for ( var w:int = 0 ; w <= main.chipFont ; w++ )
                {
                    for ( var h:int = 0 ; h <= main.chipFont ; h++ )
                    {
                        if ( fot.getPixel32(w,h) == 0xffffffff ){ fot.setPixel32(w,h,colr); } //白部分を指定の色に書変え
                    }
                }
                
                colorObj[i] = fot
            }
            
            return colorObj
        }//colorChange
        
    }//class MapFont
//}package


/* ---------------------------------------------------------------------------
 * MapFontPop
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    
    /**-public**/ class MapFontPop
    {
        protected var main:AsMain
        
        private var regExp:RegExp = new RegExp( "@", "g")
        private var decoder:String = 
        "0123456789"+  
        "ABCDEFGHIJKLMNOPQRSTUVWXYZ"+
        "abcdefghijklmnopqrstuvwxyz"+
        ".()[]#$%&'\"!?^+-*/=;:_<> "
        
        private var zure:Array = 
        [
            3,4,3,3,3,3,3,3,3,3,
            2,2,2,2,2,2,2,2,4,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,2,
            3,4,4,4,4,4,4,4,6,5,4,5,2,4,4,4,4,4,4,4,4,4,2,4,4,4,
            6,1,0,1,0,2,2,2,2,4,2,3,2,2,2,2,2,2,1,3,4,2,1,0,4,
        ]
        
        //*--コントラクタ
        public function MapFontPop( _main:AsMain ):void { main = _main }//FontDrow
                
        public function popFont( sP:Sprite, msg:String, xv:int, yv:int, color:String, freBln:Boolean = true, ap:Number = 1 ):void
        {

            var xp:int //位置修正
            var yp:int //位置修正
            var fontObj:Object = main.fontObj[color]
            
            var ary:Array = msg.match( regExp )//改行確認
            var msglen:int = msg.length
            var arylen:int = ary.length + 1
            var bmp:Bitmap = new Bitmap( new BitmapData( 7 * msglen,  8 * arylen, true, 0xffffff ) )
            
            if( freBln ){ new dFontPop( bmp ); } //ポップするか判定
                        
            sP.addChild( bmp )
            bmp.x = xv
            bmp.y = yv
            bmp.alpha = ap
            trace(color)
            for(var i:int = 0; i < msglen; i++)//文字の描画
            {
                if ( msg.charAt( i ) == "@" )//改行確認
                {
                    xp = 0;
                    yp = yp + 8;
                    continue
                }
                trace("tes2")
                var id:int = decoder.indexOf( msg.charAt( i ) ); //文字列decoderの位置
                trace(fontObj[id])
                var ftBmd:BitmapData = fontObj[id]
                trace("tes4")
                bmp.bitmapData.copyPixels( ftBmd, ftBmd.rect, new Point( xp, yp ), null, null, true );
                xp += main.chipFont - zure[id] //次の文字位置修正

            }
            
        }//MapFontPop
    }//class MapFontPop
//}package


/* ---------------------------------------------------------------------------
 * dFontPop
 * --------------------------------------------------------------------------- */
//package
//{
    import flash.display.*;
    import flash.events.*;
        
    /**-public**/ class dFontPop extends Bitmap
    {
        public var bmp:Bitmap
        public var num:int
        
        public function dFontPop( _bmp:Bitmap ):void
        {
            bmp = _bmp
            bmp.addEventListener( Event.ENTER_FRAME, ugoki )
        }
        
        public function ugoki( event:Event ):void
        {            
            bmp.y -= 1
            
            if ( num++ == 20 )
            {
                bmp.removeEventListener( Event.ENTER_FRAME, ugoki )
                bmp.parent.removeChild( bmp )
                bmp = null
            }
        }
    }// class dFontPop
//}package
    

/* ---------------------------------------------------------------------------
 * MapPointer
 * --------------------------------------------------------------------------- */
//package
//{
    //import com.utils.EventGroup;
    import flash.display.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.ui.*;
    
    /**-public**/ class MapPointer extends Sprite //--ポインター表示関連
    {
        //*--クラスとステージ関連
        protected var main:AsMain
        
        //*--ポイント表示用
        public var bmp:Bitmap = new Bitmap
        public var pObj:Object
        public var objps:Object
        public var fre:int
        
        //*--座標保存
        public var xv:int
        public var yv:int
        public var xb:int
        public var yb:int
        
        //*--文字表示用
        public var paraX:int; //パラメータ表示位置基準
        public var paraY:int; //パラメータ表示位置基準
        public var steSp:Sprite = new Sprite
        
        //*--タゲポイント表示用
        public var tbmp:Bitmap = new Bitmap
        public var gFilter:GlowFilter = new GlowFilter( 0xFFFFFF, 1, 3, 3, 100 )
        public var fre2:int
        public var blnCh:Boolean
        public var cha:CharaMain
        
        //*--コントラクタ
        public function MapPointer( _main:AsMain ):void{ main = _main; }//MapPoint
        
        //*--表示登録
        public function mapPointer():void
        {
            paraX = main.sT.stageWidth / 2 - main.mapx * 12 - 0 //パラメータ表示位置基準
            paraY = main.sT.stageHeight / 2 + main.mapy * 6 + 3 //パラメータ表示位置基準
            
            main.baseSp.addChild( steSp ); //文字表示用
            pObj = main.chipObj["Pointer"]; //オブジェクト格納
            
            addPoin() //ポイント初期化            
            addTagePoin()    //タゲポイント初期化
        }//mapPointer
        
        public function addPoin():void
        {
            main.baseSp.addChild( bmp );
            bmp.visible = false
            bmp.addEventListener( Event.ENTER_FRAME, poinFre );
            
            main.baseSp.addEventListener( MouseEvent.MOUSE_MOVE, moveP );
        }//poinAdd
        
        //*---マップポイントのビットマップ表示格納
        public function poinFre( event:Event ):void //ポインター
        {
            if ( ++fre == 1 ) bmp.bitmapData = pObj[1];
            if ( fre == 6 ) bmp.bitmapData = pObj[2];
            if ( fre == 12 ) bmp.bitmapData = pObj[3];
            if ( fre == 18 ){ fre = 0; }
        }//poinFre
        
        //*---マップポイント表示
        public function moveP( event:MouseEvent ):void
        {
            var xd:Number = ( main.sT.mouseX - main.poinW )/24;
            var yd:Number = ( main.sT.mouseY - main.poinH )/12;
            xv = Math.ceil( main.myabs( xd + yd ) ) - 1
            yv = Math.ceil( main.myabs( xd - yd ) ) - 1
            
            if ( xb == xv && yb == yv ) { return }//前回のポイントと同じかチェック
            
            steRemve()
            
            if ( main.mapOut( xv, yv ) ) { poinShow() } else { poinHide() }
            
        }//moveP
        
        public var basAry:Array = [ ]
        public var chAry:Array = [ ]
        public var mpObj:Object = { 0:[ 0, 1], 1:[ 1, 0], 2:[ 1, 1] }
        
        public function poinShow():void
        {
            main.mainBln = false
            objps = main.mapObj[xv][yv];
            
            Mouse.hide()
            bmp.visible = true
            bmp.x = objps.poin.w + main.mapW;
            bmp.y = objps.poin.h + main.mapH - objps.map.z * 3;
            
            main.baseSp.swapChildrenAt( main.baseSp.getChildIndex( bmp ), objps.swap.pn );//深度を変換
            testAlpha()
            
            //*--文字表示
            var pra2:String = "@T:" + ( ( objps.ctl.num == 1 )? "NORMAL" : objps.ctl.ch.chTyName )
            var pra1:String = "X:" + objps.map.x + " Y:" +objps.map.y + " Z:" + objps.map.z
            var praT:String = " P1:" + objps.dcost[1] + " P2:" + objps.dcost[2]
                
            main.fontPop( steSp,  pra1 + pra2 + praT, paraX, paraY, "W", false);
        }//poinShow
        
        public function poinHide():void
        {
            main.mainBln = true
            Mouse.show()
            bmp.visible = false
        }//poinHide
        
        /**
         *--前のオブジェクトを透過する
         *--前の２マスを透過するほうがよいか？
        **/        
        public function testAlpha():void
        {
            for ( var i:int = 0; i < 3; i++ )
            {
                var nx:int = objps.map.x + mpObj[i][0]
                var ny:int = objps.map.y + mpObj[i][1]
                var obj:Object = main.mapCkObj( nx, ny ) //方向の管理情報
                
                if ( obj.map == null ) { continue }
                
                var gp:int = obj.map.z - objps.map.z
                if ( gp <= 2 ) { continue }
                
                var basSpt:Sprite = main.getAdd( obj.swap.mp )
                var chSpt:Sprite = main.getAdd( obj.swap.ch )
                    
                basSpt.alpha = 0.3
                chSpt.alpha = 0.3
                    
                basAry[i] = basSpt
                chAry[i] = chSpt
            }
            
        }
                        
        public function steRemve():void
        {
            for ( var i:int = 0; i < 3; i++ )
            {
                if ( basAry[i] != null && chAry[i] != null )
                {
                    basAry[i].alpha = 1
                    chAry[i].alpha = 1
                    basAry[i] = null
                    chAry[i] = null
                }            
            }
            
            xb = xv
            yb = yv
            
            if ( steSp.numChildren != 0 ) { steSp.removeChildAt( 0 ) }
        }//steRemve
        
        /**
         *--ターゲットポインター
        **/
        public function addTagePoin():void
        {
            main.baseSp.addChild( tbmp );
            tbmp.visible = false
            tbmp.addEventListener( Event.ENTER_FRAME, tpoinFre );
            
            main.baseSp.addEventListener( MouseEvent.CLICK, testC )
            main.sT.addEventListener( MouseEvent.MOUSE_DOWN, testD )
        }
        
        public function tpoinFre( event:Event ):void //ターゲットポインター
        {
            if ( ++fre2 == 1 ) tbmp.bitmapData = pObj[4];
            if ( fre2 == 12 ) tbmp.bitmapData = pObj[5];
            if ( fre2 == 24 ) tbmp.bitmapData = pObj[6];
            if ( fre2 == 36 ){ fre2 = 0; }
        }//poinFre
        
        public function testC( event:MouseEvent ):void
        {
            if ( !bmp.visible ) { return }
            
            var chSp:Sprite = main.getAdd( objps.swap.ch )
            
            //*--キャラの移動
            if ( blnCh && chSp.numChildren == 0 )
            {
                cha.chRoot = [ ];
                cha.chAstar( xv, yv, false )
                return
            }
            
            blnCh = ( objps.ctl.num == 2 && objps.ctl.ch.chParty == 1 )? true : false
                        
            if ( blnCh )
            {
                if ( cha != null ){ cha.filters = null }
                tbmp.visible = true
                cha = objps.ctl.ch                
                cha.filters = [ gFilter ]
                cha.addEventListener( "MoveXY", moveXY )
                cha.addEventListener( "Remove", remove )
                testMove()
            }
            
            if ( blnCh ) { charaSte() }
        }//testC
        
        public function charaSte():void 
        {
            trace( "LV :" + cha._LV, "HP :" + cha._HP, "AT :" + cha._AT )
        }
        
        public function moveXY( event:Event ):void { testMove() }
        public function remove( event:Event ):void { removeTp() }
        
        public function testD( event:MouseEvent ):void
        {
            if ( blnCh && !bmp.visible ) { removeTp() }
        }
        
        public function testMove( ):void
        {
            tbmp.x = cha.x + 14;
            tbmp.y = cha.y - 16;
        }
        
        public function removeTp():void
        {
            tbmp.visible = false
            blnCh = false
            cha.filters = null
            cha.removeEventListener( "MoveXY", moveXY )
            cha.removeEventListener( "Remove", remove )
            if ( cha != null ){ cha.filters = null }
        }
        
    }//class MapPointer
//}package

